/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.services.backup.model.FrameworkControl;
import software.amazon.awssdk.services.backup.model.FrameworkControlsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFrameworkRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, UpdateFrameworkRequest> {
    private static final SdkField<String> FRAMEWORK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FrameworkName").getter(UpdateFrameworkRequest.getter(UpdateFrameworkRequest::frameworkName)).setter(UpdateFrameworkRequest.setter(Builder::frameworkName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("frameworkName").build()}).build();
    private static final SdkField<String> FRAMEWORK_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FrameworkDescription").getter(UpdateFrameworkRequest.getter(UpdateFrameworkRequest::frameworkDescription)).setter(UpdateFrameworkRequest.setter(Builder::frameworkDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkDescription").build()}).build();
    private static final SdkField<List<FrameworkControl>> FRAMEWORK_CONTROLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FrameworkControls").getter(UpdateFrameworkRequest.getter(UpdateFrameworkRequest::frameworkControls)).setter(UpdateFrameworkRequest.setter(Builder::frameworkControls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkControls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FrameworkControl::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdempotencyToken").getter(UpdateFrameworkRequest.getter(UpdateFrameworkRequest::idempotencyToken)).setter(UpdateFrameworkRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAMEWORK_NAME_FIELD, FRAMEWORK_DESCRIPTION_FIELD, FRAMEWORK_CONTROLS_FIELD, IDEMPOTENCY_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateFrameworkRequest.memberNameToFieldInitializer();
    private final String frameworkName;
    private final String frameworkDescription;
    private final List<FrameworkControl> frameworkControls;
    private final String idempotencyToken;

    private UpdateFrameworkRequest(BuilderImpl builder) {
        super(builder);
        this.frameworkName = builder.frameworkName;
        this.frameworkDescription = builder.frameworkDescription;
        this.frameworkControls = builder.frameworkControls;
        this.idempotencyToken = builder.idempotencyToken;
    }

    public final String frameworkName() {
        return this.frameworkName;
    }

    public final String frameworkDescription() {
        return this.frameworkDescription;
    }

    public final boolean hasFrameworkControls() {
        return this.frameworkControls != null && !(this.frameworkControls instanceof SdkAutoConstructList);
    }

    public final List<FrameworkControl> frameworkControls() {
        return this.frameworkControls;
    }

    public final String idempotencyToken() {
        return this.idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFrameworkControls() ? this.frameworkControls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFrameworkRequest)) {
            return false;
        }
        UpdateFrameworkRequest other = (UpdateFrameworkRequest)((Object)obj);
        return Objects.equals(this.frameworkName(), other.frameworkName()) && Objects.equals(this.frameworkDescription(), other.frameworkDescription()) && this.hasFrameworkControls() == other.hasFrameworkControls() && Objects.equals(this.frameworkControls(), other.frameworkControls()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFrameworkRequest").add("FrameworkName", (Object)this.frameworkName()).add("FrameworkDescription", (Object)this.frameworkDescription()).add("FrameworkControls", this.hasFrameworkControls() ? this.frameworkControls() : null).add("IdempotencyToken", (Object)this.idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FrameworkName": {
                return Optional.ofNullable(clazz.cast(this.frameworkName()));
            }
            case "FrameworkDescription": {
                return Optional.ofNullable(clazz.cast(this.frameworkDescription()));
            }
            case "FrameworkControls": {
                return Optional.ofNullable(clazz.cast(this.frameworkControls()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("frameworkName", FRAMEWORK_NAME_FIELD);
        map.put("FrameworkDescription", FRAMEWORK_DESCRIPTION_FIELD);
        map.put("FrameworkControls", FRAMEWORK_CONTROLS_FIELD);
        map.put("IdempotencyToken", IDEMPOTENCY_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFrameworkRequest, T> g) {
        return obj -> g.apply((UpdateFrameworkRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private String frameworkName;
        private String frameworkDescription;
        private List<FrameworkControl> frameworkControls = DefaultSdkAutoConstructList.getInstance();
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFrameworkRequest model) {
            super(model);
            this.frameworkName(model.frameworkName);
            this.frameworkDescription(model.frameworkDescription);
            this.frameworkControls(model.frameworkControls);
            this.idempotencyToken(model.idempotencyToken);
        }

        public final String getFrameworkName() {
            return this.frameworkName;
        }

        public final void setFrameworkName(String frameworkName) {
            this.frameworkName = frameworkName;
        }

        @Override
        public final Builder frameworkName(String frameworkName) {
            this.frameworkName = frameworkName;
            return this;
        }

        public final String getFrameworkDescription() {
            return this.frameworkDescription;
        }

        public final void setFrameworkDescription(String frameworkDescription) {
            this.frameworkDescription = frameworkDescription;
        }

        @Override
        public final Builder frameworkDescription(String frameworkDescription) {
            this.frameworkDescription = frameworkDescription;
            return this;
        }

        public final List<FrameworkControl.Builder> getFrameworkControls() {
            List<FrameworkControl.Builder> result = FrameworkControlsCopier.copyToBuilder(this.frameworkControls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFrameworkControls(Collection<FrameworkControl.BuilderImpl> frameworkControls) {
            this.frameworkControls = FrameworkControlsCopier.copyFromBuilder(frameworkControls);
        }

        @Override
        public final Builder frameworkControls(Collection<FrameworkControl> frameworkControls) {
            this.frameworkControls = FrameworkControlsCopier.copy(frameworkControls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frameworkControls(FrameworkControl ... frameworkControls) {
            this.frameworkControls(Arrays.asList(frameworkControls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frameworkControls(Consumer<FrameworkControl.Builder> ... frameworkControls) {
            this.frameworkControls(Stream.of(frameworkControls).map(c -> (FrameworkControl)((FrameworkControl.Builder)FrameworkControl.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFrameworkRequest build() {
            return new UpdateFrameworkRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFrameworkRequest> {
        public Builder frameworkName(String var1);

        public Builder frameworkDescription(String var1);

        public Builder frameworkControls(Collection<FrameworkControl> var1);

        public Builder frameworkControls(FrameworkControl ... var1);

        public Builder frameworkControls(Consumer<FrameworkControl.Builder> ... var1);

        public Builder idempotencyToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

