/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.MpaSessionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LatestMpaApprovalTeamUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LatestMpaApprovalTeamUpdate> {
    private static final SdkField<String> MPA_SESSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MpaSessionArn").getter(LatestMpaApprovalTeamUpdate.getter(LatestMpaApprovalTeamUpdate::mpaSessionArn)).setter(LatestMpaApprovalTeamUpdate.setter(Builder::mpaSessionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MpaSessionArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(LatestMpaApprovalTeamUpdate.getter(LatestMpaApprovalTeamUpdate::statusAsString)).setter(LatestMpaApprovalTeamUpdate.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(LatestMpaApprovalTeamUpdate.getter(LatestMpaApprovalTeamUpdate::statusMessage)).setter(LatestMpaApprovalTeamUpdate.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<Instant> INITIATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InitiationDate").getter(LatestMpaApprovalTeamUpdate.getter(LatestMpaApprovalTeamUpdate::initiationDate)).setter(LatestMpaApprovalTeamUpdate.setter(Builder::initiationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiationDate").build()}).build();
    private static final SdkField<Instant> EXPIRY_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpiryDate").getter(LatestMpaApprovalTeamUpdate.getter(LatestMpaApprovalTeamUpdate::expiryDate)).setter(LatestMpaApprovalTeamUpdate.setter(Builder::expiryDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiryDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MPA_SESSION_ARN_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, INITIATION_DATE_FIELD, EXPIRY_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LatestMpaApprovalTeamUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String mpaSessionArn;
    private final String status;
    private final String statusMessage;
    private final Instant initiationDate;
    private final Instant expiryDate;

    private LatestMpaApprovalTeamUpdate(BuilderImpl builder) {
        this.mpaSessionArn = builder.mpaSessionArn;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.initiationDate = builder.initiationDate;
        this.expiryDate = builder.expiryDate;
    }

    public final String mpaSessionArn() {
        return this.mpaSessionArn;
    }

    public final MpaSessionStatus status() {
        return MpaSessionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Instant initiationDate() {
        return this.initiationDate;
    }

    public final Instant expiryDate() {
        return this.expiryDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mpaSessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiryDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LatestMpaApprovalTeamUpdate)) {
            return false;
        }
        LatestMpaApprovalTeamUpdate other = (LatestMpaApprovalTeamUpdate)obj;
        return Objects.equals(this.mpaSessionArn(), other.mpaSessionArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.initiationDate(), other.initiationDate()) && Objects.equals(this.expiryDate(), other.expiryDate());
    }

    public final String toString() {
        return ToString.builder((String)"LatestMpaApprovalTeamUpdate").add("MpaSessionArn", (Object)this.mpaSessionArn()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("InitiationDate", (Object)this.initiationDate()).add("ExpiryDate", (Object)this.expiryDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MpaSessionArn": {
                return Optional.ofNullable(clazz.cast(this.mpaSessionArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "InitiationDate": {
                return Optional.ofNullable(clazz.cast(this.initiationDate()));
            }
            case "ExpiryDate": {
                return Optional.ofNullable(clazz.cast(this.expiryDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MpaSessionArn", MPA_SESSION_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("InitiationDate", INITIATION_DATE_FIELD);
        map.put("ExpiryDate", EXPIRY_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LatestMpaApprovalTeamUpdate, T> g) {
        return obj -> g.apply((LatestMpaApprovalTeamUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mpaSessionArn;
        private String status;
        private String statusMessage;
        private Instant initiationDate;
        private Instant expiryDate;

        private BuilderImpl() {
        }

        private BuilderImpl(LatestMpaApprovalTeamUpdate model) {
            this.mpaSessionArn(model.mpaSessionArn);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.initiationDate(model.initiationDate);
            this.expiryDate(model.expiryDate);
        }

        public final String getMpaSessionArn() {
            return this.mpaSessionArn;
        }

        public final void setMpaSessionArn(String mpaSessionArn) {
            this.mpaSessionArn = mpaSessionArn;
        }

        @Override
        public final Builder mpaSessionArn(String mpaSessionArn) {
            this.mpaSessionArn = mpaSessionArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MpaSessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getInitiationDate() {
            return this.initiationDate;
        }

        public final void setInitiationDate(Instant initiationDate) {
            this.initiationDate = initiationDate;
        }

        @Override
        public final Builder initiationDate(Instant initiationDate) {
            this.initiationDate = initiationDate;
            return this;
        }

        public final Instant getExpiryDate() {
            return this.expiryDate;
        }

        public final void setExpiryDate(Instant expiryDate) {
            this.expiryDate = expiryDate;
        }

        @Override
        public final Builder expiryDate(Instant expiryDate) {
            this.expiryDate = expiryDate;
            return this;
        }

        public LatestMpaApprovalTeamUpdate build() {
            return new LatestMpaApprovalTeamUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LatestMpaApprovalTeamUpdate> {
        public Builder mpaSessionArn(String var1);

        public Builder status(String var1);

        public Builder status(MpaSessionStatus var1);

        public Builder statusMessage(String var1);

        public Builder initiationDate(Instant var1);

        public Builder expiryDate(Instant var1);
    }
}

