/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.services.backup.model.RestoreValidationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRestoreValidationResultRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, PutRestoreValidationResultRequest> {
    private static final SdkField<String> RESTORE_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RestoreJobId").getter(PutRestoreValidationResultRequest.getter(PutRestoreValidationResultRequest::restoreJobId)).setter(PutRestoreValidationResultRequest.setter(Builder::restoreJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("restoreJobId").build()}).build();
    private static final SdkField<String> VALIDATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationStatus").getter(PutRestoreValidationResultRequest.getter(PutRestoreValidationResultRequest::validationStatusAsString)).setter(PutRestoreValidationResultRequest.setter(Builder::validationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStatus").build()}).build();
    private static final SdkField<String> VALIDATION_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationStatusMessage").getter(PutRestoreValidationResultRequest.getter(PutRestoreValidationResultRequest::validationStatusMessage)).setter(PutRestoreValidationResultRequest.setter(Builder::validationStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStatusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESTORE_JOB_ID_FIELD, VALIDATION_STATUS_FIELD, VALIDATION_STATUS_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutRestoreValidationResultRequest.memberNameToFieldInitializer();
    private final String restoreJobId;
    private final String validationStatus;
    private final String validationStatusMessage;

    private PutRestoreValidationResultRequest(BuilderImpl builder) {
        super(builder);
        this.restoreJobId = builder.restoreJobId;
        this.validationStatus = builder.validationStatus;
        this.validationStatusMessage = builder.validationStatusMessage;
    }

    public final String restoreJobId() {
        return this.restoreJobId;
    }

    public final RestoreValidationStatus validationStatus() {
        return RestoreValidationStatus.fromValue(this.validationStatus);
    }

    public final String validationStatusAsString() {
        return this.validationStatus;
    }

    public final String validationStatusMessage() {
        return this.validationStatusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationStatusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRestoreValidationResultRequest)) {
            return false;
        }
        PutRestoreValidationResultRequest other = (PutRestoreValidationResultRequest)((Object)obj);
        return Objects.equals(this.restoreJobId(), other.restoreJobId()) && Objects.equals(this.validationStatusAsString(), other.validationStatusAsString()) && Objects.equals(this.validationStatusMessage(), other.validationStatusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"PutRestoreValidationResultRequest").add("RestoreJobId", (Object)this.restoreJobId()).add("ValidationStatus", (Object)this.validationStatusAsString()).add("ValidationStatusMessage", (Object)this.validationStatusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RestoreJobId": {
                return Optional.ofNullable(clazz.cast(this.restoreJobId()));
            }
            case "ValidationStatus": {
                return Optional.ofNullable(clazz.cast(this.validationStatusAsString()));
            }
            case "ValidationStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.validationStatusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("restoreJobId", RESTORE_JOB_ID_FIELD);
        map.put("ValidationStatus", VALIDATION_STATUS_FIELD);
        map.put("ValidationStatusMessage", VALIDATION_STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutRestoreValidationResultRequest, T> g) {
        return obj -> g.apply((PutRestoreValidationResultRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private String restoreJobId;
        private String validationStatus;
        private String validationStatusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRestoreValidationResultRequest model) {
            super(model);
            this.restoreJobId(model.restoreJobId);
            this.validationStatus(model.validationStatus);
            this.validationStatusMessage(model.validationStatusMessage);
        }

        public final String getRestoreJobId() {
            return this.restoreJobId;
        }

        public final void setRestoreJobId(String restoreJobId) {
            this.restoreJobId = restoreJobId;
        }

        @Override
        public final Builder restoreJobId(String restoreJobId) {
            this.restoreJobId = restoreJobId;
            return this;
        }

        public final String getValidationStatus() {
            return this.validationStatus;
        }

        public final void setValidationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
        }

        @Override
        public final Builder validationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
            return this;
        }

        @Override
        public final Builder validationStatus(RestoreValidationStatus validationStatus) {
            this.validationStatus(validationStatus == null ? null : validationStatus.toString());
            return this;
        }

        public final String getValidationStatusMessage() {
            return this.validationStatusMessage;
        }

        public final void setValidationStatusMessage(String validationStatusMessage) {
            this.validationStatusMessage = validationStatusMessage;
        }

        @Override
        public final Builder validationStatusMessage(String validationStatusMessage) {
            this.validationStatusMessage = validationStatusMessage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRestoreValidationResultRequest build() {
            return new PutRestoreValidationResultRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutRestoreValidationResultRequest> {
        public Builder restoreJobId(String var1);

        public Builder validationStatus(String var1);

        public Builder validationStatus(RestoreValidationStatus var1);

        public Builder validationStatusMessage(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

