/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BackupJobStatus {
    CREATED("CREATED"),
    PENDING("PENDING"),
    RUNNING("RUNNING"),
    ABORTING("ABORTING"),
    ABORTED("ABORTED"),
    COMPLETED("COMPLETED"),
    FAILED("FAILED"),
    EXPIRED("EXPIRED"),
    PARTIAL("PARTIAL"),
    AGGREGATE_ALL("AGGREGATE_ALL"),
    ANY("ANY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BackupJobStatus> VALUE_MAP;
    private final String value;

    private BackupJobStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BackupJobStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BackupJobStatus> knownValues() {
        EnumSet<BackupJobStatus> knownValues = EnumSet.allOf(BackupJobStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BackupJobStatus.class, BackupJobStatus::toString);
    }
}

