/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRecoveryPointsByBackupVaultRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, ListRecoveryPointsByBackupVaultRequest> {
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultName").getter(ListRecoveryPointsByBackupVaultRequest.getter(ListRecoveryPointsByBackupVaultRequest::backupVaultName)).setter(ListRecoveryPointsByBackupVaultRequest.setter(Builder::backupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("backupVaultName").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRecoveryPointsByBackupVaultRequest.getter(ListRecoveryPointsByBackupVaultRequest::nextToken)).setter(ListRecoveryPointsByBackupVaultRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListRecoveryPointsByBackupVaultRequest.getter(ListRecoveryPointsByBackupVaultRequest::maxResults)).setter(ListRecoveryPointsByBackupVaultRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> BY_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ByResourceArn").getter(ListRecoveryPointsByBackupVaultRequest.getter(ListRecoveryPointsByBackupVaultRequest::byResourceArn)).setter(ListRecoveryPointsByBackupVaultRequest.setter(Builder::byResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceArn").build()}).build();
    private static final SdkField<String> BY_RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ByResourceType").getter(ListRecoveryPointsByBackupVaultRequest.getter(ListRecoveryPointsByBackupVaultRequest::byResourceType)).setter(ListRecoveryPointsByBackupVaultRequest.setter(Builder::byResourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceType").build()}).build();
    private static final SdkField<String> BY_BACKUP_PLAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ByBackupPlanId").getter(ListRecoveryPointsByBackupVaultRequest.getter(ListRecoveryPointsByBackupVaultRequest::byBackupPlanId)).setter(ListRecoveryPointsByBackupVaultRequest.setter(Builder::byBackupPlanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("backupPlanId").build()}).build();
    private static final SdkField<Instant> BY_CREATED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ByCreatedBefore").getter(ListRecoveryPointsByBackupVaultRequest.getter(ListRecoveryPointsByBackupVaultRequest::byCreatedBefore)).setter(ListRecoveryPointsByBackupVaultRequest.setter(Builder::byCreatedBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdBefore").build()}).build();
    private static final SdkField<Instant> BY_CREATED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ByCreatedAfter").getter(ListRecoveryPointsByBackupVaultRequest.getter(ListRecoveryPointsByBackupVaultRequest::byCreatedAfter)).setter(ListRecoveryPointsByBackupVaultRequest.setter(Builder::byCreatedAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdAfter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_NAME_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, BY_RESOURCE_ARN_FIELD, BY_RESOURCE_TYPE_FIELD, BY_BACKUP_PLAN_ID_FIELD, BY_CREATED_BEFORE_FIELD, BY_CREATED_AFTER_FIELD));
    private final String backupVaultName;
    private final String nextToken;
    private final Integer maxResults;
    private final String byResourceArn;
    private final String byResourceType;
    private final String byBackupPlanId;
    private final Instant byCreatedBefore;
    private final Instant byCreatedAfter;

    private ListRecoveryPointsByBackupVaultRequest(BuilderImpl builder) {
        super(builder);
        this.backupVaultName = builder.backupVaultName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.byResourceArn = builder.byResourceArn;
        this.byResourceType = builder.byResourceType;
        this.byBackupPlanId = builder.byBackupPlanId;
        this.byCreatedBefore = builder.byCreatedBefore;
        this.byCreatedAfter = builder.byCreatedAfter;
    }

    public final String backupVaultName() {
        return this.backupVaultName;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String byResourceArn() {
        return this.byResourceArn;
    }

    public final String byResourceType() {
        return this.byResourceType;
    }

    public final String byBackupPlanId() {
        return this.byBackupPlanId;
    }

    public final Instant byCreatedBefore() {
        return this.byCreatedBefore;
    }

    public final Instant byCreatedAfter() {
        return this.byCreatedAfter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.byResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.byResourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.byBackupPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.byCreatedBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.byCreatedAfter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecoveryPointsByBackupVaultRequest)) {
            return false;
        }
        ListRecoveryPointsByBackupVaultRequest other = (ListRecoveryPointsByBackupVaultRequest)((Object)obj);
        return Objects.equals(this.backupVaultName(), other.backupVaultName()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.byResourceArn(), other.byResourceArn()) && Objects.equals(this.byResourceType(), other.byResourceType()) && Objects.equals(this.byBackupPlanId(), other.byBackupPlanId()) && Objects.equals(this.byCreatedBefore(), other.byCreatedBefore()) && Objects.equals(this.byCreatedAfter(), other.byCreatedAfter());
    }

    public final String toString() {
        return ToString.builder((String)"ListRecoveryPointsByBackupVaultRequest").add("BackupVaultName", (Object)this.backupVaultName()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ByResourceArn", (Object)this.byResourceArn()).add("ByResourceType", (Object)this.byResourceType()).add("ByBackupPlanId", (Object)this.byBackupPlanId()).add("ByCreatedBefore", (Object)this.byCreatedBefore()).add("ByCreatedAfter", (Object)this.byCreatedAfter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.backupVaultName()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "ByResourceArn": {
                return Optional.ofNullable(clazz.cast(this.byResourceArn()));
            }
            case "ByResourceType": {
                return Optional.ofNullable(clazz.cast(this.byResourceType()));
            }
            case "ByBackupPlanId": {
                return Optional.ofNullable(clazz.cast(this.byBackupPlanId()));
            }
            case "ByCreatedBefore": {
                return Optional.ofNullable(clazz.cast(this.byCreatedBefore()));
            }
            case "ByCreatedAfter": {
                return Optional.ofNullable(clazz.cast(this.byCreatedAfter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRecoveryPointsByBackupVaultRequest, T> g) {
        return obj -> g.apply((ListRecoveryPointsByBackupVaultRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private String backupVaultName;
        private String nextToken;
        private Integer maxResults;
        private String byResourceArn;
        private String byResourceType;
        private String byBackupPlanId;
        private Instant byCreatedBefore;
        private Instant byCreatedAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecoveryPointsByBackupVaultRequest model) {
            super(model);
            this.backupVaultName(model.backupVaultName);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.byResourceArn(model.byResourceArn);
            this.byResourceType(model.byResourceType);
            this.byBackupPlanId(model.byBackupPlanId);
            this.byCreatedBefore(model.byCreatedBefore);
            this.byCreatedAfter(model.byCreatedAfter);
        }

        public final String getBackupVaultName() {
            return this.backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getByResourceArn() {
            return this.byResourceArn;
        }

        @Override
        public final Builder byResourceArn(String byResourceArn) {
            this.byResourceArn = byResourceArn;
            return this;
        }

        public final void setByResourceArn(String byResourceArn) {
            this.byResourceArn = byResourceArn;
        }

        public final String getByResourceType() {
            return this.byResourceType;
        }

        @Override
        public final Builder byResourceType(String byResourceType) {
            this.byResourceType = byResourceType;
            return this;
        }

        public final void setByResourceType(String byResourceType) {
            this.byResourceType = byResourceType;
        }

        public final String getByBackupPlanId() {
            return this.byBackupPlanId;
        }

        @Override
        public final Builder byBackupPlanId(String byBackupPlanId) {
            this.byBackupPlanId = byBackupPlanId;
            return this;
        }

        public final void setByBackupPlanId(String byBackupPlanId) {
            this.byBackupPlanId = byBackupPlanId;
        }

        public final Instant getByCreatedBefore() {
            return this.byCreatedBefore;
        }

        @Override
        public final Builder byCreatedBefore(Instant byCreatedBefore) {
            this.byCreatedBefore = byCreatedBefore;
            return this;
        }

        public final void setByCreatedBefore(Instant byCreatedBefore) {
            this.byCreatedBefore = byCreatedBefore;
        }

        public final Instant getByCreatedAfter() {
            return this.byCreatedAfter;
        }

        @Override
        public final Builder byCreatedAfter(Instant byCreatedAfter) {
            this.byCreatedAfter = byCreatedAfter;
            return this;
        }

        public final void setByCreatedAfter(Instant byCreatedAfter) {
            this.byCreatedAfter = byCreatedAfter;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRecoveryPointsByBackupVaultRequest build() {
            return new ListRecoveryPointsByBackupVaultRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRecoveryPointsByBackupVaultRequest> {
        public Builder backupVaultName(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder byResourceArn(String var1);

        public Builder byResourceType(String var1);

        public Builder byBackupPlanId(String var1);

        public Builder byCreatedBefore(Instant var1);

        public Builder byCreatedAfter(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

