/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBackupPlanFromTemplateRequest extends BackupRequest implements
        ToCopyableBuilder<GetBackupPlanFromTemplateRequest.Builder, GetBackupPlanFromTemplateRequest> {
    private static final SdkField<String> BACKUP_PLAN_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetBackupPlanFromTemplateRequest::backupPlanTemplateId)).setter(setter(Builder::backupPlanTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("templateId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(BACKUP_PLAN_TEMPLATE_ID_FIELD));

    private final String backupPlanTemplateId;

    private GetBackupPlanFromTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.backupPlanTemplateId = builder.backupPlanTemplateId;
    }

    /**
     * <p>
     * Uniquely identifies a stored backup plan template.
     * </p>
     * 
     * @return Uniquely identifies a stored backup plan template.
     */
    public String backupPlanTemplateId() {
        return backupPlanTemplateId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanTemplateId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBackupPlanFromTemplateRequest)) {
            return false;
        }
        GetBackupPlanFromTemplateRequest other = (GetBackupPlanFromTemplateRequest) obj;
        return Objects.equals(backupPlanTemplateId(), other.backupPlanTemplateId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetBackupPlanFromTemplateRequest").add("BackupPlanTemplateId", backupPlanTemplateId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupPlanTemplateId":
            return Optional.ofNullable(clazz.cast(backupPlanTemplateId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBackupPlanFromTemplateRequest, T> g) {
        return obj -> g.apply((GetBackupPlanFromTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetBackupPlanFromTemplateRequest> {
        /**
         * <p>
         * Uniquely identifies a stored backup plan template.
         * </p>
         * 
         * @param backupPlanTemplateId
         *        Uniquely identifies a stored backup plan template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanTemplateId(String backupPlanTemplateId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String backupPlanTemplateId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBackupPlanFromTemplateRequest model) {
            super(model);
            backupPlanTemplateId(model.backupPlanTemplateId);
        }

        public final String getBackupPlanTemplateId() {
            return backupPlanTemplateId;
        }

        @Override
        public final Builder backupPlanTemplateId(String backupPlanTemplateId) {
            this.backupPlanTemplateId = backupPlanTemplateId;
            return this;
        }

        public final void setBackupPlanTemplateId(String backupPlanTemplateId) {
            this.backupPlanTemplateId = backupPlanTemplateId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBackupPlanFromTemplateRequest build() {
            return new GetBackupPlanFromTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
