/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCopyJobResponse extends BackupResponse implements
        ToCopyableBuilder<DescribeCopyJobResponse.Builder, DescribeCopyJobResponse> {
    private static final SdkField<CopyJob> COPY_JOB_FIELD = SdkField.<CopyJob> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeCopyJobResponse::copyJob)).setter(setter(Builder::copyJob)).constructor(CopyJob::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyJob").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COPY_JOB_FIELD));

    private final CopyJob copyJob;

    private DescribeCopyJobResponse(BuilderImpl builder) {
        super(builder);
        this.copyJob = builder.copyJob;
    }

    /**
     * <p>
     * Contains detailed information about a copy job.
     * </p>
     * 
     * @return Contains detailed information about a copy job.
     */
    public CopyJob copyJob() {
        return copyJob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(copyJob());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCopyJobResponse)) {
            return false;
        }
        DescribeCopyJobResponse other = (DescribeCopyJobResponse) obj;
        return Objects.equals(copyJob(), other.copyJob());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeCopyJobResponse").add("CopyJob", copyJob()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CopyJob":
            return Optional.ofNullable(clazz.cast(copyJob()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCopyJobResponse, T> g) {
        return obj -> g.apply((DescribeCopyJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCopyJobResponse> {
        /**
         * <p>
         * Contains detailed information about a copy job.
         * </p>
         * 
         * @param copyJob
         *        Contains detailed information about a copy job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyJob(CopyJob copyJob);

        /**
         * <p>
         * Contains detailed information about a copy job.
         * </p>
         * This is a convenience that creates an instance of the {@link CopyJob.Builder} avoiding the need to create one
         * manually via {@link CopyJob#builder()}.
         *
         * When the {@link Consumer} completes, {@link CopyJob.Builder#build()} is called immediately and its result is
         * passed to {@link #copyJob(CopyJob)}.
         * 
         * @param copyJob
         *        a consumer that will call methods on {@link CopyJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #copyJob(CopyJob)
         */
        default Builder copyJob(Consumer<CopyJob.Builder> copyJob) {
            return copyJob(CopyJob.builder().applyMutation(copyJob).build());
        }
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private CopyJob copyJob;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCopyJobResponse model) {
            super(model);
            copyJob(model.copyJob);
        }

        public final CopyJob.Builder getCopyJob() {
            return copyJob != null ? copyJob.toBuilder() : null;
        }

        @Override
        public final Builder copyJob(CopyJob copyJob) {
            this.copyJob = copyJob;
            return this;
        }

        public final void setCopyJob(CopyJob.BuilderImpl copyJob) {
            this.copyJob = copyJob != null ? copyJob.build() : null;
        }

        @Override
        public DescribeCopyJobResponse build() {
            return new DescribeCopyJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
