/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the backup plan and rule that AWS Backup used to initiate the recovery point backup.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecoveryPointCreator implements SdkPojo, Serializable,
        ToCopyableBuilder<RecoveryPointCreator.Builder, RecoveryPointCreator> {
    private static final SdkField<String> BACKUP_PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RecoveryPointCreator::backupPlanId)).setter(setter(Builder::backupPlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanId").build()).build();

    private static final SdkField<String> BACKUP_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RecoveryPointCreator::backupPlanArn)).setter(setter(Builder::backupPlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanArn").build()).build();

    private static final SdkField<String> BACKUP_PLAN_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RecoveryPointCreator::backupPlanVersion)).setter(setter(Builder::backupPlanVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanVersion").build()).build();

    private static final SdkField<String> BACKUP_RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RecoveryPointCreator::backupRuleId)).setter(setter(Builder::backupRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRuleId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_ID_FIELD,
            BACKUP_PLAN_ARN_FIELD, BACKUP_PLAN_VERSION_FIELD, BACKUP_RULE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String backupPlanId;

    private final String backupPlanArn;

    private final String backupPlanVersion;

    private final String backupRuleId;

    private RecoveryPointCreator(BuilderImpl builder) {
        this.backupPlanId = builder.backupPlanId;
        this.backupPlanArn = builder.backupPlanArn;
        this.backupPlanVersion = builder.backupPlanVersion;
        this.backupRuleId = builder.backupRuleId;
    }

    /**
     * <p>
     * Uniquely identifies a backup plan.
     * </p>
     * 
     * @return Uniquely identifies a backup plan.
     */
    public String backupPlanId() {
        return backupPlanId;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.
     */
    public String backupPlanArn() {
        return backupPlanArn;
    }

    /**
     * <p>
     * Version IDs are unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long.
     * They cannot be edited.
     * </p>
     * 
     * @return Version IDs are unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes
     *         long. They cannot be edited.
     */
    public String backupPlanVersion() {
        return backupPlanVersion;
    }

    /**
     * <p>
     * Uniquely identifies a rule used to schedule the backup of a selection of resources.
     * </p>
     * 
     * @return Uniquely identifies a rule used to schedule the backup of a selection of resources.
     */
    public String backupRuleId() {
        return backupRuleId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanVersion());
        hashCode = 31 * hashCode + Objects.hashCode(backupRuleId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryPointCreator)) {
            return false;
        }
        RecoveryPointCreator other = (RecoveryPointCreator) obj;
        return Objects.equals(backupPlanId(), other.backupPlanId()) && Objects.equals(backupPlanArn(), other.backupPlanArn())
                && Objects.equals(backupPlanVersion(), other.backupPlanVersion())
                && Objects.equals(backupRuleId(), other.backupRuleId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RecoveryPointCreator").add("BackupPlanId", backupPlanId()).add("BackupPlanArn", backupPlanArn())
                .add("BackupPlanVersion", backupPlanVersion()).add("BackupRuleId", backupRuleId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupPlanId":
            return Optional.ofNullable(clazz.cast(backupPlanId()));
        case "BackupPlanArn":
            return Optional.ofNullable(clazz.cast(backupPlanArn()));
        case "BackupPlanVersion":
            return Optional.ofNullable(clazz.cast(backupPlanVersion()));
        case "BackupRuleId":
            return Optional.ofNullable(clazz.cast(backupRuleId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecoveryPointCreator, T> g) {
        return obj -> g.apply((RecoveryPointCreator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecoveryPointCreator> {
        /**
         * <p>
         * Uniquely identifies a backup plan.
         * </p>
         * 
         * @param backupPlanId
         *        Uniquely identifies a backup plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanId(String backupPlanId);

        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.
         * </p>
         * 
         * @param backupPlanArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanArn(String backupPlanArn);

        /**
         * <p>
         * Version IDs are unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long.
         * They cannot be edited.
         * </p>
         * 
         * @param backupPlanVersion
         *        Version IDs are unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024
         *        bytes long. They cannot be edited.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanVersion(String backupPlanVersion);

        /**
         * <p>
         * Uniquely identifies a rule used to schedule the backup of a selection of resources.
         * </p>
         * 
         * @param backupRuleId
         *        Uniquely identifies a rule used to schedule the backup of a selection of resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRuleId(String backupRuleId);
    }

    static final class BuilderImpl implements Builder {
        private String backupPlanId;

        private String backupPlanArn;

        private String backupPlanVersion;

        private String backupRuleId;

        private BuilderImpl() {
        }

        private BuilderImpl(RecoveryPointCreator model) {
            backupPlanId(model.backupPlanId);
            backupPlanArn(model.backupPlanArn);
            backupPlanVersion(model.backupPlanVersion);
            backupRuleId(model.backupRuleId);
        }

        public final String getBackupPlanId() {
            return backupPlanId;
        }

        @Override
        public final Builder backupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
            return this;
        }

        public final void setBackupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
        }

        public final String getBackupPlanArn() {
            return backupPlanArn;
        }

        @Override
        public final Builder backupPlanArn(String backupPlanArn) {
            this.backupPlanArn = backupPlanArn;
            return this;
        }

        public final void setBackupPlanArn(String backupPlanArn) {
            this.backupPlanArn = backupPlanArn;
        }

        public final String getBackupPlanVersion() {
            return backupPlanVersion;
        }

        @Override
        public final Builder backupPlanVersion(String backupPlanVersion) {
            this.backupPlanVersion = backupPlanVersion;
            return this;
        }

        public final void setBackupPlanVersion(String backupPlanVersion) {
            this.backupPlanVersion = backupPlanVersion;
        }

        public final String getBackupRuleId() {
            return backupRuleId;
        }

        @Override
        public final Builder backupRuleId(String backupRuleId) {
            this.backupRuleId = backupRuleId;
            return this;
        }

        public final void setBackupRuleId(String backupRuleId) {
            this.backupRuleId = backupRuleId;
        }

        @Override
        public RecoveryPointCreator build() {
            return new RecoveryPointCreator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
