/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSupportedResourceTypesResponse extends BackupResponse implements
        ToCopyableBuilder<GetSupportedResourceTypesResponse.Builder, GetSupportedResourceTypesResponse> {
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetSupportedResourceTypesResponse::resourceTypes))
            .setter(setter(Builder::resourceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPES_FIELD));

    private final List<String> resourceTypes;

    private GetSupportedResourceTypesResponse(BuilderImpl builder) {
        super(builder);
        this.resourceTypes = builder.resourceTypes;
    }

    /**
     * Returns true if the ResourceTypes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResourceTypes() {
        return resourceTypes != null && !(resourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a string with the supported AWS resource types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EBS</code> for Amazon Elastic Block Store
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Storage Gateway</code> for AWS Storage Gateway
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RDS</code> for Amazon Relational Database Service
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DDB</code> for Amazon DynamoDB
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EFS</code> for Amazon Elastic File System
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains a string with the supported AWS resource types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EBS</code> for Amazon Elastic Block Store
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Storage Gateway</code> for AWS Storage Gateway
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RDS</code> for Amazon Relational Database Service
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DDB</code> for Amazon DynamoDB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EFS</code> for Amazon Elastic File System
     *         </p>
     *         </li>
     */
    public List<String> resourceTypes() {
        return resourceTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSupportedResourceTypesResponse)) {
            return false;
        }
        GetSupportedResourceTypesResponse other = (GetSupportedResourceTypesResponse) obj;
        return Objects.equals(resourceTypes(), other.resourceTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetSupportedResourceTypesResponse").add("ResourceTypes", resourceTypes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceTypes":
            return Optional.ofNullable(clazz.cast(resourceTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSupportedResourceTypesResponse, T> g) {
        return obj -> g.apply((GetSupportedResourceTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSupportedResourceTypesResponse> {
        /**
         * <p>
         * Contains a string with the supported AWS resource types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EBS</code> for Amazon Elastic Block Store
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Storage Gateway</code> for AWS Storage Gateway
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RDS</code> for Amazon Relational Database Service
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DDB</code> for Amazon DynamoDB
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EFS</code> for Amazon Elastic File System
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceTypes
         *        Contains a string with the supported AWS resource types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EBS</code> for Amazon Elastic Block Store
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Storage Gateway</code> for AWS Storage Gateway
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RDS</code> for Amazon Relational Database Service
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DDB</code> for Amazon DynamoDB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EFS</code> for Amazon Elastic File System
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<String> resourceTypes);

        /**
         * <p>
         * Contains a string with the supported AWS resource types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EBS</code> for Amazon Elastic Block Store
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Storage Gateway</code> for AWS Storage Gateway
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RDS</code> for Amazon Relational Database Service
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DDB</code> for Amazon DynamoDB
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EFS</code> for Amazon Elastic File System
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceTypes
         *        Contains a string with the supported AWS resource types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EBS</code> for Amazon Elastic Block Store
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Storage Gateway</code> for AWS Storage Gateway
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RDS</code> for Amazon Relational Database Service
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DDB</code> for Amazon DynamoDB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EFS</code> for Amazon Elastic File System
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(String... resourceTypes);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSupportedResourceTypesResponse model) {
            super(model);
            resourceTypes(model.resourceTypes);
        }

        public final Collection<String> getResourceTypes() {
            return resourceTypes;
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        @Override
        public GetSupportedResourceTypesResponse build() {
            return new GetSupportedResourceTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
