/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the copy operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyAction implements SdkPojo, Serializable, ToCopyableBuilder<CopyAction.Builder, CopyAction> {
    private static final SdkField<Lifecycle> LIFECYCLE_FIELD = SdkField.<Lifecycle> builder(MarshallingType.SDK_POJO)
            .getter(getter(CopyAction::lifecycle)).setter(setter(Builder::lifecycle)).constructor(Lifecycle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()).build();

    private static final SdkField<String> DESTINATION_BACKUP_VAULT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CopyAction::destinationBackupVaultArn)).setter(setter(Builder::destinationBackupVaultArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationBackupVaultArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_FIELD,
            DESTINATION_BACKUP_VAULT_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Lifecycle lifecycle;

    private final String destinationBackupVaultArn;

    private CopyAction(BuilderImpl builder) {
        this.lifecycle = builder.lifecycle;
        this.destinationBackupVaultArn = builder.destinationBackupVaultArn;
    }

    /**
     * Returns the value of the Lifecycle property for this object.
     * 
     * @return The value of the Lifecycle property for this object.
     */
    public Lifecycle lifecycle() {
        return lifecycle;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies the destination backup vault for the copied backup. For
     * example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies the destination backup vault for the copied
     *         backup. For example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
     */
    public String destinationBackupVaultArn() {
        return destinationBackupVaultArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lifecycle());
        hashCode = 31 * hashCode + Objects.hashCode(destinationBackupVaultArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyAction)) {
            return false;
        }
        CopyAction other = (CopyAction) obj;
        return Objects.equals(lifecycle(), other.lifecycle())
                && Objects.equals(destinationBackupVaultArn(), other.destinationBackupVaultArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CopyAction").add("Lifecycle", lifecycle())
                .add("DestinationBackupVaultArn", destinationBackupVaultArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Lifecycle":
            return Optional.ofNullable(clazz.cast(lifecycle()));
        case "DestinationBackupVaultArn":
            return Optional.ofNullable(clazz.cast(destinationBackupVaultArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyAction, T> g) {
        return obj -> g.apply((CopyAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CopyAction> {
        /**
         * Sets the value of the Lifecycle property for this object.
         *
         * @param lifecycle
         *        The new value for the Lifecycle property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycle(Lifecycle lifecycle);

        /**
         * Sets the value of the Lifecycle property for this object.
         *
         * This is a convenience that creates an instance of the {@link Lifecycle.Builder} avoiding the need to create
         * one manually via {@link Lifecycle#builder()}.
         *
         * When the {@link Consumer} completes, {@link Lifecycle.Builder#build()} is called immediately and its result
         * is passed to {@link #lifecycle(Lifecycle)}.
         * 
         * @param lifecycle
         *        a consumer that will call methods on {@link Lifecycle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycle(Lifecycle)
         */
        default Builder lifecycle(Consumer<Lifecycle.Builder> lifecycle) {
            return lifecycle(Lifecycle.builder().applyMutation(lifecycle).build());
        }

        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies the destination backup vault for the copied backup.
         * For example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
         * </p>
         * 
         * @param destinationBackupVaultArn
         *        An Amazon Resource Name (ARN) that uniquely identifies the destination backup vault for the copied
         *        backup. For example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationBackupVaultArn(String destinationBackupVaultArn);
    }

    static final class BuilderImpl implements Builder {
        private Lifecycle lifecycle;

        private String destinationBackupVaultArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyAction model) {
            lifecycle(model.lifecycle);
            destinationBackupVaultArn(model.destinationBackupVaultArn);
        }

        public final Lifecycle.Builder getLifecycle() {
            return lifecycle != null ? lifecycle.toBuilder() : null;
        }

        @Override
        public final Builder lifecycle(Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public final void setLifecycle(Lifecycle.BuilderImpl lifecycle) {
            this.lifecycle = lifecycle != null ? lifecycle.build() : null;
        }

        public final String getDestinationBackupVaultArn() {
            return destinationBackupVaultArn;
        }

        @Override
        public final Builder destinationBackupVaultArn(String destinationBackupVaultArn) {
            this.destinationBackupVaultArn = destinationBackupVaultArn;
            return this;
        }

        public final void setDestinationBackupVaultArn(String destinationBackupVaultArn) {
            this.destinationBackupVaultArn = destinationBackupVaultArn;
        }

        @Override
        public CopyAction build() {
            return new CopyAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
