/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.json.internal.dom;

import java.util.Objects;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.protocols.json.internal.dom.SdkJsonNode;
import software.amazon.awssdk.protocols.json.internal.dom.SdkScalarNodeType;

@SdkInternalApi
public final class SdkScalarNode
implements SdkJsonNode {
    private final String value;
    private final SdkScalarNodeType nodeType;

    private SdkScalarNode(String value, SdkScalarNodeType nodeType) {
        this.value = value;
        this.nodeType = nodeType;
    }

    public SdkScalarNodeType getNodeType() {
        return this.nodeType;
    }

    public String value() {
        return this.value;
    }

    @Override
    public String asText() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SdkScalarNode that = (SdkScalarNode)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    static SdkScalarNode create(String value) {
        return new SdkScalarNode(value, SdkScalarNodeType.STRING);
    }

    static SdkScalarNode createNumber(Number value) {
        return new SdkScalarNode(String.valueOf(value), SdkScalarNodeType.NUMBER);
    }

    static SdkScalarNode createBoolean(boolean value) {
        return new SdkScalarNode(String.valueOf(value), SdkScalarNodeType.BOOLEAN);
    }

    public String toString() {
        return "\"" + this.value + "\"";
    }
}

