/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.signer.internal.chunkedencoding;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.internal.chunkedencoding.AwsChunkSigner;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.internal.chunked.AwsChunkedEncodingConfig;
import software.amazon.awssdk.core.internal.io.AwsChunkedEncodingInputStream;

@SdkInternalApi
public final class AwsSignedChunkedEncodingInputStream
extends AwsChunkedEncodingInputStream {
    private static final String CRLF = "\r\n";
    private static final String CHUNK_SIGNATURE_HEADER = ";chunk-signature=";
    private static final byte[] FINAL_CHUNK = new byte[0];
    private String previousChunkSignature;
    private String headerSignature;
    private final AwsChunkSigner chunkSigner;

    private AwsSignedChunkedEncodingInputStream(InputStream in, String headerSignature, AwsChunkSigner chunkSigner, AwsChunkedEncodingConfig config) {
        super(in, config);
        this.chunkSigner = chunkSigner;
        this.previousChunkSignature = headerSignature;
        this.headerSignature = headerSignature;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static long calculateStreamContentLength(long originalLength, int signatureLength, AwsChunkedEncodingConfig config) {
        if (originalLength < 0L) {
            throw new IllegalArgumentException("Nonnegative content length expected.");
        }
        int chunkSize = config.chunkSize();
        long maxSizeChunks = originalLength / (long)chunkSize;
        long remainingBytes = originalLength % (long)chunkSize;
        return maxSizeChunks * AwsSignedChunkedEncodingInputStream.calculateSignedChunkLength(chunkSize, signatureLength) + (remainingBytes > 0L ? AwsSignedChunkedEncodingInputStream.calculateSignedChunkLength(remainingBytes, signatureLength) : 0L) + AwsSignedChunkedEncodingInputStream.calculateSignedChunkLength(0L, signatureLength);
    }

    private static long calculateSignedChunkLength(long chunkDataSize, int signatureLength) {
        return (long)(Long.toHexString(chunkDataSize).length() + CHUNK_SIGNATURE_HEADER.length() + signatureLength + CRLF.length()) + chunkDataSize + (long)CRLF.length();
    }

    private byte[] createSignedChunk(byte[] chunkData) {
        try {
            byte[] header = this.createSignedChunkHeader(chunkData);
            byte[] trailer = CRLF.getBytes(StandardCharsets.UTF_8);
            byte[] signedChunk = new byte[header.length + chunkData.length + trailer.length];
            System.arraycopy(header, 0, signedChunk, 0, header.length);
            System.arraycopy(chunkData, 0, signedChunk, header.length, chunkData.length);
            System.arraycopy(trailer, 0, signedChunk, header.length + chunkData.length, trailer.length);
            return signedChunk;
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to sign the chunked data. " + e.getMessage()).cause((Throwable)e).build();
        }
    }

    private byte[] createSignedChunkHeader(byte[] chunkData) {
        String chunkSignature;
        this.previousChunkSignature = chunkSignature = this.chunkSigner.signChunk(chunkData, this.previousChunkSignature);
        StringBuilder chunkHeader = new StringBuilder();
        chunkHeader.append(Integer.toHexString(chunkData.length));
        chunkHeader.append(CHUNK_SIGNATURE_HEADER).append(chunkSignature).append(CRLF);
        return chunkHeader.toString().getBytes(StandardCharsets.UTF_8);
    }

    protected byte[] createFinalChunk(byte[] finalChunk) {
        return this.createChunk(FINAL_CHUNK);
    }

    protected byte[] createChunk(byte[] chunkData) {
        return this.createSignedChunk(chunkData);
    }

    public void reset() throws IOException {
        super.reset();
        this.previousChunkSignature = this.headerSignature;
    }

    public static final class Builder
    extends AwsChunkedEncodingInputStream.Builder<Builder> {
        private AwsChunkSigner awsChunkSigner;
        private String headerSignature;

        public Builder headerSignature(String headerSignature) {
            this.headerSignature = headerSignature;
            return this;
        }

        public Builder awsChunkSigner(AwsChunkSigner awsChunkSigner) {
            this.awsChunkSigner = awsChunkSigner;
            return this;
        }

        public AwsSignedChunkedEncodingInputStream build() {
            return new AwsSignedChunkedEncodingInputStream(this.inputStream(), this.headerSignature, this.awsChunkSigner, this.chunkedEncodingConfig());
        }
    }
}

