/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.signer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import software.amazon.awssdk.annotations.ReviewBeforeRelease;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.signer.SigningAlgorithm;
import software.amazon.awssdk.auth.signer.internal.Aws4SignerRequestParams;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.runtime.auth.Signer;
import software.amazon.awssdk.core.runtime.io.SdkDigestInputStream;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.utils.Base64Utils;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

public abstract class AbstractAwsSigner
implements Signer {
    public static final String EMPTY_STRING_SHA256_HEX;
    private static final ThreadLocal<MessageDigest> SHA256_MESSAGE_DIGEST;

    private static byte[] doHash(String text) throws SdkClientException {
        try {
            MessageDigest md = AbstractAwsSigner.getMessageDigestInstance();
            md.update(text.getBytes(StandardCharsets.UTF_8));
            return md.digest();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to compute hash while signing request: " + e.getMessage(), (Throwable)e);
        }
    }

    private static MessageDigest getMessageDigestInstance() {
        MessageDigest messageDigest = SHA256_MESSAGE_DIGEST.get();
        messageDigest.reset();
        return messageDigest;
    }

    protected String signAndBase64Encode(String data, String key, SigningAlgorithm algorithm) throws SdkClientException {
        return this.signAndBase64Encode(data.getBytes(StandardCharsets.UTF_8), key, algorithm);
    }

    private String signAndBase64Encode(byte[] data, String key, SigningAlgorithm algorithm) throws SdkClientException {
        try {
            byte[] signature = this.sign(data, key.getBytes(StandardCharsets.UTF_8), algorithm);
            return Base64Utils.encodeAsString((byte[])signature);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to calculate a request signature: " + e.getMessage(), (Throwable)e);
        }
    }

    public byte[] signWithMac(String stringData, Mac mac) {
        try {
            return mac.doFinal(stringData.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to calculate a request signature: " + e.getMessage(), (Throwable)e);
        }
    }

    public byte[] sign(String stringData, byte[] key, SigningAlgorithm algorithm) throws SdkClientException {
        try {
            byte[] data = stringData.getBytes(StandardCharsets.UTF_8);
            return this.sign(data, key, algorithm);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to calculate a request signature: " + e.getMessage(), (Throwable)e);
        }
    }

    protected byte[] sign(byte[] data, byte[] key, SigningAlgorithm algorithm) throws SdkClientException {
        try {
            Mac mac = algorithm.getMac();
            mac.init(new SecretKeySpec(key, algorithm.toString()));
            return mac.doFinal(data);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to calculate a request signature: " + e.getMessage(), (Throwable)e);
        }
    }

    public byte[] hash(String text) throws SdkClientException {
        return AbstractAwsSigner.doHash(text);
    }

    protected byte[] hash(InputStream input) throws SdkClientException {
        try {
            MessageDigest md = AbstractAwsSigner.getMessageDigestInstance();
            SdkDigestInputStream digestInputStream = new SdkDigestInputStream(input, md);
            byte[] buffer = new byte[1024];
            while (digestInputStream.read(buffer) > -1) {
            }
            return digestInputStream.getMessageDigest().digest();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to compute hash while signing request: " + e.getMessage(), (Throwable)e);
        }
    }

    public byte[] hash(byte[] data) throws SdkClientException {
        try {
            MessageDigest md = AbstractAwsSigner.getMessageDigestInstance();
            md.update(data);
            return md.digest();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to compute hash while signing request: " + e.getMessage(), (Throwable)e);
        }
    }

    protected String getCanonicalizedQueryString(Map<String, List<String>> parameters) {
        TreeMap sorted = new TreeMap();
        for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
            String encodedParamName = SdkHttpUtils.urlEncode((String)entry.getKey());
            List<String> paramValues = entry.getValue();
            ArrayList<String> encodedValues = new ArrayList<String>(paramValues.size());
            for (String value : paramValues) {
                String encodedValue = SdkHttpUtils.urlEncode((String)value);
                String signatureFormattedEncodedValue = encodedValue == null ? "" : encodedValue;
                encodedValues.add(signatureFormattedEncodedValue);
            }
            Collections.sort(encodedValues);
            sorted.put(encodedParamName, encodedValues);
        }
        return SdkHttpUtils.flattenQueryParameters(sorted).orElse("");
    }

    @ReviewBeforeRelease(value="Do we still want to make read limit user-configurable as in V1?")
    protected static int getReadLimit(Aws4SignerRequestParams signerRequestParams) {
        return 131073;
    }

    protected InputStream getBinaryRequestPayloadStream(InputStream stream) {
        try {
            if (stream == null) {
                return new ByteArrayInputStream(new byte[0]);
            }
            if (!stream.markSupported()) {
                throw new SdkClientException("Unable to read request payload to sign request.");
            }
            return stream;
        }
        catch (SdkClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to read request payload to sign request: " + e.getMessage(), (Throwable)e);
        }
    }

    protected String getCanonicalizedResourcePath(String resourcePath, boolean urlEncode) {
        String value;
        if (StringUtils.isEmpty((CharSequence)resourcePath)) {
            return "/";
        }
        String string = value = urlEncode ? SdkHttpUtils.urlEncodeIgnoreSlashes((String)resourcePath) : resourcePath;
        if (value.startsWith("/")) {
            return value;
        }
        return "/".concat(value);
    }

    protected String getCanonicalizedEndpoint(SdkHttpFullRequest request) {
        String endpointForStringToSign = StringUtils.lowerCase((String)request.host());
        if (!SdkHttpUtils.isUsingStandardPort((String)request.protocol(), (Integer)request.port())) {
            endpointForStringToSign = endpointForStringToSign + ":" + request.port();
        }
        return endpointForStringToSign;
    }

    protected AwsCredentials sanitizeCredentials(AwsCredentials credentials) {
        String accessKeyId = StringUtils.trim((String)credentials.accessKeyId());
        String secretKey = StringUtils.trim((String)credentials.secretAccessKey());
        if (credentials instanceof AwsSessionCredentials) {
            AwsSessionCredentials sessionCredentials = (AwsSessionCredentials)credentials;
            return AwsSessionCredentials.create(accessKeyId, secretKey, StringUtils.trim((String)sessionCredentials.sessionToken()));
        }
        return AwsCredentials.create(accessKeyId, secretKey);
    }

    protected Date getSignatureDate(int offsetInSeconds) {
        return new Date(System.currentTimeMillis() - 1000L * (long)offsetInSeconds);
    }

    protected abstract void addSessionCredentials(SdkHttpFullRequest.Builder var1, AwsSessionCredentials var2);

    static {
        SHA256_MESSAGE_DIGEST = ThreadLocal.withInitial(() -> {
            try {
                return MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new SdkClientException("Unable to get SHA256 Function" + e.getMessage(), (Throwable)e);
            }
        });
        EMPTY_STRING_SHA256_HEX = BinaryUtils.toHex((byte[])AbstractAwsSigner.doHash(""));
    }
}

