/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.credentials;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.auth.credentials.ContainerCredentialsRetryPolicy;
import software.amazon.awssdk.auth.credentials.HttpCredentialsProvider;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.util.ResourcesEndpointProvider;
import software.amazon.awssdk.regions.util.ResourcesEndpointRetryPolicy;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.ToString;

public final class ContainerCredentialsProvider
extends HttpCredentialsProvider {
    private final ResourcesEndpointProvider credentialsEndpointProvider;

    private ContainerCredentialsProvider(Builder builder) {
        super(builder);
        this.credentialsEndpointProvider = builder.credentialsEndpointProvider;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected ResourcesEndpointProvider getCredentialsEndpointProvider() {
        return this.credentialsEndpointProvider;
    }

    public String toString() {
        return ToString.create((String)"ContainerCredentialsProvider");
    }

    public static final class Builder
    extends HttpCredentialsProvider.Builder<ContainerCredentialsProvider, Builder> {
        private ResourcesEndpointProvider credentialsEndpointProvider = new ContainerCredentialsEndpointProvider();

        private Builder() {
            super.asyncThreadName("container-credentials-provider");
        }

        @SdkTestInternalApi
        Builder credentialsEndpointProvider(ResourcesEndpointProvider credentialsEndpointProvider) {
            this.credentialsEndpointProvider = credentialsEndpointProvider;
            return this;
        }

        @Override
        public ContainerCredentialsProvider build() {
            return new ContainerCredentialsProvider(this);
        }
    }

    static final class ContainerCredentialsEndpointProvider
    implements ResourcesEndpointProvider {
        private static final Set<String> ALLOWED_HOSTS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("localhost", "127.0.0.1")));

        ContainerCredentialsEndpointProvider() {
        }

        public URI endpoint() throws IOException {
            if (!SdkSystemSetting.AWS_CONTAINER_CREDENTIALS_RELATIVE_URI.getStringValue().isPresent() && !SdkSystemSetting.AWS_CONTAINER_CREDENTIALS_FULL_URI.getStringValue().isPresent()) {
                throw new SdkClientException(String.format("Cannot fetch credentials from container - neither %s or %s environment variables are set.", SdkSystemSetting.AWS_CONTAINER_CREDENTIALS_FULL_URI.environmentVariable(), SdkSystemSetting.AWS_CONTAINER_CREDENTIALS_RELATIVE_URI.environmentVariable()));
            }
            try {
                return SdkSystemSetting.AWS_CONTAINER_CREDENTIALS_RELATIVE_URI.getStringValue().map(this::createUri).orElseGet(this::createGenericContainerUrl);
            }
            catch (SdkClientException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SdkClientException("Unable to fetch credentials from container.", (Throwable)e);
            }
        }

        public ResourcesEndpointRetryPolicy retryPolicy() {
            return new ContainerCredentialsRetryPolicy();
        }

        public Map<String, String> headers() {
            return SdkSystemSetting.AWS_CONTAINER_AUTHORIZATION_TOKEN.getStringValue().filter(StringUtils::isNotBlank).map(t -> Collections.singletonMap("Authorization", t)).orElseGet(Collections::emptyMap);
        }

        private URI createUri(String relativeUri) {
            return URI.create(SdkSystemSetting.AWS_CONTAINER_SERVICE_ENDPOINT.getStringValueOrThrow() + relativeUri);
        }

        private URI createGenericContainerUrl() {
            URI uri = URI.create(SdkSystemSetting.AWS_CONTAINER_CREDENTIALS_FULL_URI.getStringValueOrThrow());
            if (!ALLOWED_HOSTS.contains(uri.getHost())) {
                throw new SdkClientException(String.format("The full URI (%s) contained withing environment variable %s has an invalid host. Host can only be one of [%s].", uri, SdkSystemSetting.AWS_CONTAINER_CREDENTIALS_FULL_URI.environmentVariable(), ALLOWED_HOSTS.stream().collect(Collectors.joining(","))));
            }
            return uri;
        }
    }
}

