/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.credentials;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

public final class AwsCredentialsProviderChain
implements AwsCredentialsProvider,
SdkAutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(AwsCredentialsProviderChain.class);
    private final List<AwsCredentialsProvider> credentialsProviders;
    private final boolean reuseLastProviderEnabled;
    private volatile AwsCredentialsProvider lastUsedProvider;

    private AwsCredentialsProviderChain(Builder builder) {
        this.reuseLastProviderEnabled = builder.reuseLastProviderEnabled;
        this.credentialsProviders = Collections.unmodifiableList((List)Validate.notEmpty((Collection)builder.credentialsProviders, (String)"No credential providers were specified.", (Object[])new Object[0]));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AwsCredentialsProviderChain of(AwsCredentialsProvider ... awsCredentialsProviders) {
        return AwsCredentialsProviderChain.builder().credentialsProviders(awsCredentialsProviders).build();
    }

    @Override
    public AwsCredentials getCredentials() {
        if (this.reuseLastProviderEnabled && this.lastUsedProvider != null) {
            return this.lastUsedProvider.getCredentials();
        }
        ArrayList<String> exceptionMessages = null;
        for (AwsCredentialsProvider provider : this.credentialsProviders) {
            try {
                AwsCredentials credentials = provider.getCredentials();
                log.debug("Loading credentials from {}", (Object)provider.toString());
                this.lastUsedProvider = provider;
                return credentials;
            }
            catch (RuntimeException e) {
                String message = provider + ": " + e.getMessage();
                log.debug("Unable to load credentials from " + message, (Throwable)e);
                if (exceptionMessages == null) {
                    exceptionMessages = new ArrayList<String>();
                }
                exceptionMessages.add(message);
            }
        }
        throw new SdkClientException("Unable to load credentials from any of the providers in the chain " + this + ": " + exceptionMessages);
    }

    public void close() {
        this.credentialsProviders.forEach(c -> IoUtils.closeIfCloseable((Object)c, null));
    }

    public String toString() {
        return ToString.builder((String)"AwsCredentialsProviderChain").add("credentialsProviders", this.credentialsProviders).build();
    }

    public static class Builder {
        private Boolean reuseLastProviderEnabled = true;
        private List<AwsCredentialsProvider> credentialsProviders = new ArrayList<AwsCredentialsProvider>();

        private Builder() {
        }

        public Builder reuseLastProviderEnabled(Boolean reuseLastProviderEnabled) {
            this.reuseLastProviderEnabled = reuseLastProviderEnabled;
            return this;
        }

        public Builder credentialsProviders(Collection<? extends AwsCredentialsProvider> credentialsProviders) {
            this.credentialsProviders = new ArrayList<AwsCredentialsProvider>(credentialsProviders);
            return this;
        }

        public Builder credentialsProviders(AwsCredentialsProvider ... credentialsProviders) {
            return this.credentialsProviders(Arrays.asList(credentialsProviders));
        }

        public Builder addCredentialsProvider(AwsCredentialsProvider credentialsProviders) {
            this.credentialsProviders.add(credentialsProviders);
            return this;
        }

        public AwsCredentialsProviderChain build() {
            return new AwsCredentialsProviderChain(this);
        }
    }
}

