/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.authcrt.signer.internal;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.authcrt.signer.internal.SigningUtils;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.crt.auth.signing.AwsSigningConfig;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.RegionScope;

@SdkInternalApi
public class SigningConfigProvider {
    private static final Boolean DEFAULT_DOUBLE_URL_ENCODE = Boolean.TRUE;
    private static final Boolean DEFAULT_PATH_NORMALIZATION = Boolean.TRUE;

    public AwsSigningConfig createCrtSigningConfig(ExecutionAttributes executionAttributes) {
        AwsSigningConfig signingConfig = this.createDefaultRequestConfig(executionAttributes);
        signingConfig.setSignatureType(AwsSigningConfig.AwsSignatureType.HTTP_REQUEST_VIA_HEADERS);
        return signingConfig;
    }

    public AwsSigningConfig createCrtPresigningConfig(ExecutionAttributes executionAttributes) {
        AwsSigningConfig signingConfig = this.createPresigningConfig(executionAttributes);
        signingConfig.setSignatureType(AwsSigningConfig.AwsSignatureType.HTTP_REQUEST_VIA_QUERY_PARAMS);
        return signingConfig;
    }

    public AwsSigningConfig createS3CrtSigningConfig(ExecutionAttributes executionAttributes) {
        AwsSigningConfig signingConfig = this.createDefaultRequestConfig(executionAttributes);
        signingConfig.setSignedBodyHeader(AwsSigningConfig.AwsSignedBodyHeaderType.X_AMZ_CONTENT_SHA256);
        signingConfig.setSignatureType(AwsSigningConfig.AwsSignatureType.HTTP_REQUEST_VIA_HEADERS);
        return signingConfig;
    }

    public AwsSigningConfig createS3CrtPresigningConfig(ExecutionAttributes executionAttributes) {
        AwsSigningConfig signingConfig = this.createPresigningConfig(executionAttributes);
        signingConfig.setSignedBodyHeader(AwsSigningConfig.AwsSignedBodyHeaderType.NONE);
        signingConfig.setSignedBodyValue("UNSIGNED-PAYLOAD");
        signingConfig.setSignatureType(AwsSigningConfig.AwsSignatureType.HTTP_REQUEST_VIA_QUERY_PARAMS);
        return signingConfig;
    }

    public AwsSigningConfig createChunkedSigningConfig(ExecutionAttributes executionAttributes) {
        AwsSigningConfig signingConfig = this.createStringToSignConfig(executionAttributes);
        signingConfig.setSignatureType(AwsSigningConfig.AwsSignatureType.HTTP_REQUEST_CHUNK);
        signingConfig.setSignedBodyHeader(AwsSigningConfig.AwsSignedBodyHeaderType.NONE);
        return signingConfig;
    }

    private AwsSigningConfig createPresigningConfig(ExecutionAttributes executionAttributes) {
        Optional<Instant> expirationTime = Optional.ofNullable((Instant)executionAttributes.getAttribute(AwsSignerExecutionAttribute.PRESIGNER_EXPIRATION));
        long expirationInSeconds = expirationTime.map(end -> Math.max(0L, Duration.between(SigningUtils.getSigningClock(executionAttributes).instant(), end).getSeconds())).orElse(604800L);
        AwsSigningConfig signingConfig = this.createDefaultRequestConfig(executionAttributes);
        signingConfig.setExpirationInSeconds(expirationInSeconds);
        return signingConfig;
    }

    private AwsSigningConfig createDefaultRequestConfig(ExecutionAttributes executionAttributes) {
        AwsSigningConfig signingConfig = this.createStringToSignConfig(executionAttributes);
        if (executionAttributes.getAttribute(AwsSignerExecutionAttribute.SIGNER_NORMALIZE_PATH) != null) {
            signingConfig.setShouldNormalizeUriPath(((Boolean)executionAttributes.getAttribute(AwsSignerExecutionAttribute.SIGNER_NORMALIZE_PATH)).booleanValue());
        } else {
            signingConfig.setShouldNormalizeUriPath(DEFAULT_PATH_NORMALIZATION.booleanValue());
        }
        if (executionAttributes.getAttribute(AwsSignerExecutionAttribute.SIGNER_DOUBLE_URL_ENCODE) != null) {
            signingConfig.setUseDoubleUriEncode(((Boolean)executionAttributes.getAttribute(AwsSignerExecutionAttribute.SIGNER_DOUBLE_URL_ENCODE)).booleanValue());
        } else {
            signingConfig.setUseDoubleUriEncode(DEFAULT_DOUBLE_URL_ENCODE.booleanValue());
        }
        return signingConfig;
    }

    private AwsSigningConfig createStringToSignConfig(ExecutionAttributes executionAttributes) {
        AwsSigningConfig signingConfig = new AwsSigningConfig();
        signingConfig.setCredentials(SigningUtils.buildCredentials(executionAttributes));
        signingConfig.setService((String)executionAttributes.getAttribute(AwsSignerExecutionAttribute.SERVICE_SIGNING_NAME));
        signingConfig.setRegion(this.getRegion(executionAttributes));
        signingConfig.setAlgorithm(AwsSigningConfig.AwsSigningAlgorithm.SIGV4_ASYMMETRIC);
        signingConfig.setTime(SigningUtils.getSigningClock(executionAttributes).instant().toEpochMilli());
        return signingConfig;
    }

    private String getRegion(ExecutionAttributes executionAttributes) {
        RegionScope signingScope = (RegionScope)executionAttributes.getAttribute(AwsSignerExecutionAttribute.SIGNING_REGION_SCOPE);
        return signingScope == null ? ((Region)executionAttributes.getAttribute(AwsSignerExecutionAttribute.SIGNING_REGION)).id() : signingScope.id();
    }
}

