/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManualEvidence
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManualEvidence> {
    private static final SdkField<String> S3_RESOURCE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3ResourcePath").getter(ManualEvidence.getter(ManualEvidence::s3ResourcePath)).setter(ManualEvidence.setter(Builder::s3ResourcePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3ResourcePath").build()}).build();
    private static final SdkField<String> TEXT_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("textResponse").getter(ManualEvidence.getter(ManualEvidence::textResponse)).setter(ManualEvidence.setter(Builder::textResponse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textResponse").build()}).build();
    private static final SdkField<String> EVIDENCE_FILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evidenceFileName").getter(ManualEvidence.getter(ManualEvidence::evidenceFileName)).setter(ManualEvidence.setter(Builder::evidenceFileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceFileName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_RESOURCE_PATH_FIELD, TEXT_RESPONSE_FIELD, EVIDENCE_FILE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("s3ResourcePath", S3_RESOURCE_PATH_FIELD);
            this.put("textResponse", TEXT_RESPONSE_FIELD);
            this.put("evidenceFileName", EVIDENCE_FILE_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String s3ResourcePath;
    private final String textResponse;
    private final String evidenceFileName;

    private ManualEvidence(BuilderImpl builder) {
        this.s3ResourcePath = builder.s3ResourcePath;
        this.textResponse = builder.textResponse;
        this.evidenceFileName = builder.evidenceFileName;
    }

    public final String s3ResourcePath() {
        return this.s3ResourcePath;
    }

    public final String textResponse() {
        return this.textResponse;
    }

    public final String evidenceFileName() {
        return this.evidenceFileName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ResourcePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.textResponse());
        hashCode = 31 * hashCode + Objects.hashCode(this.evidenceFileName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManualEvidence)) {
            return false;
        }
        ManualEvidence other = (ManualEvidence)obj;
        return Objects.equals(this.s3ResourcePath(), other.s3ResourcePath()) && Objects.equals(this.textResponse(), other.textResponse()) && Objects.equals(this.evidenceFileName(), other.evidenceFileName());
    }

    public final String toString() {
        return ToString.builder((String)"ManualEvidence").add("S3ResourcePath", (Object)this.s3ResourcePath()).add("TextResponse", (Object)(this.textResponse() == null ? null : "*** Sensitive Data Redacted ***")).add("EvidenceFileName", (Object)(this.evidenceFileName() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3ResourcePath": {
                return Optional.ofNullable(clazz.cast(this.s3ResourcePath()));
            }
            case "textResponse": {
                return Optional.ofNullable(clazz.cast(this.textResponse()));
            }
            case "evidenceFileName": {
                return Optional.ofNullable(clazz.cast(this.evidenceFileName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ManualEvidence, T> g) {
        return obj -> g.apply((ManualEvidence)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3ResourcePath;
        private String textResponse;
        private String evidenceFileName;

        private BuilderImpl() {
        }

        private BuilderImpl(ManualEvidence model) {
            this.s3ResourcePath(model.s3ResourcePath);
            this.textResponse(model.textResponse);
            this.evidenceFileName(model.evidenceFileName);
        }

        public final String getS3ResourcePath() {
            return this.s3ResourcePath;
        }

        public final void setS3ResourcePath(String s3ResourcePath) {
            this.s3ResourcePath = s3ResourcePath;
        }

        @Override
        public final Builder s3ResourcePath(String s3ResourcePath) {
            this.s3ResourcePath = s3ResourcePath;
            return this;
        }

        public final String getTextResponse() {
            return this.textResponse;
        }

        public final void setTextResponse(String textResponse) {
            this.textResponse = textResponse;
        }

        @Override
        public final Builder textResponse(String textResponse) {
            this.textResponse = textResponse;
            return this;
        }

        public final String getEvidenceFileName() {
            return this.evidenceFileName;
        }

        public final void setEvidenceFileName(String evidenceFileName) {
            this.evidenceFileName = evidenceFileName;
        }

        @Override
        public final Builder evidenceFileName(String evidenceFileName) {
            this.evidenceFileName = evidenceFileName;
            return this;
        }

        public ManualEvidence build() {
            return new ManualEvidence(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManualEvidence> {
        public Builder s3ResourcePath(String var1);

        public Builder textResponse(String var1);

        public Builder evidenceFileName(String var1);
    }
}

