/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ControlSetStatus {
    ACTIVE("ACTIVE"),
    UNDER_REVIEW("UNDER_REVIEW"),
    REVIEWED("REVIEWED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ControlSetStatus> VALUE_MAP;
    private final String value;

    private ControlSetStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ControlSetStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ControlSetStatus> knownValues() {
        EnumSet<ControlSetStatus> knownValues = EnumSet.allOf(ControlSetStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ControlSetStatus.class, ControlSetStatus::toString);
    }
}

