/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.auditmanager.AuditManagerAsyncClient;
import software.amazon.awssdk.services.auditmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsRequest;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse;

public class ListAssessmentFrameworkShareRequestsPublisher
implements SdkPublisher<ListAssessmentFrameworkShareRequestsResponse> {
    private final AuditManagerAsyncClient client;
    private final ListAssessmentFrameworkShareRequestsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssessmentFrameworkShareRequestsPublisher(AuditManagerAsyncClient client, ListAssessmentFrameworkShareRequestsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssessmentFrameworkShareRequestsPublisher(AuditManagerAsyncClient client, ListAssessmentFrameworkShareRequestsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssessmentFrameworkShareRequestsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssessmentFrameworkShareRequestsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAssessmentFrameworkShareRequestsResponseFetcher
    implements AsyncPageFetcher<ListAssessmentFrameworkShareRequestsResponse> {
        private ListAssessmentFrameworkShareRequestsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssessmentFrameworkShareRequestsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssessmentFrameworkShareRequestsResponse> nextPage(ListAssessmentFrameworkShareRequestsResponse previousPage) {
            if (previousPage == null) {
                return ListAssessmentFrameworkShareRequestsPublisher.this.client.listAssessmentFrameworkShareRequests(ListAssessmentFrameworkShareRequestsPublisher.this.firstRequest);
            }
            return ListAssessmentFrameworkShareRequestsPublisher.this.client.listAssessmentFrameworkShareRequests((ListAssessmentFrameworkShareRequestsRequest)((Object)ListAssessmentFrameworkShareRequestsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

