/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerResponse;
import software.amazon.awssdk.services.auditmanager.model.DelegationMetadata;
import software.amazon.awssdk.services.auditmanager.model.DelegationMetadataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDelegationsResponse
extends AuditManagerResponse
implements ToCopyableBuilder<Builder, GetDelegationsResponse> {
    private static final SdkField<List<DelegationMetadata>> DELEGATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("delegations").getter(GetDelegationsResponse.getter(GetDelegationsResponse::delegations)).setter(GetDelegationsResponse.setter(Builder::delegations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("delegations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DelegationMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetDelegationsResponse.getter(GetDelegationsResponse::nextToken)).setter(GetDelegationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELEGATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<DelegationMetadata> delegations;
    private final String nextToken;

    private GetDelegationsResponse(BuilderImpl builder) {
        super(builder);
        this.delegations = builder.delegations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDelegations() {
        return this.delegations != null && !(this.delegations instanceof SdkAutoConstructList);
    }

    public final List<DelegationMetadata> delegations() {
        return this.delegations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDelegations() ? this.delegations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDelegationsResponse)) {
            return false;
        }
        GetDelegationsResponse other = (GetDelegationsResponse)((Object)obj);
        return this.hasDelegations() == other.hasDelegations() && Objects.equals(this.delegations(), other.delegations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetDelegationsResponse").add("Delegations", this.hasDelegations() ? this.delegations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "delegations": {
                return Optional.ofNullable(clazz.cast(this.delegations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDelegationsResponse, T> g) {
        return obj -> g.apply((GetDelegationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerResponse.BuilderImpl
    implements Builder {
        private List<DelegationMetadata> delegations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDelegationsResponse model) {
            super(model);
            this.delegations(model.delegations);
            this.nextToken(model.nextToken);
        }

        public final List<DelegationMetadata.Builder> getDelegations() {
            List<DelegationMetadata.Builder> result = DelegationMetadataListCopier.copyToBuilder(this.delegations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDelegations(Collection<DelegationMetadata.BuilderImpl> delegations) {
            this.delegations = DelegationMetadataListCopier.copyFromBuilder(delegations);
        }

        @Override
        public final Builder delegations(Collection<DelegationMetadata> delegations) {
            this.delegations = DelegationMetadataListCopier.copy(delegations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegations(DelegationMetadata ... delegations) {
            this.delegations(Arrays.asList(delegations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegations(Consumer<DelegationMetadata.Builder> ... delegations) {
            this.delegations(Stream.of(delegations).map(c -> (DelegationMetadata)((DelegationMetadata.Builder)DelegationMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetDelegationsResponse build() {
            return new GetDelegationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AuditManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDelegationsResponse> {
        public Builder delegations(Collection<DelegationMetadata> var1);

        public Builder delegations(DelegationMetadata ... var1);

        public Builder delegations(Consumer<DelegationMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

