/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.auditmanager.AuditManagerClient;
import software.amazon.awssdk.services.auditmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.auditmanager.model.GetChangeLogsRequest;
import software.amazon.awssdk.services.auditmanager.model.GetChangeLogsResponse;

public class GetChangeLogsIterable
implements SdkIterable<GetChangeLogsResponse> {
    private final AuditManagerClient client;
    private final GetChangeLogsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetChangeLogsIterable(AuditManagerClient client, GetChangeLogsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetChangeLogsResponseFetcher();
    }

    public Iterator<GetChangeLogsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetChangeLogsResponseFetcher
    implements SyncPageFetcher<GetChangeLogsResponse> {
        private GetChangeLogsResponseFetcher() {
        }

        public boolean hasNextPage(GetChangeLogsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetChangeLogsResponse nextPage(GetChangeLogsResponse previousPage) {
            if (previousPage == null) {
                return GetChangeLogsIterable.this.client.getChangeLogs(GetChangeLogsIterable.this.firstRequest);
            }
            return GetChangeLogsIterable.this.client.getChangeLogs((GetChangeLogsRequest)((Object)GetChangeLogsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

