/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.auditmanager.AuditManagerClient;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksRequest;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksResponse;

public class ListAssessmentFrameworksIterable
implements SdkIterable<ListAssessmentFrameworksResponse> {
    private final AuditManagerClient client;
    private final ListAssessmentFrameworksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssessmentFrameworksIterable(AuditManagerClient client, ListAssessmentFrameworksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAssessmentFrameworksResponseFetcher();
    }

    public Iterator<ListAssessmentFrameworksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAssessmentFrameworksResponseFetcher
    implements SyncPageFetcher<ListAssessmentFrameworksResponse> {
        private ListAssessmentFrameworksResponseFetcher() {
        }

        public boolean hasNextPage(ListAssessmentFrameworksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssessmentFrameworksResponse nextPage(ListAssessmentFrameworksResponse previousPage) {
            if (previousPage == null) {
                return ListAssessmentFrameworksIterable.this.client.listAssessmentFrameworks(ListAssessmentFrameworksIterable.this.firstRequest);
            }
            return ListAssessmentFrameworksIterable.this.client.listAssessmentFrameworks((ListAssessmentFrameworksRequest)((Object)ListAssessmentFrameworksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

