/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.AWSAccount;
import software.amazon.awssdk.services.auditmanager.model.AWSAccountsCopier;
import software.amazon.awssdk.services.auditmanager.model.AWSService;
import software.amazon.awssdk.services.auditmanager.model.AWSServicesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Scope
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Scope> {
    private static final SdkField<List<AWSAccount>> AWS_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("awsAccounts").getter(Scope.getter(Scope::awsAccounts)).setter(Scope.setter(Builder::awsAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AWSAccount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AWSService>> AWS_SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("awsServices").getter(Scope.getter(Scope::awsServices)).setter(Scope.setter(Builder::awsServices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsServices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AWSService::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNTS_FIELD, AWS_SERVICES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<AWSAccount> awsAccounts;
    private final List<AWSService> awsServices;

    private Scope(BuilderImpl builder) {
        this.awsAccounts = builder.awsAccounts;
        this.awsServices = builder.awsServices;
    }

    public final boolean hasAwsAccounts() {
        return this.awsAccounts != null && !(this.awsAccounts instanceof SdkAutoConstructList);
    }

    public final List<AWSAccount> awsAccounts() {
        return this.awsAccounts;
    }

    public final boolean hasAwsServices() {
        return this.awsServices != null && !(this.awsServices instanceof SdkAutoConstructList);
    }

    public final List<AWSService> awsServices() {
        return this.awsServices;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAwsAccounts() ? this.awsAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAwsServices() ? this.awsServices() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Scope)) {
            return false;
        }
        Scope other = (Scope)obj;
        return this.hasAwsAccounts() == other.hasAwsAccounts() && Objects.equals(this.awsAccounts(), other.awsAccounts()) && this.hasAwsServices() == other.hasAwsServices() && Objects.equals(this.awsServices(), other.awsServices());
    }

    public final String toString() {
        return ToString.builder((String)"Scope").add("AwsAccounts", this.hasAwsAccounts() ? this.awsAccounts() : null).add("AwsServices", this.hasAwsServices() ? this.awsServices() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "awsAccounts": {
                return Optional.ofNullable(clazz.cast(this.awsAccounts()));
            }
            case "awsServices": {
                return Optional.ofNullable(clazz.cast(this.awsServices()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Scope, T> g) {
        return obj -> g.apply((Scope)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AWSAccount> awsAccounts = DefaultSdkAutoConstructList.getInstance();
        private List<AWSService> awsServices = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Scope model) {
            this.awsAccounts(model.awsAccounts);
            this.awsServices(model.awsServices);
        }

        public final Collection<AWSAccount.Builder> getAwsAccounts() {
            if (this.awsAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.awsAccounts != null ? (Collection)this.awsAccounts.stream().map(AWSAccount::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder awsAccounts(Collection<AWSAccount> awsAccounts) {
            this.awsAccounts = AWSAccountsCopier.copy(awsAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsAccounts(AWSAccount ... awsAccounts) {
            this.awsAccounts(Arrays.asList(awsAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsAccounts(Consumer<AWSAccount.Builder> ... awsAccounts) {
            this.awsAccounts(Stream.of(awsAccounts).map(c -> (AWSAccount)((AWSAccount.Builder)AWSAccount.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAwsAccounts(Collection<AWSAccount.BuilderImpl> awsAccounts) {
            this.awsAccounts = AWSAccountsCopier.copyFromBuilder(awsAccounts);
        }

        public final Collection<AWSService.Builder> getAwsServices() {
            if (this.awsServices instanceof SdkAutoConstructList) {
                return null;
            }
            return this.awsServices != null ? (Collection)this.awsServices.stream().map(AWSService::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder awsServices(Collection<AWSService> awsServices) {
            this.awsServices = AWSServicesCopier.copy(awsServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsServices(AWSService ... awsServices) {
            this.awsServices(Arrays.asList(awsServices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsServices(Consumer<AWSService.Builder> ... awsServices) {
            this.awsServices(Stream.of(awsServices).map(c -> (AWSService)((AWSService.Builder)AWSService.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAwsServices(Collection<AWSService.BuilderImpl> awsServices) {
            this.awsServices = AWSServicesCopier.copyFromBuilder(awsServices);
        }

        public Scope build() {
            return new Scope(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Scope> {
        public Builder awsAccounts(Collection<AWSAccount> var1);

        public Builder awsAccounts(AWSAccount ... var1);

        public Builder awsAccounts(Consumer<AWSAccount.Builder> ... var1);

        public Builder awsServices(Collection<AWSService> var1);

        public Builder awsServices(AWSService ... var1);

        public Builder awsServices(Consumer<AWSService.Builder> ... var1);
    }
}

