/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.Control;
import software.amazon.awssdk.services.auditmanager.model.ControlsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ControlSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ControlSet> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ControlSet.getter(ControlSet::id)).setter(ControlSet.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ControlSet.getter(ControlSet::name)).setter(ControlSet.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<Control>> CONTROLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("controls").getter(ControlSet.getter(ControlSet::controls)).setter(ControlSet.setter(Builder::controls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Control::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, CONTROLS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final List<Control> controls;

    private ControlSet(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.controls = builder.controls;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasControls() {
        return this.controls != null && !(this.controls instanceof SdkAutoConstructList);
    }

    public final List<Control> controls() {
        return this.controls;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasControls() ? this.controls() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlSet)) {
            return false;
        }
        ControlSet other = (ControlSet)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && this.hasControls() == other.hasControls() && Objects.equals(this.controls(), other.controls());
    }

    public final String toString() {
        return ToString.builder((String)"ControlSet").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Controls", this.hasControls() ? this.controls() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "controls": {
                return Optional.ofNullable(clazz.cast(this.controls()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ControlSet, T> g) {
        return obj -> g.apply((ControlSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private List<Control> controls = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ControlSet model) {
            this.id(model.id);
            this.name(model.name);
            this.controls(model.controls);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<Control.Builder> getControls() {
            if (this.controls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.controls != null ? (Collection)this.controls.stream().map(Control::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder controls(Collection<Control> controls) {
            this.controls = ControlsCopier.copy(controls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controls(Control ... controls) {
            this.controls(Arrays.asList(controls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controls(Consumer<Control.Builder> ... controls) {
            this.controls(Stream.of(controls).map(c -> (Control)((Control.Builder)Control.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setControls(Collection<Control.BuilderImpl> controls) {
            this.controls = ControlsCopier.copyFromBuilder(controls);
        }

        public ControlSet build() {
            return new ControlSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ControlSet> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder controls(Collection<Control> var1);

        public Builder controls(Control ... var1);

        public Builder controls(Consumer<Control.Builder> ... var1);
    }
}

