/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerRequest;
import software.amazon.awssdk.services.auditmanager.model.EvidenceIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDisassociateAssessmentReportEvidenceRequest
extends AuditManagerRequest
implements ToCopyableBuilder<Builder, BatchDisassociateAssessmentReportEvidenceRequest> {
    private static final SdkField<String> ASSESSMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentId").getter(BatchDisassociateAssessmentReportEvidenceRequest.getter(BatchDisassociateAssessmentReportEvidenceRequest::assessmentId)).setter(BatchDisassociateAssessmentReportEvidenceRequest.setter(Builder::assessmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assessmentId").build()}).build();
    private static final SdkField<String> EVIDENCE_FOLDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evidenceFolderId").getter(BatchDisassociateAssessmentReportEvidenceRequest.getter(BatchDisassociateAssessmentReportEvidenceRequest::evidenceFolderId)).setter(BatchDisassociateAssessmentReportEvidenceRequest.setter(Builder::evidenceFolderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceFolderId").build()}).build();
    private static final SdkField<List<String>> EVIDENCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("evidenceIds").getter(BatchDisassociateAssessmentReportEvidenceRequest.getter(BatchDisassociateAssessmentReportEvidenceRequest::evidenceIds)).setter(BatchDisassociateAssessmentReportEvidenceRequest.setter(Builder::evidenceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_ID_FIELD, EVIDENCE_FOLDER_ID_FIELD, EVIDENCE_IDS_FIELD));
    private final String assessmentId;
    private final String evidenceFolderId;
    private final List<String> evidenceIds;

    private BatchDisassociateAssessmentReportEvidenceRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentId = builder.assessmentId;
        this.evidenceFolderId = builder.evidenceFolderId;
        this.evidenceIds = builder.evidenceIds;
    }

    public final String assessmentId() {
        return this.assessmentId;
    }

    public final String evidenceFolderId() {
        return this.evidenceFolderId;
    }

    public final boolean hasEvidenceIds() {
        return this.evidenceIds != null && !(this.evidenceIds instanceof SdkAutoConstructList);
    }

    public final List<String> evidenceIds() {
        return this.evidenceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evidenceFolderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvidenceIds() ? this.evidenceIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDisassociateAssessmentReportEvidenceRequest)) {
            return false;
        }
        BatchDisassociateAssessmentReportEvidenceRequest other = (BatchDisassociateAssessmentReportEvidenceRequest)((Object)obj);
        return Objects.equals(this.assessmentId(), other.assessmentId()) && Objects.equals(this.evidenceFolderId(), other.evidenceFolderId()) && this.hasEvidenceIds() == other.hasEvidenceIds() && Objects.equals(this.evidenceIds(), other.evidenceIds());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDisassociateAssessmentReportEvidenceRequest").add("AssessmentId", (Object)this.assessmentId()).add("EvidenceFolderId", (Object)this.evidenceFolderId()).add("EvidenceIds", this.hasEvidenceIds() ? this.evidenceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentId": {
                return Optional.ofNullable(clazz.cast(this.assessmentId()));
            }
            case "evidenceFolderId": {
                return Optional.ofNullable(clazz.cast(this.evidenceFolderId()));
            }
            case "evidenceIds": {
                return Optional.ofNullable(clazz.cast(this.evidenceIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDisassociateAssessmentReportEvidenceRequest, T> g) {
        return obj -> g.apply((BatchDisassociateAssessmentReportEvidenceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerRequest.BuilderImpl
    implements Builder {
        private String assessmentId;
        private String evidenceFolderId;
        private List<String> evidenceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDisassociateAssessmentReportEvidenceRequest model) {
            super(model);
            this.assessmentId(model.assessmentId);
            this.evidenceFolderId(model.evidenceFolderId);
            this.evidenceIds(model.evidenceIds);
        }

        public final String getAssessmentId() {
            return this.assessmentId;
        }

        @Override
        public final Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            return this;
        }

        public final void setAssessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
        }

        public final String getEvidenceFolderId() {
            return this.evidenceFolderId;
        }

        @Override
        public final Builder evidenceFolderId(String evidenceFolderId) {
            this.evidenceFolderId = evidenceFolderId;
            return this;
        }

        public final void setEvidenceFolderId(String evidenceFolderId) {
            this.evidenceFolderId = evidenceFolderId;
        }

        public final Collection<String> getEvidenceIds() {
            if (this.evidenceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.evidenceIds;
        }

        @Override
        public final Builder evidenceIds(Collection<String> evidenceIds) {
            this.evidenceIds = EvidenceIdsCopier.copy(evidenceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evidenceIds(String ... evidenceIds) {
            this.evidenceIds(Arrays.asList(evidenceIds));
            return this;
        }

        public final void setEvidenceIds(Collection<String> evidenceIds) {
            this.evidenceIds = EvidenceIdsCopier.copy(evidenceIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDisassociateAssessmentReportEvidenceRequest build() {
            return new BatchDisassociateAssessmentReportEvidenceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AuditManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDisassociateAssessmentReportEvidenceRequest> {
        public Builder assessmentId(String var1);

        public Builder evidenceFolderId(String var1);

        public Builder evidenceIds(Collection<String> var1);

        public Builder evidenceIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

