/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.AssessmentReportsDestination;
import software.amazon.awssdk.services.auditmanager.model.AssessmentStatus;
import software.amazon.awssdk.services.auditmanager.model.Delegation;
import software.amazon.awssdk.services.auditmanager.model.DelegationsCopier;
import software.amazon.awssdk.services.auditmanager.model.Role;
import software.amazon.awssdk.services.auditmanager.model.RolesCopier;
import software.amazon.awssdk.services.auditmanager.model.Scope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssessmentMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssessmentMetadata> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AssessmentMetadata.getter(AssessmentMetadata::name)).setter(AssessmentMetadata.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(AssessmentMetadata.getter(AssessmentMetadata::id)).setter(AssessmentMetadata.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AssessmentMetadata.getter(AssessmentMetadata::description)).setter(AssessmentMetadata.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("complianceType").getter(AssessmentMetadata.getter(AssessmentMetadata::complianceType)).setter(AssessmentMetadata.setter(Builder::complianceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AssessmentMetadata.getter(AssessmentMetadata::statusAsString)).setter(AssessmentMetadata.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<AssessmentReportsDestination> ASSESSMENT_REPORTS_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("assessmentReportsDestination").getter(AssessmentMetadata.getter(AssessmentMetadata::assessmentReportsDestination)).setter(AssessmentMetadata.setter(Builder::assessmentReportsDestination)).constructor(AssessmentReportsDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentReportsDestination").build()}).build();
    private static final SdkField<Scope> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scope").getter(AssessmentMetadata.getter(AssessmentMetadata::scope)).setter(AssessmentMetadata.setter(Builder::scope)).constructor(Scope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()}).build();
    private static final SdkField<List<Role>> ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("roles").getter(AssessmentMetadata.getter(AssessmentMetadata::roles)).setter(AssessmentMetadata.setter(Builder::roles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Role::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Delegation>> DELEGATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("delegations").getter(AssessmentMetadata.getter(AssessmentMetadata::delegations)).setter(AssessmentMetadata.setter(Builder::delegations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("delegations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Delegation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(AssessmentMetadata.getter(AssessmentMetadata::creationTime)).setter(AssessmentMetadata.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdated").getter(AssessmentMetadata.getter(AssessmentMetadata::lastUpdated)).setter(AssessmentMetadata.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdated").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD, DESCRIPTION_FIELD, COMPLIANCE_TYPE_FIELD, STATUS_FIELD, ASSESSMENT_REPORTS_DESTINATION_FIELD, SCOPE_FIELD, ROLES_FIELD, DELEGATIONS_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String id;
    private final String description;
    private final String complianceType;
    private final String status;
    private final AssessmentReportsDestination assessmentReportsDestination;
    private final Scope scope;
    private final List<Role> roles;
    private final List<Delegation> delegations;
    private final Instant creationTime;
    private final Instant lastUpdated;

    private AssessmentMetadata(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.description = builder.description;
        this.complianceType = builder.complianceType;
        this.status = builder.status;
        this.assessmentReportsDestination = builder.assessmentReportsDestination;
        this.scope = builder.scope;
        this.roles = builder.roles;
        this.delegations = builder.delegations;
        this.creationTime = builder.creationTime;
        this.lastUpdated = builder.lastUpdated;
    }

    public final String name() {
        return this.name;
    }

    public final String id() {
        return this.id;
    }

    public final String description() {
        return this.description;
    }

    public final String complianceType() {
        return this.complianceType;
    }

    public final AssessmentStatus status() {
        return AssessmentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final AssessmentReportsDestination assessmentReportsDestination() {
        return this.assessmentReportsDestination;
    }

    public final Scope scope() {
        return this.scope;
    }

    public final boolean hasRoles() {
        return this.roles != null && !(this.roles instanceof SdkAutoConstructList);
    }

    public final List<Role> roles() {
        return this.roles;
    }

    public final boolean hasDelegations() {
        return this.delegations != null && !(this.delegations instanceof SdkAutoConstructList);
    }

    public final List<Delegation> delegations() {
        return this.delegations;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdated() {
        return this.lastUpdated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentReportsDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoles() ? this.roles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDelegations() ? this.delegations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentMetadata)) {
            return false;
        }
        AssessmentMetadata other = (AssessmentMetadata)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.complianceType(), other.complianceType()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.assessmentReportsDestination(), other.assessmentReportsDestination()) && Objects.equals(this.scope(), other.scope()) && this.hasRoles() == other.hasRoles() && Objects.equals(this.roles(), other.roles()) && this.hasDelegations() == other.hasDelegations() && Objects.equals(this.delegations(), other.delegations()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdated(), other.lastUpdated());
    }

    public final String toString() {
        return ToString.builder((String)"AssessmentMetadata").add("Name", (Object)this.name()).add("Id", (Object)this.id()).add("Description", (Object)this.description()).add("ComplianceType", (Object)this.complianceType()).add("Status", (Object)this.statusAsString()).add("AssessmentReportsDestination", (Object)this.assessmentReportsDestination()).add("Scope", (Object)this.scope()).add("Roles", this.hasRoles() ? this.roles() : null).add("Delegations", this.hasDelegations() ? this.delegations() : null).add("CreationTime", (Object)this.creationTime()).add("LastUpdated", (Object)this.lastUpdated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "complianceType": {
                return Optional.ofNullable(clazz.cast(this.complianceType()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "assessmentReportsDestination": {
                return Optional.ofNullable(clazz.cast(this.assessmentReportsDestination()));
            }
            case "scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
            case "roles": {
                return Optional.ofNullable(clazz.cast(this.roles()));
            }
            case "delegations": {
                return Optional.ofNullable(clazz.cast(this.delegations()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentMetadata, T> g) {
        return obj -> g.apply((AssessmentMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String id;
        private String description;
        private String complianceType;
        private String status;
        private AssessmentReportsDestination assessmentReportsDestination;
        private Scope scope;
        private List<Role> roles = DefaultSdkAutoConstructList.getInstance();
        private List<Delegation> delegations = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTime;
        private Instant lastUpdated;

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentMetadata model) {
            this.name(model.name);
            this.id(model.id);
            this.description(model.description);
            this.complianceType(model.complianceType);
            this.status(model.status);
            this.assessmentReportsDestination(model.assessmentReportsDestination);
            this.scope(model.scope);
            this.roles(model.roles);
            this.delegations(model.delegations);
            this.creationTime(model.creationTime);
            this.lastUpdated(model.lastUpdated);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AssessmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final AssessmentReportsDestination.Builder getAssessmentReportsDestination() {
            return this.assessmentReportsDestination != null ? this.assessmentReportsDestination.toBuilder() : null;
        }

        @Override
        public final Builder assessmentReportsDestination(AssessmentReportsDestination assessmentReportsDestination) {
            this.assessmentReportsDestination = assessmentReportsDestination;
            return this;
        }

        public final void setAssessmentReportsDestination(AssessmentReportsDestination.BuilderImpl assessmentReportsDestination) {
            this.assessmentReportsDestination = assessmentReportsDestination != null ? assessmentReportsDestination.build() : null;
        }

        public final Scope.Builder getScope() {
            return this.scope != null ? this.scope.toBuilder() : null;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public final void setScope(Scope.BuilderImpl scope) {
            this.scope = scope != null ? scope.build() : null;
        }

        public final Collection<Role.Builder> getRoles() {
            if (this.roles instanceof SdkAutoConstructList) {
                return null;
            }
            return this.roles != null ? (Collection)this.roles.stream().map(Role::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder roles(Collection<Role> roles) {
            this.roles = RolesCopier.copy(roles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(Role ... roles) {
            this.roles(Arrays.asList(roles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(Consumer<Role.Builder> ... roles) {
            this.roles(Stream.of(roles).map(c -> (Role)((Role.Builder)Role.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRoles(Collection<Role.BuilderImpl> roles) {
            this.roles = RolesCopier.copyFromBuilder(roles);
        }

        public final Collection<Delegation.Builder> getDelegations() {
            if (this.delegations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.delegations != null ? (Collection)this.delegations.stream().map(Delegation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder delegations(Collection<Delegation> delegations) {
            this.delegations = DelegationsCopier.copy(delegations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegations(Delegation ... delegations) {
            this.delegations(Arrays.asList(delegations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegations(Consumer<Delegation.Builder> ... delegations) {
            this.delegations(Stream.of(delegations).map(c -> (Delegation)((Delegation.Builder)Delegation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDelegations(Collection<Delegation.BuilderImpl> delegations) {
            this.delegations = DelegationsCopier.copyFromBuilder(delegations);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        public AssessmentMetadata build() {
            return new AssessmentMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssessmentMetadata> {
        public Builder name(String var1);

        public Builder id(String var1);

        public Builder description(String var1);

        public Builder complianceType(String var1);

        public Builder status(String var1);

        public Builder status(AssessmentStatus var1);

        public Builder assessmentReportsDestination(AssessmentReportsDestination var1);

        default public Builder assessmentReportsDestination(Consumer<AssessmentReportsDestination.Builder> assessmentReportsDestination) {
            return this.assessmentReportsDestination((AssessmentReportsDestination)((AssessmentReportsDestination.Builder)AssessmentReportsDestination.builder().applyMutation(assessmentReportsDestination)).build());
        }

        public Builder scope(Scope var1);

        default public Builder scope(Consumer<Scope.Builder> scope) {
            return this.scope((Scope)((Scope.Builder)Scope.builder().applyMutation(scope)).build());
        }

        public Builder roles(Collection<Role> var1);

        public Builder roles(Role ... var1);

        public Builder roles(Consumer<Role.Builder> ... var1);

        public Builder delegations(Collection<Delegation> var1);

        public Builder delegations(Delegation ... var1);

        public Builder delegations(Consumer<Delegation.Builder> ... var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdated(Instant var1);
    }
}

