/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The wrapper that contains the AWS accounts and AWS services in scope for the assessment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Scope implements SdkPojo, Serializable, ToCopyableBuilder<Scope.Builder, Scope> {
    private static final SdkField<List<AWSAccount>> AWS_ACCOUNTS_FIELD = SdkField
            .<List<AWSAccount>> builder(MarshallingType.LIST)
            .memberName("awsAccounts")
            .getter(getter(Scope::awsAccounts))
            .setter(setter(Builder::awsAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AWSAccount> builder(MarshallingType.SDK_POJO)
                                            .constructor(AWSAccount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AWSService>> AWS_SERVICES_FIELD = SdkField
            .<List<AWSService>> builder(MarshallingType.LIST)
            .memberName("awsServices")
            .getter(getter(Scope::awsServices))
            .setter(setter(Builder::awsServices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsServices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AWSService> builder(MarshallingType.SDK_POJO)
                                            .constructor(AWSService::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNTS_FIELD,
            AWS_SERVICES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AWSAccount> awsAccounts;

    private final List<AWSService> awsServices;

    private Scope(BuilderImpl builder) {
        this.awsAccounts = builder.awsAccounts;
        this.awsServices = builder.awsServices;
    }

    /**
     * Returns true if the AwsAccounts property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAwsAccounts() {
        return awsAccounts != null && !(awsAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The AWS accounts included in the scope of the assessment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAwsAccounts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The AWS accounts included in the scope of the assessment.
     */
    public final List<AWSAccount> awsAccounts() {
        return awsAccounts;
    }

    /**
     * Returns true if the AwsServices property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAwsServices() {
        return awsServices != null && !(awsServices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The AWS services included in the scope of the assessment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAwsServices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The AWS services included in the scope of the assessment.
     */
    public final List<AWSService> awsServices() {
        return awsServices;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAwsAccounts() ? awsAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAwsServices() ? awsServices() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Scope)) {
            return false;
        }
        Scope other = (Scope) obj;
        return hasAwsAccounts() == other.hasAwsAccounts() && Objects.equals(awsAccounts(), other.awsAccounts())
                && hasAwsServices() == other.hasAwsServices() && Objects.equals(awsServices(), other.awsServices());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Scope").add("AwsAccounts", hasAwsAccounts() ? awsAccounts() : null)
                .add("AwsServices", hasAwsServices() ? awsServices() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsAccounts":
            return Optional.ofNullable(clazz.cast(awsAccounts()));
        case "awsServices":
            return Optional.ofNullable(clazz.cast(awsServices()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Scope, T> g) {
        return obj -> g.apply((Scope) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Scope> {
        /**
         * <p>
         * The AWS accounts included in the scope of the assessment.
         * </p>
         * 
         * @param awsAccounts
         *        The AWS accounts included in the scope of the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccounts(Collection<AWSAccount> awsAccounts);

        /**
         * <p>
         * The AWS accounts included in the scope of the assessment.
         * </p>
         * 
         * @param awsAccounts
         *        The AWS accounts included in the scope of the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccounts(AWSAccount... awsAccounts);

        /**
         * <p>
         * The AWS accounts included in the scope of the assessment.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AWSAccount>.Builder} avoiding the need to
         * create one manually via {@link List<AWSAccount>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AWSAccount>.Builder#build()} is called immediately and its
         * result is passed to {@link #awsAccounts(List<AWSAccount>)}.
         * 
         * @param awsAccounts
         *        a consumer that will call methods on {@link List<AWSAccount>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsAccounts(List<AWSAccount>)
         */
        Builder awsAccounts(Consumer<AWSAccount.Builder>... awsAccounts);

        /**
         * <p>
         * The AWS services included in the scope of the assessment.
         * </p>
         * 
         * @param awsServices
         *        The AWS services included in the scope of the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsServices(Collection<AWSService> awsServices);

        /**
         * <p>
         * The AWS services included in the scope of the assessment.
         * </p>
         * 
         * @param awsServices
         *        The AWS services included in the scope of the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsServices(AWSService... awsServices);

        /**
         * <p>
         * The AWS services included in the scope of the assessment.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AWSService>.Builder} avoiding the need to
         * create one manually via {@link List<AWSService>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AWSService>.Builder#build()} is called immediately and its
         * result is passed to {@link #awsServices(List<AWSService>)}.
         * 
         * @param awsServices
         *        a consumer that will call methods on {@link List<AWSService>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsServices(List<AWSService>)
         */
        Builder awsServices(Consumer<AWSService.Builder>... awsServices);
    }

    static final class BuilderImpl implements Builder {
        private List<AWSAccount> awsAccounts = DefaultSdkAutoConstructList.getInstance();

        private List<AWSService> awsServices = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Scope model) {
            awsAccounts(model.awsAccounts);
            awsServices(model.awsServices);
        }

        public final Collection<AWSAccount.Builder> getAwsAccounts() {
            if (awsAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return awsAccounts != null ? awsAccounts.stream().map(AWSAccount::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder awsAccounts(Collection<AWSAccount> awsAccounts) {
            this.awsAccounts = AWSAccountsCopier.copy(awsAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsAccounts(AWSAccount... awsAccounts) {
            awsAccounts(Arrays.asList(awsAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsAccounts(Consumer<AWSAccount.Builder>... awsAccounts) {
            awsAccounts(Stream.of(awsAccounts).map(c -> AWSAccount.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAwsAccounts(Collection<AWSAccount.BuilderImpl> awsAccounts) {
            this.awsAccounts = AWSAccountsCopier.copyFromBuilder(awsAccounts);
        }

        public final Collection<AWSService.Builder> getAwsServices() {
            if (awsServices instanceof SdkAutoConstructList) {
                return null;
            }
            return awsServices != null ? awsServices.stream().map(AWSService::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder awsServices(Collection<AWSService> awsServices) {
            this.awsServices = AWSServicesCopier.copy(awsServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsServices(AWSService... awsServices) {
            awsServices(Arrays.asList(awsServices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsServices(Consumer<AWSService.Builder>... awsServices) {
            awsServices(Stream.of(awsServices).map(c -> AWSService.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAwsServices(Collection<AWSService.BuilderImpl> awsServices) {
            this.awsServices = AWSServicesCopier.copyFromBuilder(awsServices);
        }

        @Override
        public Scope build() {
            return new Scope(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
