/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOrganizationAdminAccountResponse extends AuditManagerResponse implements
        ToCopyableBuilder<GetOrganizationAdminAccountResponse.Builder, GetOrganizationAdminAccountResponse> {
    private static final SdkField<String> ADMIN_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("adminAccountId").getter(getter(GetOrganizationAdminAccountResponse::adminAccountId))
            .setter(setter(Builder::adminAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminAccountId").build()).build();

    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("organizationId").getter(getter(GetOrganizationAdminAccountResponse::organizationId))
            .setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_ACCOUNT_ID_FIELD,
            ORGANIZATION_ID_FIELD));

    private final String adminAccountId;

    private final String organizationId;

    private GetOrganizationAdminAccountResponse(BuilderImpl builder) {
        super(builder);
        this.adminAccountId = builder.adminAccountId;
        this.organizationId = builder.organizationId;
    }

    /**
     * <p>
     * The identifier for the specified administrator account.
     * </p>
     * 
     * @return The identifier for the specified administrator account.
     */
    public final String adminAccountId() {
        return adminAccountId;
    }

    /**
     * <p>
     * The identifier for the specified organization.
     * </p>
     * 
     * @return The identifier for the specified organization.
     */
    public final String organizationId() {
        return organizationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(adminAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOrganizationAdminAccountResponse)) {
            return false;
        }
        GetOrganizationAdminAccountResponse other = (GetOrganizationAdminAccountResponse) obj;
        return Objects.equals(adminAccountId(), other.adminAccountId())
                && Objects.equals(organizationId(), other.organizationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetOrganizationAdminAccountResponse").add("AdminAccountId", adminAccountId())
                .add("OrganizationId", organizationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "adminAccountId":
            return Optional.ofNullable(clazz.cast(adminAccountId()));
        case "organizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOrganizationAdminAccountResponse, T> g) {
        return obj -> g.apply((GetOrganizationAdminAccountResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetOrganizationAdminAccountResponse> {
        /**
         * <p>
         * The identifier for the specified administrator account.
         * </p>
         * 
         * @param adminAccountId
         *        The identifier for the specified administrator account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminAccountId(String adminAccountId);

        /**
         * <p>
         * The identifier for the specified organization.
         * </p>
         * 
         * @param organizationId
         *        The identifier for the specified organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);
    }

    static final class BuilderImpl extends AuditManagerResponse.BuilderImpl implements Builder {
        private String adminAccountId;

        private String organizationId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOrganizationAdminAccountResponse model) {
            super(model);
            adminAccountId(model.adminAccountId);
            organizationId(model.organizationId);
        }

        public final String getAdminAccountId() {
            return adminAccountId;
        }

        @Override
        public final Builder adminAccountId(String adminAccountId) {
            this.adminAccountId = adminAccountId;
            return this;
        }

        public final void setAdminAccountId(String adminAccountId) {
            this.adminAccountId = adminAccountId;
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public GetOrganizationAdminAccountResponse build() {
            return new GetOrganizationAdminAccountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
