/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A record that contains the information needed to demonstrate compliance with the requirements specified by a control.
 * Examples of evidence include change activity triggered by a user, or a system configuration snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Evidence implements SdkPojo, Serializable, ToCopyableBuilder<Evidence.Builder, Evidence> {
    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSource").getter(getter(Evidence::dataSource)).setter(setter(Builder::dataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()).build();

    private static final SdkField<String> EVIDENCE_AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("evidenceAwsAccountId").getter(getter(Evidence::evidenceAwsAccountId))
            .setter(setter(Builder::evidenceAwsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceAwsAccountId").build())
            .build();

    private static final SdkField<Instant> TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("time")
            .getter(getter(Evidence::time)).setter(setter(Builder::time))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("time").build()).build();

    private static final SdkField<String> EVENT_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventSource").getter(getter(Evidence::eventSource)).setter(setter(Builder::eventSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventSource").build()).build();

    private static final SdkField<String> EVENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventName").getter(getter(Evidence::eventName)).setter(setter(Builder::eventName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventName").build()).build();

    private static final SdkField<String> EVIDENCE_BY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("evidenceByType").getter(getter(Evidence::evidenceByType)).setter(setter(Builder::evidenceByType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceByType").build()).build();

    private static final SdkField<List<Resource>> RESOURCES_INCLUDED_FIELD = SdkField
            .<List<Resource>> builder(MarshallingType.LIST)
            .memberName("resourcesIncluded")
            .getter(getter(Evidence::resourcesIncluded))
            .setter(setter(Builder::resourcesIncluded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesIncluded").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Resource> builder(MarshallingType.SDK_POJO)
                                            .constructor(Resource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("attributes")
            .getter(getter(Evidence::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> IAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("iamId")
            .getter(getter(Evidence::iamId)).setter(setter(Builder::iamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamId").build()).build();

    private static final SdkField<String> COMPLIANCE_CHECK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("complianceCheck").getter(getter(Evidence::complianceCheck)).setter(setter(Builder::complianceCheck))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceCheck").build()).build();

    private static final SdkField<String> AWS_ORGANIZATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsOrganization").getter(getter(Evidence::awsOrganization)).setter(setter(Builder::awsOrganization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsOrganization").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountId").getter(getter(Evidence::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()).build();

    private static final SdkField<String> EVIDENCE_FOLDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("evidenceFolderId").getter(getter(Evidence::evidenceFolderId)).setter(setter(Builder::evidenceFolderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceFolderId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Evidence::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ASSESSMENT_REPORT_SELECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentReportSelection").getter(getter(Evidence::assessmentReportSelection))
            .setter(setter(Builder::assessmentReportSelection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentReportSelection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD,
            EVIDENCE_AWS_ACCOUNT_ID_FIELD, TIME_FIELD, EVENT_SOURCE_FIELD, EVENT_NAME_FIELD, EVIDENCE_BY_TYPE_FIELD,
            RESOURCES_INCLUDED_FIELD, ATTRIBUTES_FIELD, IAM_ID_FIELD, COMPLIANCE_CHECK_FIELD, AWS_ORGANIZATION_FIELD,
            AWS_ACCOUNT_ID_FIELD, EVIDENCE_FOLDER_ID_FIELD, ID_FIELD, ASSESSMENT_REPORT_SELECTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataSource;

    private final String evidenceAwsAccountId;

    private final Instant time;

    private final String eventSource;

    private final String eventName;

    private final String evidenceByType;

    private final List<Resource> resourcesIncluded;

    private final Map<String, String> attributes;

    private final String iamId;

    private final String complianceCheck;

    private final String awsOrganization;

    private final String awsAccountId;

    private final String evidenceFolderId;

    private final String id;

    private final String assessmentReportSelection;

    private Evidence(BuilderImpl builder) {
        this.dataSource = builder.dataSource;
        this.evidenceAwsAccountId = builder.evidenceAwsAccountId;
        this.time = builder.time;
        this.eventSource = builder.eventSource;
        this.eventName = builder.eventName;
        this.evidenceByType = builder.evidenceByType;
        this.resourcesIncluded = builder.resourcesIncluded;
        this.attributes = builder.attributes;
        this.iamId = builder.iamId;
        this.complianceCheck = builder.complianceCheck;
        this.awsOrganization = builder.awsOrganization;
        this.awsAccountId = builder.awsAccountId;
        this.evidenceFolderId = builder.evidenceFolderId;
        this.id = builder.id;
        this.assessmentReportSelection = builder.assessmentReportSelection;
    }

    /**
     * <p>
     * The data source from which the specified evidence was collected.
     * </p>
     * 
     * @return The data source from which the specified evidence was collected.
     */
    public final String dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * The identifier for the specified AWS account.
     * </p>
     * 
     * @return The identifier for the specified AWS account.
     */
    public final String evidenceAwsAccountId() {
        return evidenceAwsAccountId;
    }

    /**
     * <p>
     * The timestamp that represents when the evidence was collected.
     * </p>
     * 
     * @return The timestamp that represents when the evidence was collected.
     */
    public final Instant time() {
        return time;
    }

    /**
     * <p>
     * The AWS service from which the evidence is collected.
     * </p>
     * 
     * @return The AWS service from which the evidence is collected.
     */
    public final String eventSource() {
        return eventSource;
    }

    /**
     * <p>
     * The name of the specified evidence event.
     * </p>
     * 
     * @return The name of the specified evidence event.
     */
    public final String eventName() {
        return eventName;
    }

    /**
     * <p>
     * The type of automated evidence.
     * </p>
     * 
     * @return The type of automated evidence.
     */
    public final String evidenceByType() {
        return evidenceByType;
    }

    /**
     * Returns true if the ResourcesIncluded property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasResourcesIncluded() {
        return resourcesIncluded != null && !(resourcesIncluded instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of resources assessed to generate the evidence.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourcesIncluded()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of resources assessed to generate the evidence.
     */
    public final List<Resource> resourcesIncluded() {
        return resourcesIncluded;
    }

    /**
     * Returns true if the Attributes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The names and values used by the evidence event, including an attribute name (such as
     * <code>allowUsersToChangePassword</code>) and value (such as <code>true</code> or <code>false</code>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The names and values used by the evidence event, including an attribute name (such as
     *         <code>allowUsersToChangePassword</code>) and value (such as <code>true</code> or <code>false</code>).
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The unique identifier for the IAM user or role associated with the evidence.
     * </p>
     * 
     * @return The unique identifier for the IAM user or role associated with the evidence.
     */
    public final String iamId() {
        return iamId;
    }

    /**
     * <p>
     * The evaluation status for evidence that falls under the compliance check category. For evidence collected from
     * AWS Security Hub, a <i>Pass</i> or <i>Fail</i> result is shown. For evidence collected from AWS Config, a
     * <i>Compliant</i> or <i>Noncompliant</i> result is shown.
     * </p>
     * 
     * @return The evaluation status for evidence that falls under the compliance check category. For evidence collected
     *         from AWS Security Hub, a <i>Pass</i> or <i>Fail</i> result is shown. For evidence collected from AWS
     *         Config, a <i>Compliant</i> or <i>Noncompliant</i> result is shown.
     */
    public final String complianceCheck() {
        return complianceCheck;
    }

    /**
     * <p>
     * The AWS account from which the evidence is collected, and its AWS organization path.
     * </p>
     * 
     * @return The AWS account from which the evidence is collected, and its AWS organization path.
     */
    public final String awsOrganization() {
        return awsOrganization;
    }

    /**
     * <p>
     * The identifier for the specified AWS account.
     * </p>
     * 
     * @return The identifier for the specified AWS account.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The identifier for the folder in which the evidence is stored.
     * </p>
     * 
     * @return The identifier for the folder in which the evidence is stored.
     */
    public final String evidenceFolderId() {
        return evidenceFolderId;
    }

    /**
     * <p>
     * The identifier for the evidence.
     * </p>
     * 
     * @return The identifier for the evidence.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Specifies whether the evidence is inclded in the assessment report.
     * </p>
     * 
     * @return Specifies whether the evidence is inclded in the assessment report.
     */
    public final String assessmentReportSelection() {
        return assessmentReportSelection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(evidenceAwsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(time());
        hashCode = 31 * hashCode + Objects.hashCode(eventSource());
        hashCode = 31 * hashCode + Objects.hashCode(eventName());
        hashCode = 31 * hashCode + Objects.hashCode(evidenceByType());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourcesIncluded() ? resourcesIncluded() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(iamId());
        hashCode = 31 * hashCode + Objects.hashCode(complianceCheck());
        hashCode = 31 * hashCode + Objects.hashCode(awsOrganization());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(evidenceFolderId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentReportSelection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Evidence)) {
            return false;
        }
        Evidence other = (Evidence) obj;
        return Objects.equals(dataSource(), other.dataSource())
                && Objects.equals(evidenceAwsAccountId(), other.evidenceAwsAccountId()) && Objects.equals(time(), other.time())
                && Objects.equals(eventSource(), other.eventSource()) && Objects.equals(eventName(), other.eventName())
                && Objects.equals(evidenceByType(), other.evidenceByType())
                && hasResourcesIncluded() == other.hasResourcesIncluded()
                && Objects.equals(resourcesIncluded(), other.resourcesIncluded()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes()) && Objects.equals(iamId(), other.iamId())
                && Objects.equals(complianceCheck(), other.complianceCheck())
                && Objects.equals(awsOrganization(), other.awsOrganization())
                && Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(evidenceFolderId(), other.evidenceFolderId()) && Objects.equals(id(), other.id())
                && Objects.equals(assessmentReportSelection(), other.assessmentReportSelection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Evidence").add("DataSource", dataSource()).add("EvidenceAwsAccountId", evidenceAwsAccountId())
                .add("Time", time()).add("EventSource", eventSource()).add("EventName", eventName())
                .add("EvidenceByType", evidenceByType())
                .add("ResourcesIncluded", hasResourcesIncluded() ? resourcesIncluded() : null)
                .add("Attributes", hasAttributes() ? attributes() : null).add("IamId", iamId())
                .add("ComplianceCheck", complianceCheck()).add("AwsOrganization", awsOrganization())
                .add("AwsAccountId", awsAccountId()).add("EvidenceFolderId", evidenceFolderId()).add("Id", id())
                .add("AssessmentReportSelection", assessmentReportSelection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "evidenceAwsAccountId":
            return Optional.ofNullable(clazz.cast(evidenceAwsAccountId()));
        case "time":
            return Optional.ofNullable(clazz.cast(time()));
        case "eventSource":
            return Optional.ofNullable(clazz.cast(eventSource()));
        case "eventName":
            return Optional.ofNullable(clazz.cast(eventName()));
        case "evidenceByType":
            return Optional.ofNullable(clazz.cast(evidenceByType()));
        case "resourcesIncluded":
            return Optional.ofNullable(clazz.cast(resourcesIncluded()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "iamId":
            return Optional.ofNullable(clazz.cast(iamId()));
        case "complianceCheck":
            return Optional.ofNullable(clazz.cast(complianceCheck()));
        case "awsOrganization":
            return Optional.ofNullable(clazz.cast(awsOrganization()));
        case "awsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "evidenceFolderId":
            return Optional.ofNullable(clazz.cast(evidenceFolderId()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "assessmentReportSelection":
            return Optional.ofNullable(clazz.cast(assessmentReportSelection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Evidence, T> g) {
        return obj -> g.apply((Evidence) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Evidence> {
        /**
         * <p>
         * The data source from which the specified evidence was collected.
         * </p>
         * 
         * @param dataSource
         *        The data source from which the specified evidence was collected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(String dataSource);

        /**
         * <p>
         * The identifier for the specified AWS account.
         * </p>
         * 
         * @param evidenceAwsAccountId
         *        The identifier for the specified AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceAwsAccountId(String evidenceAwsAccountId);

        /**
         * <p>
         * The timestamp that represents when the evidence was collected.
         * </p>
         * 
         * @param time
         *        The timestamp that represents when the evidence was collected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder time(Instant time);

        /**
         * <p>
         * The AWS service from which the evidence is collected.
         * </p>
         * 
         * @param eventSource
         *        The AWS service from which the evidence is collected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSource(String eventSource);

        /**
         * <p>
         * The name of the specified evidence event.
         * </p>
         * 
         * @param eventName
         *        The name of the specified evidence event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventName(String eventName);

        /**
         * <p>
         * The type of automated evidence.
         * </p>
         * 
         * @param evidenceByType
         *        The type of automated evidence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceByType(String evidenceByType);

        /**
         * <p>
         * The list of resources assessed to generate the evidence.
         * </p>
         * 
         * @param resourcesIncluded
         *        The list of resources assessed to generate the evidence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesIncluded(Collection<Resource> resourcesIncluded);

        /**
         * <p>
         * The list of resources assessed to generate the evidence.
         * </p>
         * 
         * @param resourcesIncluded
         *        The list of resources assessed to generate the evidence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesIncluded(Resource... resourcesIncluded);

        /**
         * <p>
         * The list of resources assessed to generate the evidence.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Resource>.Builder} avoiding the need to
         * create one manually via {@link List<Resource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Resource>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourcesIncluded(List<Resource>)}.
         * 
         * @param resourcesIncluded
         *        a consumer that will call methods on {@link List<Resource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourcesIncluded(List<Resource>)
         */
        Builder resourcesIncluded(Consumer<Resource.Builder>... resourcesIncluded);

        /**
         * <p>
         * The names and values used by the evidence event, including an attribute name (such as
         * <code>allowUsersToChangePassword</code>) and value (such as <code>true</code> or <code>false</code>).
         * </p>
         * 
         * @param attributes
         *        The names and values used by the evidence event, including an attribute name (such as
         *        <code>allowUsersToChangePassword</code>) and value (such as <code>true</code> or <code>false</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * The unique identifier for the IAM user or role associated with the evidence.
         * </p>
         * 
         * @param iamId
         *        The unique identifier for the IAM user or role associated with the evidence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamId(String iamId);

        /**
         * <p>
         * The evaluation status for evidence that falls under the compliance check category. For evidence collected
         * from AWS Security Hub, a <i>Pass</i> or <i>Fail</i> result is shown. For evidence collected from AWS Config,
         * a <i>Compliant</i> or <i>Noncompliant</i> result is shown.
         * </p>
         * 
         * @param complianceCheck
         *        The evaluation status for evidence that falls under the compliance check category. For evidence
         *        collected from AWS Security Hub, a <i>Pass</i> or <i>Fail</i> result is shown. For evidence collected
         *        from AWS Config, a <i>Compliant</i> or <i>Noncompliant</i> result is shown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceCheck(String complianceCheck);

        /**
         * <p>
         * The AWS account from which the evidence is collected, and its AWS organization path.
         * </p>
         * 
         * @param awsOrganization
         *        The AWS account from which the evidence is collected, and its AWS organization path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsOrganization(String awsOrganization);

        /**
         * <p>
         * The identifier for the specified AWS account.
         * </p>
         * 
         * @param awsAccountId
         *        The identifier for the specified AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The identifier for the folder in which the evidence is stored.
         * </p>
         * 
         * @param evidenceFolderId
         *        The identifier for the folder in which the evidence is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceFolderId(String evidenceFolderId);

        /**
         * <p>
         * The identifier for the evidence.
         * </p>
         * 
         * @param id
         *        The identifier for the evidence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Specifies whether the evidence is inclded in the assessment report.
         * </p>
         * 
         * @param assessmentReportSelection
         *        Specifies whether the evidence is inclded in the assessment report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentReportSelection(String assessmentReportSelection);
    }

    static final class BuilderImpl implements Builder {
        private String dataSource;

        private String evidenceAwsAccountId;

        private Instant time;

        private String eventSource;

        private String eventName;

        private String evidenceByType;

        private List<Resource> resourcesIncluded = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private String iamId;

        private String complianceCheck;

        private String awsOrganization;

        private String awsAccountId;

        private String evidenceFolderId;

        private String id;

        private String assessmentReportSelection;

        private BuilderImpl() {
        }

        private BuilderImpl(Evidence model) {
            dataSource(model.dataSource);
            evidenceAwsAccountId(model.evidenceAwsAccountId);
            time(model.time);
            eventSource(model.eventSource);
            eventName(model.eventName);
            evidenceByType(model.evidenceByType);
            resourcesIncluded(model.resourcesIncluded);
            attributes(model.attributes);
            iamId(model.iamId);
            complianceCheck(model.complianceCheck);
            awsOrganization(model.awsOrganization);
            awsAccountId(model.awsAccountId);
            evidenceFolderId(model.evidenceFolderId);
            id(model.id);
            assessmentReportSelection(model.assessmentReportSelection);
        }

        public final String getDataSource() {
            return dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        public final String getEvidenceAwsAccountId() {
            return evidenceAwsAccountId;
        }

        @Override
        public final Builder evidenceAwsAccountId(String evidenceAwsAccountId) {
            this.evidenceAwsAccountId = evidenceAwsAccountId;
            return this;
        }

        public final void setEvidenceAwsAccountId(String evidenceAwsAccountId) {
            this.evidenceAwsAccountId = evidenceAwsAccountId;
        }

        public final Instant getTime() {
            return time;
        }

        @Override
        public final Builder time(Instant time) {
            this.time = time;
            return this;
        }

        public final void setTime(Instant time) {
            this.time = time;
        }

        public final String getEventSource() {
            return eventSource;
        }

        @Override
        public final Builder eventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        public final void setEventSource(String eventSource) {
            this.eventSource = eventSource;
        }

        public final String getEventName() {
            return eventName;
        }

        @Override
        public final Builder eventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        public final void setEventName(String eventName) {
            this.eventName = eventName;
        }

        public final String getEvidenceByType() {
            return evidenceByType;
        }

        @Override
        public final Builder evidenceByType(String evidenceByType) {
            this.evidenceByType = evidenceByType;
            return this;
        }

        public final void setEvidenceByType(String evidenceByType) {
            this.evidenceByType = evidenceByType;
        }

        public final Collection<Resource.Builder> getResourcesIncluded() {
            if (resourcesIncluded instanceof SdkAutoConstructList) {
                return null;
            }
            return resourcesIncluded != null ? resourcesIncluded.stream().map(Resource::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder resourcesIncluded(Collection<Resource> resourcesIncluded) {
            this.resourcesIncluded = ResourcesCopier.copy(resourcesIncluded);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcesIncluded(Resource... resourcesIncluded) {
            resourcesIncluded(Arrays.asList(resourcesIncluded));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcesIncluded(Consumer<Resource.Builder>... resourcesIncluded) {
            resourcesIncluded(Stream.of(resourcesIncluded).map(c -> Resource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResourcesIncluded(Collection<Resource.BuilderImpl> resourcesIncluded) {
            this.resourcesIncluded = ResourcesCopier.copyFromBuilder(resourcesIncluded);
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = EvidenceAttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = EvidenceAttributesCopier.copy(attributes);
        }

        public final String getIamId() {
            return iamId;
        }

        @Override
        public final Builder iamId(String iamId) {
            this.iamId = iamId;
            return this;
        }

        public final void setIamId(String iamId) {
            this.iamId = iamId;
        }

        public final String getComplianceCheck() {
            return complianceCheck;
        }

        @Override
        public final Builder complianceCheck(String complianceCheck) {
            this.complianceCheck = complianceCheck;
            return this;
        }

        public final void setComplianceCheck(String complianceCheck) {
            this.complianceCheck = complianceCheck;
        }

        public final String getAwsOrganization() {
            return awsOrganization;
        }

        @Override
        public final Builder awsOrganization(String awsOrganization) {
            this.awsOrganization = awsOrganization;
            return this;
        }

        public final void setAwsOrganization(String awsOrganization) {
            this.awsOrganization = awsOrganization;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getEvidenceFolderId() {
            return evidenceFolderId;
        }

        @Override
        public final Builder evidenceFolderId(String evidenceFolderId) {
            this.evidenceFolderId = evidenceFolderId;
            return this;
        }

        public final void setEvidenceFolderId(String evidenceFolderId) {
            this.evidenceFolderId = evidenceFolderId;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getAssessmentReportSelection() {
            return assessmentReportSelection;
        }

        @Override
        public final Builder assessmentReportSelection(String assessmentReportSelection) {
            this.assessmentReportSelection = assessmentReportSelection;
            return this;
        }

        public final void setAssessmentReportSelection(String assessmentReportSelection) {
            this.assessmentReportSelection = assessmentReportSelection;
        }

        @Override
        public Evidence build() {
            return new Evidence(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
