/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The assignment of a control set to a delegate for review.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Delegation implements SdkPojo, Serializable, ToCopyableBuilder<Delegation.Builder, Delegation> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Delegation::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ASSESSMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentName").getter(getter(Delegation::assessmentName)).setter(setter(Builder::assessmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentName").build()).build();

    private static final SdkField<String> ASSESSMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentId").getter(getter(Delegation::assessmentId)).setter(setter(Builder::assessmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Delegation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(Delegation::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> ROLE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleType").getter(getter(Delegation::roleTypeAsString)).setter(setter(Builder::roleType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleType").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(Delegation::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdated").getter(getter(Delegation::lastUpdated)).setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdated").build()).build();

    private static final SdkField<String> CONTROL_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlSetId").getter(getter(Delegation::controlSetId)).setter(setter(Builder::controlSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlSetId").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("comment")
            .getter(getter(Delegation::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(Delegation::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            ASSESSMENT_NAME_FIELD, ASSESSMENT_ID_FIELD, STATUS_FIELD, ROLE_ARN_FIELD, ROLE_TYPE_FIELD, CREATION_TIME_FIELD,
            LAST_UPDATED_FIELD, CONTROL_SET_ID_FIELD, COMMENT_FIELD, CREATED_BY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String assessmentName;

    private final String assessmentId;

    private final String status;

    private final String roleArn;

    private final String roleType;

    private final Instant creationTime;

    private final Instant lastUpdated;

    private final String controlSetId;

    private final String comment;

    private final String createdBy;

    private Delegation(BuilderImpl builder) {
        this.id = builder.id;
        this.assessmentName = builder.assessmentName;
        this.assessmentId = builder.assessmentId;
        this.status = builder.status;
        this.roleArn = builder.roleArn;
        this.roleType = builder.roleType;
        this.creationTime = builder.creationTime;
        this.lastUpdated = builder.lastUpdated;
        this.controlSetId = builder.controlSetId;
        this.comment = builder.comment;
        this.createdBy = builder.createdBy;
    }

    /**
     * <p>
     * The unique identifier for the delegation.
     * </p>
     * 
     * @return The unique identifier for the delegation.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the associated assessment.
     * </p>
     * 
     * @return The name of the associated assessment.
     */
    public final String assessmentName() {
        return assessmentName;
    }

    /**
     * <p>
     * The identifier for the associated assessment.
     * </p>
     * 
     * @return The identifier for the associated assessment.
     */
    public final String assessmentId() {
        return assessmentId;
    }

    /**
     * <p>
     * The status of the delegation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DelegationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the delegation.
     * @see DelegationStatus
     */
    public final DelegationStatus status() {
        return DelegationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the delegation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DelegationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the delegation.
     * @see DelegationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The type of customer persona.
     * </p>
     * <note>
     * <p>
     * In <code>CreateAssessment</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
     * </p>
     * <p>
     * In <code>UpdateSettings</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
     * </p>
     * <p>
     * In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be <code>RESOURCE_OWNER</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #roleType} will
     * return {@link RoleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleTypeAsString}.
     * </p>
     * 
     * @return The type of customer persona. </p> <note>
     *         <p>
     *         In <code>CreateAssessment</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
     *         </p>
     *         <p>
     *         In <code>UpdateSettings</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
     *         </p>
     *         <p>
     *         In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be
     *         <code>RESOURCE_OWNER</code>.
     *         </p>
     * @see RoleType
     */
    public final RoleType roleType() {
        return RoleType.fromValue(roleType);
    }

    /**
     * <p>
     * The type of customer persona.
     * </p>
     * <note>
     * <p>
     * In <code>CreateAssessment</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
     * </p>
     * <p>
     * In <code>UpdateSettings</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
     * </p>
     * <p>
     * In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be <code>RESOURCE_OWNER</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #roleType} will
     * return {@link RoleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleTypeAsString}.
     * </p>
     * 
     * @return The type of customer persona. </p> <note>
     *         <p>
     *         In <code>CreateAssessment</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
     *         </p>
     *         <p>
     *         In <code>UpdateSettings</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
     *         </p>
     *         <p>
     *         In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be
     *         <code>RESOURCE_OWNER</code>.
     *         </p>
     * @see RoleType
     */
    public final String roleTypeAsString() {
        return roleType;
    }

    /**
     * <p>
     * Specifies when the delegation was created.
     * </p>
     * 
     * @return Specifies when the delegation was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Specifies when the delegation was last updated.
     * </p>
     * 
     * @return Specifies when the delegation was last updated.
     */
    public final Instant lastUpdated() {
        return lastUpdated;
    }

    /**
     * <p>
     * The identifier for the associated control set.
     * </p>
     * 
     * @return The identifier for the associated control set.
     */
    public final String controlSetId() {
        return controlSetId;
    }

    /**
     * <p>
     * The comment related to the delegation.
     * </p>
     * 
     * @return The comment related to the delegation.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * The IAM user or role that created the delegation.
     * </p>
     * 
     * @return The IAM user or role that created the delegation.
     */
    public final String createdBy() {
        return createdBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentName());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(controlSetId());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Delegation)) {
            return false;
        }
        Delegation other = (Delegation) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(assessmentName(), other.assessmentName())
                && Objects.equals(assessmentId(), other.assessmentId())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(roleTypeAsString(), other.roleTypeAsString())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(lastUpdated(), other.lastUpdated())
                && Objects.equals(controlSetId(), other.controlSetId()) && Objects.equals(comment(), other.comment())
                && Objects.equals(createdBy(), other.createdBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Delegation").add("Id", id()).add("AssessmentName", assessmentName())
                .add("AssessmentId", assessmentId()).add("Status", statusAsString()).add("RoleArn", roleArn())
                .add("RoleType", roleTypeAsString()).add("CreationTime", creationTime()).add("LastUpdated", lastUpdated())
                .add("ControlSetId", controlSetId()).add("Comment", comment()).add("CreatedBy", createdBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "assessmentName":
            return Optional.ofNullable(clazz.cast(assessmentName()));
        case "assessmentId":
            return Optional.ofNullable(clazz.cast(assessmentId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "roleType":
            return Optional.ofNullable(clazz.cast(roleTypeAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        case "controlSetId":
            return Optional.ofNullable(clazz.cast(controlSetId()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Delegation, T> g) {
        return obj -> g.apply((Delegation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Delegation> {
        /**
         * <p>
         * The unique identifier for the delegation.
         * </p>
         * 
         * @param id
         *        The unique identifier for the delegation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the associated assessment.
         * </p>
         * 
         * @param assessmentName
         *        The name of the associated assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentName(String assessmentName);

        /**
         * <p>
         * The identifier for the associated assessment.
         * </p>
         * 
         * @param assessmentId
         *        The identifier for the associated assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentId(String assessmentId);

        /**
         * <p>
         * The status of the delegation.
         * </p>
         * 
         * @param status
         *        The status of the delegation.
         * @see DelegationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DelegationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the delegation.
         * </p>
         * 
         * @param status
         *        The status of the delegation.
         * @see DelegationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DelegationStatus
         */
        Builder status(DelegationStatus status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The type of customer persona.
         * </p>
         * <note>
         * <p>
         * In <code>CreateAssessment</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
         * </p>
         * <p>
         * In <code>UpdateSettings</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
         * </p>
         * <p>
         * In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be
         * <code>RESOURCE_OWNER</code>.
         * </p>
         * </note>
         * 
         * @param roleType
         *        The type of customer persona. </p> <note>
         *        <p>
         *        In <code>CreateAssessment</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
         *        </p>
         *        <p>
         *        In <code>UpdateSettings</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
         *        </p>
         *        <p>
         *        In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be
         *        <code>RESOURCE_OWNER</code>.
         *        </p>
         * @see RoleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoleType
         */
        Builder roleType(String roleType);

        /**
         * <p>
         * The type of customer persona.
         * </p>
         * <note>
         * <p>
         * In <code>CreateAssessment</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
         * </p>
         * <p>
         * In <code>UpdateSettings</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
         * </p>
         * <p>
         * In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be
         * <code>RESOURCE_OWNER</code>.
         * </p>
         * </note>
         * 
         * @param roleType
         *        The type of customer persona. </p> <note>
         *        <p>
         *        In <code>CreateAssessment</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
         *        </p>
         *        <p>
         *        In <code>UpdateSettings</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
         *        </p>
         *        <p>
         *        In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be
         *        <code>RESOURCE_OWNER</code>.
         *        </p>
         * @see RoleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoleType
         */
        Builder roleType(RoleType roleType);

        /**
         * <p>
         * Specifies when the delegation was created.
         * </p>
         * 
         * @param creationTime
         *        Specifies when the delegation was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Specifies when the delegation was last updated.
         * </p>
         * 
         * @param lastUpdated
         *        Specifies when the delegation was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);

        /**
         * <p>
         * The identifier for the associated control set.
         * </p>
         * 
         * @param controlSetId
         *        The identifier for the associated control set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlSetId(String controlSetId);

        /**
         * <p>
         * The comment related to the delegation.
         * </p>
         * 
         * @param comment
         *        The comment related to the delegation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The IAM user or role that created the delegation.
         * </p>
         * 
         * @param createdBy
         *        The IAM user or role that created the delegation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String assessmentName;

        private String assessmentId;

        private String status;

        private String roleArn;

        private String roleType;

        private Instant creationTime;

        private Instant lastUpdated;

        private String controlSetId;

        private String comment;

        private String createdBy;

        private BuilderImpl() {
        }

        private BuilderImpl(Delegation model) {
            id(model.id);
            assessmentName(model.assessmentName);
            assessmentId(model.assessmentId);
            status(model.status);
            roleArn(model.roleArn);
            roleType(model.roleType);
            creationTime(model.creationTime);
            lastUpdated(model.lastUpdated);
            controlSetId(model.controlSetId);
            comment(model.comment);
            createdBy(model.createdBy);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getAssessmentName() {
            return assessmentName;
        }

        @Override
        public final Builder assessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
            return this;
        }

        public final void setAssessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
        }

        public final String getAssessmentId() {
            return assessmentId;
        }

        @Override
        public final Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            return this;
        }

        public final void setAssessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DelegationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getRoleType() {
            return roleType;
        }

        @Override
        public final Builder roleType(String roleType) {
            this.roleType = roleType;
            return this;
        }

        @Override
        public final Builder roleType(RoleType roleType) {
            this.roleType(roleType == null ? null : roleType.toString());
            return this;
        }

        public final void setRoleType(String roleType) {
            this.roleType = roleType;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        public final String getControlSetId() {
            return controlSetId;
        }

        @Override
        public final Builder controlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
            return this;
        }

        public final void setControlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public Delegation build() {
            return new Delegation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
