/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Control mapping fields that represent the source for evidence collection, along with related parameters and metadata.
 * This does not contain <code>mappingID</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateControlMappingSource implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateControlMappingSource.Builder, CreateControlMappingSource> {
    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceName").getter(getter(CreateControlMappingSource::sourceName)).setter(setter(Builder::sourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceName").build()).build();

    private static final SdkField<String> SOURCE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceDescription").getter(getter(CreateControlMappingSource::sourceDescription))
            .setter(setter(Builder::sourceDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceDescription").build()).build();

    private static final SdkField<String> SOURCE_SET_UP_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceSetUpOption").getter(getter(CreateControlMappingSource::sourceSetUpOptionAsString))
            .setter(setter(Builder::sourceSetUpOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceSetUpOption").build()).build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceType").getter(getter(CreateControlMappingSource::sourceTypeAsString))
            .setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceType").build()).build();

    private static final SdkField<SourceKeyword> SOURCE_KEYWORD_FIELD = SdkField
            .<SourceKeyword> builder(MarshallingType.SDK_POJO).memberName("sourceKeyword")
            .getter(getter(CreateControlMappingSource::sourceKeyword)).setter(setter(Builder::sourceKeyword))
            .constructor(SourceKeyword::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceKeyword").build()).build();

    private static final SdkField<String> SOURCE_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceFrequency").getter(getter(CreateControlMappingSource::sourceFrequencyAsString))
            .setter(setter(Builder::sourceFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFrequency").build()).build();

    private static final SdkField<String> TROUBLESHOOTING_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("troubleshootingText").getter(getter(CreateControlMappingSource::troubleshootingText))
            .setter(setter(Builder::troubleshootingText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("troubleshootingText").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_NAME_FIELD,
            SOURCE_DESCRIPTION_FIELD, SOURCE_SET_UP_OPTION_FIELD, SOURCE_TYPE_FIELD, SOURCE_KEYWORD_FIELD,
            SOURCE_FREQUENCY_FIELD, TROUBLESHOOTING_TEXT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceName;

    private final String sourceDescription;

    private final String sourceSetUpOption;

    private final String sourceType;

    private final SourceKeyword sourceKeyword;

    private final String sourceFrequency;

    private final String troubleshootingText;

    private CreateControlMappingSource(BuilderImpl builder) {
        this.sourceName = builder.sourceName;
        this.sourceDescription = builder.sourceDescription;
        this.sourceSetUpOption = builder.sourceSetUpOption;
        this.sourceType = builder.sourceType;
        this.sourceKeyword = builder.sourceKeyword;
        this.sourceFrequency = builder.sourceFrequency;
        this.troubleshootingText = builder.troubleshootingText;
    }

    /**
     * <p>
     * The name of the control mapping data source.
     * </p>
     * 
     * @return The name of the control mapping data source.
     */
    public final String sourceName() {
        return sourceName;
    }

    /**
     * <p>
     * The description of the data source that determines from where AWS Audit Manager collects evidence for the
     * control.
     * </p>
     * 
     * @return The description of the data source that determines from where AWS Audit Manager collects evidence for the
     *         control.
     */
    public final String sourceDescription() {
        return sourceDescription;
    }

    /**
     * <p>
     * The setup option for the data source, which reflects if the evidence collection is automated or manual.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceSetUpOption}
     * will return {@link SourceSetUpOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceSetUpOptionAsString}.
     * </p>
     * 
     * @return The setup option for the data source, which reflects if the evidence collection is automated or manual.
     * @see SourceSetUpOption
     */
    public final SourceSetUpOption sourceSetUpOption() {
        return SourceSetUpOption.fromValue(sourceSetUpOption);
    }

    /**
     * <p>
     * The setup option for the data source, which reflects if the evidence collection is automated or manual.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceSetUpOption}
     * will return {@link SourceSetUpOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceSetUpOptionAsString}.
     * </p>
     * 
     * @return The setup option for the data source, which reflects if the evidence collection is automated or manual.
     * @see SourceSetUpOption
     */
    public final String sourceSetUpOptionAsString() {
        return sourceSetUpOption;
    }

    /**
     * <p>
     * Specifies one of the five types of data sources for evidence collection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return Specifies one of the five types of data sources for evidence collection.
     * @see SourceType
     */
    public final SourceType sourceType() {
        return SourceType.fromValue(sourceType);
    }

    /**
     * <p>
     * Specifies one of the five types of data sources for evidence collection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return Specifies one of the five types of data sources for evidence collection.
     * @see SourceType
     */
    public final String sourceTypeAsString() {
        return sourceType;
    }

    /**
     * Returns the value of the SourceKeyword property for this object.
     * 
     * @return The value of the SourceKeyword property for this object.
     */
    public final SourceKeyword sourceKeyword() {
        return sourceKeyword;
    }

    /**
     * <p>
     * The frequency of evidence collection for the specified control mapping source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceFrequency}
     * will return {@link SourceFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceFrequencyAsString}.
     * </p>
     * 
     * @return The frequency of evidence collection for the specified control mapping source.
     * @see SourceFrequency
     */
    public final SourceFrequency sourceFrequency() {
        return SourceFrequency.fromValue(sourceFrequency);
    }

    /**
     * <p>
     * The frequency of evidence collection for the specified control mapping source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceFrequency}
     * will return {@link SourceFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceFrequencyAsString}.
     * </p>
     * 
     * @return The frequency of evidence collection for the specified control mapping source.
     * @see SourceFrequency
     */
    public final String sourceFrequencyAsString() {
        return sourceFrequency;
    }

    /**
     * <p>
     * The instructions for troubleshooting the specified control.
     * </p>
     * 
     * @return The instructions for troubleshooting the specified control.
     */
    public final String troubleshootingText() {
        return troubleshootingText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDescription());
        hashCode = 31 * hashCode + Objects.hashCode(sourceSetUpOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceKeyword());
        hashCode = 31 * hashCode + Objects.hashCode(sourceFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(troubleshootingText());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateControlMappingSource)) {
            return false;
        }
        CreateControlMappingSource other = (CreateControlMappingSource) obj;
        return Objects.equals(sourceName(), other.sourceName()) && Objects.equals(sourceDescription(), other.sourceDescription())
                && Objects.equals(sourceSetUpOptionAsString(), other.sourceSetUpOptionAsString())
                && Objects.equals(sourceTypeAsString(), other.sourceTypeAsString())
                && Objects.equals(sourceKeyword(), other.sourceKeyword())
                && Objects.equals(sourceFrequencyAsString(), other.sourceFrequencyAsString())
                && Objects.equals(troubleshootingText(), other.troubleshootingText());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateControlMappingSource").add("SourceName", sourceName())
                .add("SourceDescription", sourceDescription()).add("SourceSetUpOption", sourceSetUpOptionAsString())
                .add("SourceType", sourceTypeAsString()).add("SourceKeyword", sourceKeyword())
                .add("SourceFrequency", sourceFrequencyAsString()).add("TroubleshootingText", troubleshootingText()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceName":
            return Optional.ofNullable(clazz.cast(sourceName()));
        case "sourceDescription":
            return Optional.ofNullable(clazz.cast(sourceDescription()));
        case "sourceSetUpOption":
            return Optional.ofNullable(clazz.cast(sourceSetUpOptionAsString()));
        case "sourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        case "sourceKeyword":
            return Optional.ofNullable(clazz.cast(sourceKeyword()));
        case "sourceFrequency":
            return Optional.ofNullable(clazz.cast(sourceFrequencyAsString()));
        case "troubleshootingText":
            return Optional.ofNullable(clazz.cast(troubleshootingText()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateControlMappingSource, T> g) {
        return obj -> g.apply((CreateControlMappingSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateControlMappingSource> {
        /**
         * <p>
         * The name of the control mapping data source.
         * </p>
         * 
         * @param sourceName
         *        The name of the control mapping data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceName(String sourceName);

        /**
         * <p>
         * The description of the data source that determines from where AWS Audit Manager collects evidence for the
         * control.
         * </p>
         * 
         * @param sourceDescription
         *        The description of the data source that determines from where AWS Audit Manager collects evidence for
         *        the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDescription(String sourceDescription);

        /**
         * <p>
         * The setup option for the data source, which reflects if the evidence collection is automated or manual.
         * </p>
         * 
         * @param sourceSetUpOption
         *        The setup option for the data source, which reflects if the evidence collection is automated or
         *        manual.
         * @see SourceSetUpOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceSetUpOption
         */
        Builder sourceSetUpOption(String sourceSetUpOption);

        /**
         * <p>
         * The setup option for the data source, which reflects if the evidence collection is automated or manual.
         * </p>
         * 
         * @param sourceSetUpOption
         *        The setup option for the data source, which reflects if the evidence collection is automated or
         *        manual.
         * @see SourceSetUpOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceSetUpOption
         */
        Builder sourceSetUpOption(SourceSetUpOption sourceSetUpOption);

        /**
         * <p>
         * Specifies one of the five types of data sources for evidence collection.
         * </p>
         * 
         * @param sourceType
         *        Specifies one of the five types of data sources for evidence collection.
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * Specifies one of the five types of data sources for evidence collection.
         * </p>
         * 
         * @param sourceType
         *        Specifies one of the five types of data sources for evidence collection.
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder sourceType(SourceType sourceType);

        /**
         * Sets the value of the SourceKeyword property for this object.
         *
         * @param sourceKeyword
         *        The new value for the SourceKeyword property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceKeyword(SourceKeyword sourceKeyword);

        /**
         * Sets the value of the SourceKeyword property for this object.
         *
         * This is a convenience that creates an instance of the {@link SourceKeyword.Builder} avoiding the need to
         * create one manually via {@link SourceKeyword#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceKeyword.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceKeyword(SourceKeyword)}.
         * 
         * @param sourceKeyword
         *        a consumer that will call methods on {@link SourceKeyword.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceKeyword(SourceKeyword)
         */
        default Builder sourceKeyword(Consumer<SourceKeyword.Builder> sourceKeyword) {
            return sourceKeyword(SourceKeyword.builder().applyMutation(sourceKeyword).build());
        }

        /**
         * <p>
         * The frequency of evidence collection for the specified control mapping source.
         * </p>
         * 
         * @param sourceFrequency
         *        The frequency of evidence collection for the specified control mapping source.
         * @see SourceFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceFrequency
         */
        Builder sourceFrequency(String sourceFrequency);

        /**
         * <p>
         * The frequency of evidence collection for the specified control mapping source.
         * </p>
         * 
         * @param sourceFrequency
         *        The frequency of evidence collection for the specified control mapping source.
         * @see SourceFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceFrequency
         */
        Builder sourceFrequency(SourceFrequency sourceFrequency);

        /**
         * <p>
         * The instructions for troubleshooting the specified control.
         * </p>
         * 
         * @param troubleshootingText
         *        The instructions for troubleshooting the specified control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder troubleshootingText(String troubleshootingText);
    }

    static final class BuilderImpl implements Builder {
        private String sourceName;

        private String sourceDescription;

        private String sourceSetUpOption;

        private String sourceType;

        private SourceKeyword sourceKeyword;

        private String sourceFrequency;

        private String troubleshootingText;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateControlMappingSource model) {
            sourceName(model.sourceName);
            sourceDescription(model.sourceDescription);
            sourceSetUpOption(model.sourceSetUpOption);
            sourceType(model.sourceType);
            sourceKeyword(model.sourceKeyword);
            sourceFrequency(model.sourceFrequency);
            troubleshootingText(model.troubleshootingText);
        }

        public final String getSourceName() {
            return sourceName;
        }

        @Override
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        public final String getSourceDescription() {
            return sourceDescription;
        }

        @Override
        public final Builder sourceDescription(String sourceDescription) {
            this.sourceDescription = sourceDescription;
            return this;
        }

        public final void setSourceDescription(String sourceDescription) {
            this.sourceDescription = sourceDescription;
        }

        public final String getSourceSetUpOption() {
            return sourceSetUpOption;
        }

        @Override
        public final Builder sourceSetUpOption(String sourceSetUpOption) {
            this.sourceSetUpOption = sourceSetUpOption;
            return this;
        }

        @Override
        public final Builder sourceSetUpOption(SourceSetUpOption sourceSetUpOption) {
            this.sourceSetUpOption(sourceSetUpOption == null ? null : sourceSetUpOption.toString());
            return this;
        }

        public final void setSourceSetUpOption(String sourceSetUpOption) {
            this.sourceSetUpOption = sourceSetUpOption;
        }

        public final String getSourceType() {
            return sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(SourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final SourceKeyword.Builder getSourceKeyword() {
            return sourceKeyword != null ? sourceKeyword.toBuilder() : null;
        }

        @Override
        public final Builder sourceKeyword(SourceKeyword sourceKeyword) {
            this.sourceKeyword = sourceKeyword;
            return this;
        }

        public final void setSourceKeyword(SourceKeyword.BuilderImpl sourceKeyword) {
            this.sourceKeyword = sourceKeyword != null ? sourceKeyword.build() : null;
        }

        public final String getSourceFrequency() {
            return sourceFrequency;
        }

        @Override
        public final Builder sourceFrequency(String sourceFrequency) {
            this.sourceFrequency = sourceFrequency;
            return this;
        }

        @Override
        public final Builder sourceFrequency(SourceFrequency sourceFrequency) {
            this.sourceFrequency(sourceFrequency == null ? null : sourceFrequency.toString());
            return this;
        }

        public final void setSourceFrequency(String sourceFrequency) {
            this.sourceFrequency = sourceFrequency;
        }

        public final String getTroubleshootingText() {
            return troubleshootingText;
        }

        @Override
        public final Builder troubleshootingText(String troubleshootingText) {
            this.troubleshootingText = troubleshootingText;
            return this;
        }

        public final void setTroubleshootingText(String troubleshootingText) {
            this.troubleshootingText = troubleshootingText;
        }

        @Override
        public CreateControlMappingSource build() {
            return new CreateControlMappingSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
