/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAssessmentReportResponse extends AuditManagerResponse implements
        ToCopyableBuilder<CreateAssessmentReportResponse.Builder, CreateAssessmentReportResponse> {
    private static final SdkField<AssessmentReport> ASSESSMENT_REPORT_FIELD = SdkField
            .<AssessmentReport> builder(MarshallingType.SDK_POJO).memberName("assessmentReport")
            .getter(getter(CreateAssessmentReportResponse::assessmentReport)).setter(setter(Builder::assessmentReport))
            .constructor(AssessmentReport::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentReport").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_REPORT_FIELD));

    private final AssessmentReport assessmentReport;

    private CreateAssessmentReportResponse(BuilderImpl builder) {
        super(builder);
        this.assessmentReport = builder.assessmentReport;
    }

    /**
     * <p>
     * The new assessment report returned by the <code>CreateAssessmentReport</code> API.
     * </p>
     * 
     * @return The new assessment report returned by the <code>CreateAssessmentReport</code> API.
     */
    public final AssessmentReport assessmentReport() {
        return assessmentReport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assessmentReport());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssessmentReportResponse)) {
            return false;
        }
        CreateAssessmentReportResponse other = (CreateAssessmentReportResponse) obj;
        return Objects.equals(assessmentReport(), other.assessmentReport());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAssessmentReportResponse").add("AssessmentReport", assessmentReport()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentReport":
            return Optional.ofNullable(clazz.cast(assessmentReport()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAssessmentReportResponse, T> g) {
        return obj -> g.apply((CreateAssessmentReportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAssessmentReportResponse> {
        /**
         * <p>
         * The new assessment report returned by the <code>CreateAssessmentReport</code> API.
         * </p>
         * 
         * @param assessmentReport
         *        The new assessment report returned by the <code>CreateAssessmentReport</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentReport(AssessmentReport assessmentReport);

        /**
         * <p>
         * The new assessment report returned by the <code>CreateAssessmentReport</code> API.
         * </p>
         * This is a convenience that creates an instance of the {@link AssessmentReport.Builder} avoiding the need to
         * create one manually via {@link AssessmentReport#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssessmentReport.Builder#build()} is called immediately and its
         * result is passed to {@link #assessmentReport(AssessmentReport)}.
         * 
         * @param assessmentReport
         *        a consumer that will call methods on {@link AssessmentReport.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assessmentReport(AssessmentReport)
         */
        default Builder assessmentReport(Consumer<AssessmentReport.Builder> assessmentReport) {
            return assessmentReport(AssessmentReport.builder().applyMutation(assessmentReport).build());
        }
    }

    static final class BuilderImpl extends AuditManagerResponse.BuilderImpl implements Builder {
        private AssessmentReport assessmentReport;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssessmentReportResponse model) {
            super(model);
            assessmentReport(model.assessmentReport);
        }

        public final AssessmentReport.Builder getAssessmentReport() {
            return assessmentReport != null ? assessmentReport.toBuilder() : null;
        }

        @Override
        public final Builder assessmentReport(AssessmentReport assessmentReport) {
            this.assessmentReport = assessmentReport;
            return this;
        }

        public final void setAssessmentReport(AssessmentReport.BuilderImpl assessmentReport) {
            this.assessmentReport = assessmentReport != null ? assessmentReport.build() : null;
        }

        @Override
        public CreateAssessmentReportResponse build() {
            return new CreateAssessmentReportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
