/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The file used to structure and automate AWS Audit Manager assessments for a given compliance standard.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssessmentFramework implements SdkPojo, Serializable,
        ToCopyableBuilder<AssessmentFramework.Builder, AssessmentFramework> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AssessmentFramework::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(AssessmentFramework::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<FrameworkMetadata> METADATA_FIELD = SdkField
            .<FrameworkMetadata> builder(MarshallingType.SDK_POJO).memberName("metadata")
            .getter(getter(AssessmentFramework::metadata)).setter(setter(Builder::metadata))
            .constructor(FrameworkMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final SdkField<List<AssessmentControlSet>> CONTROL_SETS_FIELD = SdkField
            .<List<AssessmentControlSet>> builder(MarshallingType.LIST)
            .memberName("controlSets")
            .getter(getter(AssessmentFramework::controlSets))
            .setter(setter(Builder::controlSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssessmentControlSet> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssessmentControlSet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            METADATA_FIELD, CONTROL_SETS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final FrameworkMetadata metadata;

    private final List<AssessmentControlSet> controlSets;

    private AssessmentFramework(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.metadata = builder.metadata;
        this.controlSets = builder.controlSets;
    }

    /**
     * <p>
     * The unique identifier for the framework.
     * </p>
     * 
     * @return The unique identifier for the framework.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the specified framework.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the specified framework.
     */
    public final String arn() {
        return arn;
    }

    /**
     * Returns the value of the Metadata property for this object.
     * 
     * @return The value of the Metadata property for this object.
     */
    public final FrameworkMetadata metadata() {
        return metadata;
    }

    /**
     * Returns true if the ControlSets property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasControlSets() {
        return controlSets != null && !(controlSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The control sets associated with the framework.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasControlSets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The control sets associated with the framework.
     */
    public final List<AssessmentControlSet> controlSets() {
        return controlSets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(hasControlSets() ? controlSets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentFramework)) {
            return false;
        }
        AssessmentFramework other = (AssessmentFramework) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(metadata(), other.metadata()) && hasControlSets() == other.hasControlSets()
                && Objects.equals(controlSets(), other.controlSets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssessmentFramework").add("Id", id()).add("Arn", arn()).add("Metadata", metadata())
                .add("ControlSets", hasControlSets() ? controlSets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "controlSets":
            return Optional.ofNullable(clazz.cast(controlSets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentFramework, T> g) {
        return obj -> g.apply((AssessmentFramework) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssessmentFramework> {
        /**
         * <p>
         * The unique identifier for the framework.
         * </p>
         * 
         * @param id
         *        The unique identifier for the framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the specified framework.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the specified framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * Sets the value of the Metadata property for this object.
         *
         * @param metadata
         *        The new value for the Metadata property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(FrameworkMetadata metadata);

        /**
         * Sets the value of the Metadata property for this object.
         *
         * This is a convenience that creates an instance of the {@link FrameworkMetadata.Builder} avoiding the need to
         * create one manually via {@link FrameworkMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link FrameworkMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #metadata(FrameworkMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link FrameworkMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(FrameworkMetadata)
         */
        default Builder metadata(Consumer<FrameworkMetadata.Builder> metadata) {
            return metadata(FrameworkMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * The control sets associated with the framework.
         * </p>
         * 
         * @param controlSets
         *        The control sets associated with the framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlSets(Collection<AssessmentControlSet> controlSets);

        /**
         * <p>
         * The control sets associated with the framework.
         * </p>
         * 
         * @param controlSets
         *        The control sets associated with the framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlSets(AssessmentControlSet... controlSets);

        /**
         * <p>
         * The control sets associated with the framework.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AssessmentControlSet>.Builder} avoiding the
         * need to create one manually via {@link List<AssessmentControlSet>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssessmentControlSet>.Builder#build()} is called immediately
         * and its result is passed to {@link #controlSets(List<AssessmentControlSet>)}.
         * 
         * @param controlSets
         *        a consumer that will call methods on {@link List<AssessmentControlSet>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #controlSets(List<AssessmentControlSet>)
         */
        Builder controlSets(Consumer<AssessmentControlSet.Builder>... controlSets);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private FrameworkMetadata metadata;

        private List<AssessmentControlSet> controlSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentFramework model) {
            id(model.id);
            arn(model.arn);
            metadata(model.metadata);
            controlSets(model.controlSets);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final FrameworkMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        @Override
        public final Builder metadata(FrameworkMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(FrameworkMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        public final Collection<AssessmentControlSet.Builder> getControlSets() {
            if (controlSets instanceof SdkAutoConstructList) {
                return null;
            }
            return controlSets != null ? controlSets.stream().map(AssessmentControlSet::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder controlSets(Collection<AssessmentControlSet> controlSets) {
            this.controlSets = AssessmentControlSetsCopier.copy(controlSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlSets(AssessmentControlSet... controlSets) {
            controlSets(Arrays.asList(controlSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlSets(Consumer<AssessmentControlSet.Builder>... controlSets) {
            controlSets(Stream.of(controlSets).map(c -> AssessmentControlSet.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setControlSets(Collection<AssessmentControlSet.BuilderImpl> controlSets) {
            this.controlSets = AssessmentControlSetsCopier.copyFromBuilder(controlSets);
        }

        @Override
        public AssessmentFramework build() {
            return new AssessmentFramework(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
