/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The folder in which AWS Audit Manager stores evidence for an assessment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssessmentEvidenceFolder implements SdkPojo, Serializable,
        ToCopyableBuilder<AssessmentEvidenceFolder.Builder, AssessmentEvidenceFolder> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AssessmentEvidenceFolder::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Instant> DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("date")
            .getter(getter(AssessmentEvidenceFolder::date)).setter(setter(Builder::date))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("date").build()).build();

    private static final SdkField<String> ASSESSMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentId").getter(getter(AssessmentEvidenceFolder::assessmentId))
            .setter(setter(Builder::assessmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentId").build()).build();

    private static final SdkField<String> CONTROL_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlSetId").getter(getter(AssessmentEvidenceFolder::controlSetId))
            .setter(setter(Builder::controlSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlSetId").build()).build();

    private static final SdkField<String> CONTROL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlId").getter(getter(AssessmentEvidenceFolder::controlId)).setter(setter(Builder::controlId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AssessmentEvidenceFolder::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSource").getter(getter(AssessmentEvidenceFolder::dataSource)).setter(setter(Builder::dataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()).build();

    private static final SdkField<String> AUTHOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("author")
            .getter(getter(AssessmentEvidenceFolder::author)).setter(setter(Builder::author))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("author").build()).build();

    private static final SdkField<Integer> TOTAL_EVIDENCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalEvidence").getter(getter(AssessmentEvidenceFolder::totalEvidence))
            .setter(setter(Builder::totalEvidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalEvidence").build()).build();

    private static final SdkField<Integer> ASSESSMENT_REPORT_SELECTION_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("assessmentReportSelectionCount")
            .getter(getter(AssessmentEvidenceFolder::assessmentReportSelectionCount))
            .setter(setter(Builder::assessmentReportSelectionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentReportSelectionCount")
                    .build()).build();

    private static final SdkField<String> CONTROL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlName").getter(getter(AssessmentEvidenceFolder::controlName)).setter(setter(Builder::controlName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlName").build()).build();

    private static final SdkField<Integer> EVIDENCE_RESOURCES_INCLUDED_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("evidenceResourcesIncludedCount")
            .getter(getter(AssessmentEvidenceFolder::evidenceResourcesIncludedCount))
            .setter(setter(Builder::evidenceResourcesIncludedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceResourcesIncludedCount")
                    .build()).build();

    private static final SdkField<Integer> EVIDENCE_BY_TYPE_CONFIGURATION_DATA_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("evidenceByTypeConfigurationDataCount")
            .getter(getter(AssessmentEvidenceFolder::evidenceByTypeConfigurationDataCount))
            .setter(setter(Builder::evidenceByTypeConfigurationDataCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("evidenceByTypeConfigurationDataCount").build()).build();

    private static final SdkField<Integer> EVIDENCE_BY_TYPE_MANUAL_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("evidenceByTypeManualCount")
            .getter(getter(AssessmentEvidenceFolder::evidenceByTypeManualCount))
            .setter(setter(Builder::evidenceByTypeManualCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceByTypeManualCount").build())
            .build();

    private static final SdkField<Integer> EVIDENCE_BY_TYPE_COMPLIANCE_CHECK_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("evidenceByTypeComplianceCheckCount")
            .getter(getter(AssessmentEvidenceFolder::evidenceByTypeComplianceCheckCount))
            .setter(setter(Builder::evidenceByTypeComplianceCheckCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceByTypeComplianceCheckCount")
                    .build()).build();

    private static final SdkField<Integer> EVIDENCE_BY_TYPE_COMPLIANCE_CHECK_ISSUES_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("evidenceByTypeComplianceCheckIssuesCount")
            .getter(getter(AssessmentEvidenceFolder::evidenceByTypeComplianceCheckIssuesCount))
            .setter(setter(Builder::evidenceByTypeComplianceCheckIssuesCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("evidenceByTypeComplianceCheckIssuesCount").build()).build();

    private static final SdkField<Integer> EVIDENCE_BY_TYPE_USER_ACTIVITY_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("evidenceByTypeUserActivityCount")
            .getter(getter(AssessmentEvidenceFolder::evidenceByTypeUserActivityCount))
            .setter(setter(Builder::evidenceByTypeUserActivityCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceByTypeUserActivityCount")
                    .build()).build();

    private static final SdkField<Integer> EVIDENCE_AWS_SERVICE_SOURCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("evidenceAwsServiceSourceCount")
            .getter(getter(AssessmentEvidenceFolder::evidenceAwsServiceSourceCount))
            .setter(setter(Builder::evidenceAwsServiceSourceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceAwsServiceSourceCount")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DATE_FIELD,
            ASSESSMENT_ID_FIELD, CONTROL_SET_ID_FIELD, CONTROL_ID_FIELD, ID_FIELD, DATA_SOURCE_FIELD, AUTHOR_FIELD,
            TOTAL_EVIDENCE_FIELD, ASSESSMENT_REPORT_SELECTION_COUNT_FIELD, CONTROL_NAME_FIELD,
            EVIDENCE_RESOURCES_INCLUDED_COUNT_FIELD, EVIDENCE_BY_TYPE_CONFIGURATION_DATA_COUNT_FIELD,
            EVIDENCE_BY_TYPE_MANUAL_COUNT_FIELD, EVIDENCE_BY_TYPE_COMPLIANCE_CHECK_COUNT_FIELD,
            EVIDENCE_BY_TYPE_COMPLIANCE_CHECK_ISSUES_COUNT_FIELD, EVIDENCE_BY_TYPE_USER_ACTIVITY_COUNT_FIELD,
            EVIDENCE_AWS_SERVICE_SOURCE_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Instant date;

    private final String assessmentId;

    private final String controlSetId;

    private final String controlId;

    private final String id;

    private final String dataSource;

    private final String author;

    private final Integer totalEvidence;

    private final Integer assessmentReportSelectionCount;

    private final String controlName;

    private final Integer evidenceResourcesIncludedCount;

    private final Integer evidenceByTypeConfigurationDataCount;

    private final Integer evidenceByTypeManualCount;

    private final Integer evidenceByTypeComplianceCheckCount;

    private final Integer evidenceByTypeComplianceCheckIssuesCount;

    private final Integer evidenceByTypeUserActivityCount;

    private final Integer evidenceAwsServiceSourceCount;

    private AssessmentEvidenceFolder(BuilderImpl builder) {
        this.name = builder.name;
        this.date = builder.date;
        this.assessmentId = builder.assessmentId;
        this.controlSetId = builder.controlSetId;
        this.controlId = builder.controlId;
        this.id = builder.id;
        this.dataSource = builder.dataSource;
        this.author = builder.author;
        this.totalEvidence = builder.totalEvidence;
        this.assessmentReportSelectionCount = builder.assessmentReportSelectionCount;
        this.controlName = builder.controlName;
        this.evidenceResourcesIncludedCount = builder.evidenceResourcesIncludedCount;
        this.evidenceByTypeConfigurationDataCount = builder.evidenceByTypeConfigurationDataCount;
        this.evidenceByTypeManualCount = builder.evidenceByTypeManualCount;
        this.evidenceByTypeComplianceCheckCount = builder.evidenceByTypeComplianceCheckCount;
        this.evidenceByTypeComplianceCheckIssuesCount = builder.evidenceByTypeComplianceCheckIssuesCount;
        this.evidenceByTypeUserActivityCount = builder.evidenceByTypeUserActivityCount;
        this.evidenceAwsServiceSourceCount = builder.evidenceAwsServiceSourceCount;
    }

    /**
     * <p>
     * The name of the specified evidence folder.
     * </p>
     * 
     * @return The name of the specified evidence folder.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The date when the first evidence was added to the evidence folder.
     * </p>
     * 
     * @return The date when the first evidence was added to the evidence folder.
     */
    public final Instant date() {
        return date;
    }

    /**
     * <p>
     * The identifier for the specified assessment.
     * </p>
     * 
     * @return The identifier for the specified assessment.
     */
    public final String assessmentId() {
        return assessmentId;
    }

    /**
     * <p>
     * The identifier for the control set.
     * </p>
     * 
     * @return The identifier for the control set.
     */
    public final String controlSetId() {
        return controlSetId;
    }

    /**
     * <p>
     * The unique identifier for the specified control.
     * </p>
     * 
     * @return The unique identifier for the specified control.
     */
    public final String controlId() {
        return controlId;
    }

    /**
     * <p>
     * The identifier for the folder in which evidence is stored.
     * </p>
     * 
     * @return The identifier for the folder in which evidence is stored.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The AWS service from which the evidence was collected.
     * </p>
     * 
     * @return The AWS service from which the evidence was collected.
     */
    public final String dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * The name of the user who created the evidence folder.
     * </p>
     * 
     * @return The name of the user who created the evidence folder.
     */
    public final String author() {
        return author;
    }

    /**
     * <p>
     * The total amount of evidence in the evidence folder.
     * </p>
     * 
     * @return The total amount of evidence in the evidence folder.
     */
    public final Integer totalEvidence() {
        return totalEvidence;
    }

    /**
     * <p>
     * The total count of evidence included in the assessment report.
     * </p>
     * 
     * @return The total count of evidence included in the assessment report.
     */
    public final Integer assessmentReportSelectionCount() {
        return assessmentReportSelectionCount;
    }

    /**
     * <p>
     * The name of the control.
     * </p>
     * 
     * @return The name of the control.
     */
    public final String controlName() {
        return controlName;
    }

    /**
     * <p>
     * The amount of evidence included in the evidence folder.
     * </p>
     * 
     * @return The amount of evidence included in the evidence folder.
     */
    public final Integer evidenceResourcesIncludedCount() {
        return evidenceResourcesIncludedCount;
    }

    /**
     * <p>
     * The number of evidence that falls under the configuration data category. This evidence is collected from
     * configuration snapshots of other AWS services such as Amazon EC2, Amazon S3, or IAM.
     * </p>
     * 
     * @return The number of evidence that falls under the configuration data category. This evidence is collected from
     *         configuration snapshots of other AWS services such as Amazon EC2, Amazon S3, or IAM.
     */
    public final Integer evidenceByTypeConfigurationDataCount() {
        return evidenceByTypeConfigurationDataCount;
    }

    /**
     * <p>
     * The number of evidence that falls under the manual category. This evidence is imported manually.
     * </p>
     * 
     * @return The number of evidence that falls under the manual category. This evidence is imported manually.
     */
    public final Integer evidenceByTypeManualCount() {
        return evidenceByTypeManualCount;
    }

    /**
     * <p>
     * The number of evidence that falls under the compliance check category. This evidence is collected from AWS Config
     * or AWS Security Hub.
     * </p>
     * 
     * @return The number of evidence that falls under the compliance check category. This evidence is collected from
     *         AWS Config or AWS Security Hub.
     */
    public final Integer evidenceByTypeComplianceCheckCount() {
        return evidenceByTypeComplianceCheckCount;
    }

    /**
     * <p>
     * The total number of issues that were reported directly from AWS Security Hub, AWS Config, or both.
     * </p>
     * 
     * @return The total number of issues that were reported directly from AWS Security Hub, AWS Config, or both.
     */
    public final Integer evidenceByTypeComplianceCheckIssuesCount() {
        return evidenceByTypeComplianceCheckIssuesCount;
    }

    /**
     * <p>
     * The number of evidence that falls under the user activity category. This evidence is collected from AWS
     * CloudTrail logs.
     * </p>
     * 
     * @return The number of evidence that falls under the user activity category. This evidence is collected from AWS
     *         CloudTrail logs.
     */
    public final Integer evidenceByTypeUserActivityCount() {
        return evidenceByTypeUserActivityCount;
    }

    /**
     * <p>
     * The total number of AWS resources assessed to generate the evidence.
     * </p>
     * 
     * @return The total number of AWS resources assessed to generate the evidence.
     */
    public final Integer evidenceAwsServiceSourceCount() {
        return evidenceAwsServiceSourceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(date());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentId());
        hashCode = 31 * hashCode + Objects.hashCode(controlSetId());
        hashCode = 31 * hashCode + Objects.hashCode(controlId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(author());
        hashCode = 31 * hashCode + Objects.hashCode(totalEvidence());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentReportSelectionCount());
        hashCode = 31 * hashCode + Objects.hashCode(controlName());
        hashCode = 31 * hashCode + Objects.hashCode(evidenceResourcesIncludedCount());
        hashCode = 31 * hashCode + Objects.hashCode(evidenceByTypeConfigurationDataCount());
        hashCode = 31 * hashCode + Objects.hashCode(evidenceByTypeManualCount());
        hashCode = 31 * hashCode + Objects.hashCode(evidenceByTypeComplianceCheckCount());
        hashCode = 31 * hashCode + Objects.hashCode(evidenceByTypeComplianceCheckIssuesCount());
        hashCode = 31 * hashCode + Objects.hashCode(evidenceByTypeUserActivityCount());
        hashCode = 31 * hashCode + Objects.hashCode(evidenceAwsServiceSourceCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentEvidenceFolder)) {
            return false;
        }
        AssessmentEvidenceFolder other = (AssessmentEvidenceFolder) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(date(), other.date())
                && Objects.equals(assessmentId(), other.assessmentId()) && Objects.equals(controlSetId(), other.controlSetId())
                && Objects.equals(controlId(), other.controlId()) && Objects.equals(id(), other.id())
                && Objects.equals(dataSource(), other.dataSource()) && Objects.equals(author(), other.author())
                && Objects.equals(totalEvidence(), other.totalEvidence())
                && Objects.equals(assessmentReportSelectionCount(), other.assessmentReportSelectionCount())
                && Objects.equals(controlName(), other.controlName())
                && Objects.equals(evidenceResourcesIncludedCount(), other.evidenceResourcesIncludedCount())
                && Objects.equals(evidenceByTypeConfigurationDataCount(), other.evidenceByTypeConfigurationDataCount())
                && Objects.equals(evidenceByTypeManualCount(), other.evidenceByTypeManualCount())
                && Objects.equals(evidenceByTypeComplianceCheckCount(), other.evidenceByTypeComplianceCheckCount())
                && Objects.equals(evidenceByTypeComplianceCheckIssuesCount(), other.evidenceByTypeComplianceCheckIssuesCount())
                && Objects.equals(evidenceByTypeUserActivityCount(), other.evidenceByTypeUserActivityCount())
                && Objects.equals(evidenceAwsServiceSourceCount(), other.evidenceAwsServiceSourceCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssessmentEvidenceFolder").add("Name", name()).add("Date", date())
                .add("AssessmentId", assessmentId()).add("ControlSetId", controlSetId()).add("ControlId", controlId())
                .add("Id", id()).add("DataSource", dataSource()).add("Author", author()).add("TotalEvidence", totalEvidence())
                .add("AssessmentReportSelectionCount", assessmentReportSelectionCount()).add("ControlName", controlName())
                .add("EvidenceResourcesIncludedCount", evidenceResourcesIncludedCount())
                .add("EvidenceByTypeConfigurationDataCount", evidenceByTypeConfigurationDataCount())
                .add("EvidenceByTypeManualCount", evidenceByTypeManualCount())
                .add("EvidenceByTypeComplianceCheckCount", evidenceByTypeComplianceCheckCount())
                .add("EvidenceByTypeComplianceCheckIssuesCount", evidenceByTypeComplianceCheckIssuesCount())
                .add("EvidenceByTypeUserActivityCount", evidenceByTypeUserActivityCount())
                .add("EvidenceAwsServiceSourceCount", evidenceAwsServiceSourceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "date":
            return Optional.ofNullable(clazz.cast(date()));
        case "assessmentId":
            return Optional.ofNullable(clazz.cast(assessmentId()));
        case "controlSetId":
            return Optional.ofNullable(clazz.cast(controlSetId()));
        case "controlId":
            return Optional.ofNullable(clazz.cast(controlId()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "dataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "author":
            return Optional.ofNullable(clazz.cast(author()));
        case "totalEvidence":
            return Optional.ofNullable(clazz.cast(totalEvidence()));
        case "assessmentReportSelectionCount":
            return Optional.ofNullable(clazz.cast(assessmentReportSelectionCount()));
        case "controlName":
            return Optional.ofNullable(clazz.cast(controlName()));
        case "evidenceResourcesIncludedCount":
            return Optional.ofNullable(clazz.cast(evidenceResourcesIncludedCount()));
        case "evidenceByTypeConfigurationDataCount":
            return Optional.ofNullable(clazz.cast(evidenceByTypeConfigurationDataCount()));
        case "evidenceByTypeManualCount":
            return Optional.ofNullable(clazz.cast(evidenceByTypeManualCount()));
        case "evidenceByTypeComplianceCheckCount":
            return Optional.ofNullable(clazz.cast(evidenceByTypeComplianceCheckCount()));
        case "evidenceByTypeComplianceCheckIssuesCount":
            return Optional.ofNullable(clazz.cast(evidenceByTypeComplianceCheckIssuesCount()));
        case "evidenceByTypeUserActivityCount":
            return Optional.ofNullable(clazz.cast(evidenceByTypeUserActivityCount()));
        case "evidenceAwsServiceSourceCount":
            return Optional.ofNullable(clazz.cast(evidenceAwsServiceSourceCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentEvidenceFolder, T> g) {
        return obj -> g.apply((AssessmentEvidenceFolder) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssessmentEvidenceFolder> {
        /**
         * <p>
         * The name of the specified evidence folder.
         * </p>
         * 
         * @param name
         *        The name of the specified evidence folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The date when the first evidence was added to the evidence folder.
         * </p>
         * 
         * @param date
         *        The date when the first evidence was added to the evidence folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder date(Instant date);

        /**
         * <p>
         * The identifier for the specified assessment.
         * </p>
         * 
         * @param assessmentId
         *        The identifier for the specified assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentId(String assessmentId);

        /**
         * <p>
         * The identifier for the control set.
         * </p>
         * 
         * @param controlSetId
         *        The identifier for the control set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlSetId(String controlSetId);

        /**
         * <p>
         * The unique identifier for the specified control.
         * </p>
         * 
         * @param controlId
         *        The unique identifier for the specified control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlId(String controlId);

        /**
         * <p>
         * The identifier for the folder in which evidence is stored.
         * </p>
         * 
         * @param id
         *        The identifier for the folder in which evidence is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The AWS service from which the evidence was collected.
         * </p>
         * 
         * @param dataSource
         *        The AWS service from which the evidence was collected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(String dataSource);

        /**
         * <p>
         * The name of the user who created the evidence folder.
         * </p>
         * 
         * @param author
         *        The name of the user who created the evidence folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder author(String author);

        /**
         * <p>
         * The total amount of evidence in the evidence folder.
         * </p>
         * 
         * @param totalEvidence
         *        The total amount of evidence in the evidence folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalEvidence(Integer totalEvidence);

        /**
         * <p>
         * The total count of evidence included in the assessment report.
         * </p>
         * 
         * @param assessmentReportSelectionCount
         *        The total count of evidence included in the assessment report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentReportSelectionCount(Integer assessmentReportSelectionCount);

        /**
         * <p>
         * The name of the control.
         * </p>
         * 
         * @param controlName
         *        The name of the control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlName(String controlName);

        /**
         * <p>
         * The amount of evidence included in the evidence folder.
         * </p>
         * 
         * @param evidenceResourcesIncludedCount
         *        The amount of evidence included in the evidence folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceResourcesIncludedCount(Integer evidenceResourcesIncludedCount);

        /**
         * <p>
         * The number of evidence that falls under the configuration data category. This evidence is collected from
         * configuration snapshots of other AWS services such as Amazon EC2, Amazon S3, or IAM.
         * </p>
         * 
         * @param evidenceByTypeConfigurationDataCount
         *        The number of evidence that falls under the configuration data category. This evidence is collected
         *        from configuration snapshots of other AWS services such as Amazon EC2, Amazon S3, or IAM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceByTypeConfigurationDataCount(Integer evidenceByTypeConfigurationDataCount);

        /**
         * <p>
         * The number of evidence that falls under the manual category. This evidence is imported manually.
         * </p>
         * 
         * @param evidenceByTypeManualCount
         *        The number of evidence that falls under the manual category. This evidence is imported manually.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceByTypeManualCount(Integer evidenceByTypeManualCount);

        /**
         * <p>
         * The number of evidence that falls under the compliance check category. This evidence is collected from AWS
         * Config or AWS Security Hub.
         * </p>
         * 
         * @param evidenceByTypeComplianceCheckCount
         *        The number of evidence that falls under the compliance check category. This evidence is collected from
         *        AWS Config or AWS Security Hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceByTypeComplianceCheckCount(Integer evidenceByTypeComplianceCheckCount);

        /**
         * <p>
         * The total number of issues that were reported directly from AWS Security Hub, AWS Config, or both.
         * </p>
         * 
         * @param evidenceByTypeComplianceCheckIssuesCount
         *        The total number of issues that were reported directly from AWS Security Hub, AWS Config, or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceByTypeComplianceCheckIssuesCount(Integer evidenceByTypeComplianceCheckIssuesCount);

        /**
         * <p>
         * The number of evidence that falls under the user activity category. This evidence is collected from AWS
         * CloudTrail logs.
         * </p>
         * 
         * @param evidenceByTypeUserActivityCount
         *        The number of evidence that falls under the user activity category. This evidence is collected from
         *        AWS CloudTrail logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceByTypeUserActivityCount(Integer evidenceByTypeUserActivityCount);

        /**
         * <p>
         * The total number of AWS resources assessed to generate the evidence.
         * </p>
         * 
         * @param evidenceAwsServiceSourceCount
         *        The total number of AWS resources assessed to generate the evidence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evidenceAwsServiceSourceCount(Integer evidenceAwsServiceSourceCount);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Instant date;

        private String assessmentId;

        private String controlSetId;

        private String controlId;

        private String id;

        private String dataSource;

        private String author;

        private Integer totalEvidence;

        private Integer assessmentReportSelectionCount;

        private String controlName;

        private Integer evidenceResourcesIncludedCount;

        private Integer evidenceByTypeConfigurationDataCount;

        private Integer evidenceByTypeManualCount;

        private Integer evidenceByTypeComplianceCheckCount;

        private Integer evidenceByTypeComplianceCheckIssuesCount;

        private Integer evidenceByTypeUserActivityCount;

        private Integer evidenceAwsServiceSourceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentEvidenceFolder model) {
            name(model.name);
            date(model.date);
            assessmentId(model.assessmentId);
            controlSetId(model.controlSetId);
            controlId(model.controlId);
            id(model.id);
            dataSource(model.dataSource);
            author(model.author);
            totalEvidence(model.totalEvidence);
            assessmentReportSelectionCount(model.assessmentReportSelectionCount);
            controlName(model.controlName);
            evidenceResourcesIncludedCount(model.evidenceResourcesIncludedCount);
            evidenceByTypeConfigurationDataCount(model.evidenceByTypeConfigurationDataCount);
            evidenceByTypeManualCount(model.evidenceByTypeManualCount);
            evidenceByTypeComplianceCheckCount(model.evidenceByTypeComplianceCheckCount);
            evidenceByTypeComplianceCheckIssuesCount(model.evidenceByTypeComplianceCheckIssuesCount);
            evidenceByTypeUserActivityCount(model.evidenceByTypeUserActivityCount);
            evidenceAwsServiceSourceCount(model.evidenceAwsServiceSourceCount);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getDate() {
            return date;
        }

        @Override
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public final void setDate(Instant date) {
            this.date = date;
        }

        public final String getAssessmentId() {
            return assessmentId;
        }

        @Override
        public final Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            return this;
        }

        public final void setAssessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
        }

        public final String getControlSetId() {
            return controlSetId;
        }

        @Override
        public final Builder controlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
            return this;
        }

        public final void setControlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
        }

        public final String getControlId() {
            return controlId;
        }

        @Override
        public final Builder controlId(String controlId) {
            this.controlId = controlId;
            return this;
        }

        public final void setControlId(String controlId) {
            this.controlId = controlId;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getDataSource() {
            return dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        public final String getAuthor() {
            return author;
        }

        @Override
        public final Builder author(String author) {
            this.author = author;
            return this;
        }

        public final void setAuthor(String author) {
            this.author = author;
        }

        public final Integer getTotalEvidence() {
            return totalEvidence;
        }

        @Override
        public final Builder totalEvidence(Integer totalEvidence) {
            this.totalEvidence = totalEvidence;
            return this;
        }

        public final void setTotalEvidence(Integer totalEvidence) {
            this.totalEvidence = totalEvidence;
        }

        public final Integer getAssessmentReportSelectionCount() {
            return assessmentReportSelectionCount;
        }

        @Override
        public final Builder assessmentReportSelectionCount(Integer assessmentReportSelectionCount) {
            this.assessmentReportSelectionCount = assessmentReportSelectionCount;
            return this;
        }

        public final void setAssessmentReportSelectionCount(Integer assessmentReportSelectionCount) {
            this.assessmentReportSelectionCount = assessmentReportSelectionCount;
        }

        public final String getControlName() {
            return controlName;
        }

        @Override
        public final Builder controlName(String controlName) {
            this.controlName = controlName;
            return this;
        }

        public final void setControlName(String controlName) {
            this.controlName = controlName;
        }

        public final Integer getEvidenceResourcesIncludedCount() {
            return evidenceResourcesIncludedCount;
        }

        @Override
        public final Builder evidenceResourcesIncludedCount(Integer evidenceResourcesIncludedCount) {
            this.evidenceResourcesIncludedCount = evidenceResourcesIncludedCount;
            return this;
        }

        public final void setEvidenceResourcesIncludedCount(Integer evidenceResourcesIncludedCount) {
            this.evidenceResourcesIncludedCount = evidenceResourcesIncludedCount;
        }

        public final Integer getEvidenceByTypeConfigurationDataCount() {
            return evidenceByTypeConfigurationDataCount;
        }

        @Override
        public final Builder evidenceByTypeConfigurationDataCount(Integer evidenceByTypeConfigurationDataCount) {
            this.evidenceByTypeConfigurationDataCount = evidenceByTypeConfigurationDataCount;
            return this;
        }

        public final void setEvidenceByTypeConfigurationDataCount(Integer evidenceByTypeConfigurationDataCount) {
            this.evidenceByTypeConfigurationDataCount = evidenceByTypeConfigurationDataCount;
        }

        public final Integer getEvidenceByTypeManualCount() {
            return evidenceByTypeManualCount;
        }

        @Override
        public final Builder evidenceByTypeManualCount(Integer evidenceByTypeManualCount) {
            this.evidenceByTypeManualCount = evidenceByTypeManualCount;
            return this;
        }

        public final void setEvidenceByTypeManualCount(Integer evidenceByTypeManualCount) {
            this.evidenceByTypeManualCount = evidenceByTypeManualCount;
        }

        public final Integer getEvidenceByTypeComplianceCheckCount() {
            return evidenceByTypeComplianceCheckCount;
        }

        @Override
        public final Builder evidenceByTypeComplianceCheckCount(Integer evidenceByTypeComplianceCheckCount) {
            this.evidenceByTypeComplianceCheckCount = evidenceByTypeComplianceCheckCount;
            return this;
        }

        public final void setEvidenceByTypeComplianceCheckCount(Integer evidenceByTypeComplianceCheckCount) {
            this.evidenceByTypeComplianceCheckCount = evidenceByTypeComplianceCheckCount;
        }

        public final Integer getEvidenceByTypeComplianceCheckIssuesCount() {
            return evidenceByTypeComplianceCheckIssuesCount;
        }

        @Override
        public final Builder evidenceByTypeComplianceCheckIssuesCount(Integer evidenceByTypeComplianceCheckIssuesCount) {
            this.evidenceByTypeComplianceCheckIssuesCount = evidenceByTypeComplianceCheckIssuesCount;
            return this;
        }

        public final void setEvidenceByTypeComplianceCheckIssuesCount(Integer evidenceByTypeComplianceCheckIssuesCount) {
            this.evidenceByTypeComplianceCheckIssuesCount = evidenceByTypeComplianceCheckIssuesCount;
        }

        public final Integer getEvidenceByTypeUserActivityCount() {
            return evidenceByTypeUserActivityCount;
        }

        @Override
        public final Builder evidenceByTypeUserActivityCount(Integer evidenceByTypeUserActivityCount) {
            this.evidenceByTypeUserActivityCount = evidenceByTypeUserActivityCount;
            return this;
        }

        public final void setEvidenceByTypeUserActivityCount(Integer evidenceByTypeUserActivityCount) {
            this.evidenceByTypeUserActivityCount = evidenceByTypeUserActivityCount;
        }

        public final Integer getEvidenceAwsServiceSourceCount() {
            return evidenceAwsServiceSourceCount;
        }

        @Override
        public final Builder evidenceAwsServiceSourceCount(Integer evidenceAwsServiceSourceCount) {
            this.evidenceAwsServiceSourceCount = evidenceAwsServiceSourceCount;
            return this;
        }

        public final void setEvidenceAwsServiceSourceCount(Integer evidenceAwsServiceSourceCount) {
            this.evidenceAwsServiceSourceCount = evidenceAwsServiceSourceCount;
        }

        @Override
        public AssessmentEvidenceFolder build() {
            return new AssessmentEvidenceFolder(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
