/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.artifact.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.artifact.model.AgreementTermsCopier;
import software.amazon.awssdk.services.artifact.model.AgreementType;
import software.amazon.awssdk.services.artifact.model.CustomerAgreementState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomerAgreementSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomerAgreementSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CustomerAgreementSummary.getter(CustomerAgreementSummary::name)).setter(CustomerAgreementSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CustomerAgreementSummary.getter(CustomerAgreementSummary::arn)).setter(CustomerAgreementSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CustomerAgreementSummary.getter(CustomerAgreementSummary::id)).setter(CustomerAgreementSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> AGREEMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agreementArn").getter(CustomerAgreementSummary.getter(CustomerAgreementSummary::agreementArn)).setter(CustomerAgreementSummary.setter(Builder::agreementArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agreementArn").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsAccountId").getter(CustomerAgreementSummary.getter(CustomerAgreementSummary::awsAccountId)).setter(CustomerAgreementSummary.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()}).build();
    private static final SdkField<String> ORGANIZATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("organizationArn").getter(CustomerAgreementSummary.getter(CustomerAgreementSummary::organizationArn)).setter(CustomerAgreementSummary.setter(Builder::organizationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationArn").build()}).build();
    private static final SdkField<Instant> EFFECTIVE_START_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("effectiveStart").getter(CustomerAgreementSummary.getter(CustomerAgreementSummary::effectiveStart)).setter(CustomerAgreementSummary.setter(Builder::effectiveStart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveStart").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> EFFECTIVE_END_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("effectiveEnd").getter(CustomerAgreementSummary.getter(CustomerAgreementSummary::effectiveEnd)).setter(CustomerAgreementSummary.setter(Builder::effectiveEnd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveEnd").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(CustomerAgreementSummary.getter(CustomerAgreementSummary::stateAsString)).setter(CustomerAgreementSummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CustomerAgreementSummary.getter(CustomerAgreementSummary::description)).setter(CustomerAgreementSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> ACCEPTANCE_TERMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("acceptanceTerms").getter(CustomerAgreementSummary.getter(CustomerAgreementSummary::acceptanceTerms)).setter(CustomerAgreementSummary.setter(Builder::acceptanceTerms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptanceTerms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TERMINATE_TERMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("terminateTerms").getter(CustomerAgreementSummary.getter(CustomerAgreementSummary::terminateTerms)).setter(CustomerAgreementSummary.setter(Builder::terminateTerms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terminateTerms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(CustomerAgreementSummary.getter(CustomerAgreementSummary::typeAsString)).setter(CustomerAgreementSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, ID_FIELD, AGREEMENT_ARN_FIELD, AWS_ACCOUNT_ID_FIELD, ORGANIZATION_ARN_FIELD, EFFECTIVE_START_FIELD, EFFECTIVE_END_FIELD, STATE_FIELD, DESCRIPTION_FIELD, ACCEPTANCE_TERMS_FIELD, TERMINATE_TERMS_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomerAgreementSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String id;
    private final String agreementArn;
    private final String awsAccountId;
    private final String organizationArn;
    private final Instant effectiveStart;
    private final Instant effectiveEnd;
    private final String state;
    private final String description;
    private final List<String> acceptanceTerms;
    private final List<String> terminateTerms;
    private final String type;

    private CustomerAgreementSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.id = builder.id;
        this.agreementArn = builder.agreementArn;
        this.awsAccountId = builder.awsAccountId;
        this.organizationArn = builder.organizationArn;
        this.effectiveStart = builder.effectiveStart;
        this.effectiveEnd = builder.effectiveEnd;
        this.state = builder.state;
        this.description = builder.description;
        this.acceptanceTerms = builder.acceptanceTerms;
        this.terminateTerms = builder.terminateTerms;
        this.type = builder.type;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final String agreementArn() {
        return this.agreementArn;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String organizationArn() {
        return this.organizationArn;
    }

    public final Instant effectiveStart() {
        return this.effectiveStart;
    }

    public final Instant effectiveEnd() {
        return this.effectiveEnd;
    }

    public final CustomerAgreementState state() {
        return CustomerAgreementState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasAcceptanceTerms() {
        return this.acceptanceTerms != null && !(this.acceptanceTerms instanceof SdkAutoConstructList);
    }

    public final List<String> acceptanceTerms() {
        return this.acceptanceTerms;
    }

    public final boolean hasTerminateTerms() {
        return this.terminateTerms != null && !(this.terminateTerms instanceof SdkAutoConstructList);
    }

    public final List<String> terminateTerms() {
        return this.terminateTerms;
    }

    public final AgreementType type() {
        return AgreementType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.agreementArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveStart());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveEnd());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAcceptanceTerms() ? this.acceptanceTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTerminateTerms() ? this.terminateTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerAgreementSummary)) {
            return false;
        }
        CustomerAgreementSummary other = (CustomerAgreementSummary)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.agreementArn(), other.agreementArn()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.organizationArn(), other.organizationArn()) && Objects.equals(this.effectiveStart(), other.effectiveStart()) && Objects.equals(this.effectiveEnd(), other.effectiveEnd()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.description(), other.description()) && this.hasAcceptanceTerms() == other.hasAcceptanceTerms() && Objects.equals(this.acceptanceTerms(), other.acceptanceTerms()) && this.hasTerminateTerms() == other.hasTerminateTerms() && Objects.equals(this.terminateTerms(), other.terminateTerms()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CustomerAgreementSummary").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("AgreementArn", (Object)this.agreementArn()).add("AwsAccountId", (Object)this.awsAccountId()).add("OrganizationArn", (Object)this.organizationArn()).add("EffectiveStart", (Object)this.effectiveStart()).add("EffectiveEnd", (Object)this.effectiveEnd()).add("State", (Object)this.stateAsString()).add("Description", (Object)this.description()).add("AcceptanceTerms", this.hasAcceptanceTerms() ? this.acceptanceTerms() : null).add("TerminateTerms", this.hasTerminateTerms() ? this.terminateTerms() : null).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "agreementArn": {
                return Optional.ofNullable(clazz.cast(this.agreementArn()));
            }
            case "awsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "organizationArn": {
                return Optional.ofNullable(clazz.cast(this.organizationArn()));
            }
            case "effectiveStart": {
                return Optional.ofNullable(clazz.cast(this.effectiveStart()));
            }
            case "effectiveEnd": {
                return Optional.ofNullable(clazz.cast(this.effectiveEnd()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "acceptanceTerms": {
                return Optional.ofNullable(clazz.cast(this.acceptanceTerms()));
            }
            case "terminateTerms": {
                return Optional.ofNullable(clazz.cast(this.terminateTerms()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("agreementArn", AGREEMENT_ARN_FIELD);
        map.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("organizationArn", ORGANIZATION_ARN_FIELD);
        map.put("effectiveStart", EFFECTIVE_START_FIELD);
        map.put("effectiveEnd", EFFECTIVE_END_FIELD);
        map.put("state", STATE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("acceptanceTerms", ACCEPTANCE_TERMS_FIELD);
        map.put("terminateTerms", TERMINATE_TERMS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomerAgreementSummary, T> g) {
        return obj -> g.apply((CustomerAgreementSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String id;
        private String agreementArn;
        private String awsAccountId;
        private String organizationArn;
        private Instant effectiveStart;
        private Instant effectiveEnd;
        private String state;
        private String description;
        private List<String> acceptanceTerms = DefaultSdkAutoConstructList.getInstance();
        private List<String> terminateTerms = DefaultSdkAutoConstructList.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerAgreementSummary model) {
            this.name(model.name);
            this.arn(model.arn);
            this.id(model.id);
            this.agreementArn(model.agreementArn);
            this.awsAccountId(model.awsAccountId);
            this.organizationArn(model.organizationArn);
            this.effectiveStart(model.effectiveStart);
            this.effectiveEnd(model.effectiveEnd);
            this.state(model.state);
            this.description(model.description);
            this.acceptanceTerms(model.acceptanceTerms);
            this.terminateTerms(model.terminateTerms);
            this.type(model.type);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getAgreementArn() {
            return this.agreementArn;
        }

        public final void setAgreementArn(String agreementArn) {
            this.agreementArn = agreementArn;
        }

        @Override
        public final Builder agreementArn(String agreementArn) {
            this.agreementArn = agreementArn;
            return this;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getOrganizationArn() {
            return this.organizationArn;
        }

        public final void setOrganizationArn(String organizationArn) {
            this.organizationArn = organizationArn;
        }

        @Override
        public final Builder organizationArn(String organizationArn) {
            this.organizationArn = organizationArn;
            return this;
        }

        public final Instant getEffectiveStart() {
            return this.effectiveStart;
        }

        public final void setEffectiveStart(Instant effectiveStart) {
            this.effectiveStart = effectiveStart;
        }

        @Override
        public final Builder effectiveStart(Instant effectiveStart) {
            this.effectiveStart = effectiveStart;
            return this;
        }

        public final Instant getEffectiveEnd() {
            return this.effectiveEnd;
        }

        public final void setEffectiveEnd(Instant effectiveEnd) {
            this.effectiveEnd = effectiveEnd;
        }

        @Override
        public final Builder effectiveEnd(Instant effectiveEnd) {
            this.effectiveEnd = effectiveEnd;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CustomerAgreementState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getAcceptanceTerms() {
            if (this.acceptanceTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.acceptanceTerms;
        }

        public final void setAcceptanceTerms(Collection<String> acceptanceTerms) {
            this.acceptanceTerms = AgreementTermsCopier.copy(acceptanceTerms);
        }

        @Override
        public final Builder acceptanceTerms(Collection<String> acceptanceTerms) {
            this.acceptanceTerms = AgreementTermsCopier.copy(acceptanceTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceptanceTerms(String ... acceptanceTerms) {
            this.acceptanceTerms(Arrays.asList(acceptanceTerms));
            return this;
        }

        public final Collection<String> getTerminateTerms() {
            if (this.terminateTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.terminateTerms;
        }

        public final void setTerminateTerms(Collection<String> terminateTerms) {
            this.terminateTerms = AgreementTermsCopier.copy(terminateTerms);
        }

        @Override
        public final Builder terminateTerms(Collection<String> terminateTerms) {
            this.terminateTerms = AgreementTermsCopier.copy(terminateTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminateTerms(String ... terminateTerms) {
            this.terminateTerms(Arrays.asList(terminateTerms));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AgreementType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public CustomerAgreementSummary build() {
            return new CustomerAgreementSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomerAgreementSummary> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder agreementArn(String var1);

        public Builder awsAccountId(String var1);

        public Builder organizationArn(String var1);

        public Builder effectiveStart(Instant var1);

        public Builder effectiveEnd(Instant var1);

        public Builder state(String var1);

        public Builder state(CustomerAgreementState var1);

        public Builder description(String var1);

        public Builder acceptanceTerms(Collection<String> var1);

        public Builder acceptanceTerms(String ... var1);

        public Builder terminateTerms(Collection<String> var1);

        public Builder terminateTerms(String ... var1);

        public Builder type(String var1);

        public Builder type(AgreementType var1);
    }
}

