/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.artifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.artifact.model.ArtifactRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReportMetadataRequest
extends ArtifactRequest
implements ToCopyableBuilder<Builder, GetReportMetadataRequest> {
    private static final SdkField<String> REPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reportId").getter(GetReportMetadataRequest.getter(GetReportMetadataRequest::reportId)).setter(GetReportMetadataRequest.setter(Builder::reportId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("reportId").build()}).build();
    private static final SdkField<Long> REPORT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("reportVersion").getter(GetReportMetadataRequest.getter(GetReportMetadataRequest::reportVersion)).setter(GetReportMetadataRequest.setter(Builder::reportVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("reportVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_ID_FIELD, REPORT_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("reportId", REPORT_ID_FIELD);
            this.put("reportVersion", REPORT_VERSION_FIELD);
        }
    });
    private final String reportId;
    private final Long reportVersion;

    private GetReportMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.reportId = builder.reportId;
        this.reportVersion = builder.reportVersion;
    }

    public final String reportId() {
        return this.reportId;
    }

    public final Long reportVersion() {
        return this.reportVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reportId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReportMetadataRequest)) {
            return false;
        }
        GetReportMetadataRequest other = (GetReportMetadataRequest)((Object)obj);
        return Objects.equals(this.reportId(), other.reportId()) && Objects.equals(this.reportVersion(), other.reportVersion());
    }

    public final String toString() {
        return ToString.builder((String)"GetReportMetadataRequest").add("ReportId", (Object)this.reportId()).add("ReportVersion", (Object)this.reportVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reportId": {
                return Optional.ofNullable(clazz.cast(this.reportId()));
            }
            case "reportVersion": {
                return Optional.ofNullable(clazz.cast(this.reportVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetReportMetadataRequest, T> g) {
        return obj -> g.apply((GetReportMetadataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ArtifactRequest.BuilderImpl
    implements Builder {
        private String reportId;
        private Long reportVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReportMetadataRequest model) {
            super(model);
            this.reportId(model.reportId);
            this.reportVersion(model.reportVersion);
        }

        public final String getReportId() {
            return this.reportId;
        }

        public final void setReportId(String reportId) {
            this.reportId = reportId;
        }

        @Override
        public final Builder reportId(String reportId) {
            this.reportId = reportId;
            return this;
        }

        public final Long getReportVersion() {
            return this.reportVersion;
        }

        public final void setReportVersion(Long reportVersion) {
            this.reportVersion = reportVersion;
        }

        @Override
        public final Builder reportVersion(Long reportVersion) {
            this.reportVersion = reportVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetReportMetadataRequest build() {
            return new GetReportMetadataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ArtifactRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetReportMetadataRequest> {
        public Builder reportId(String var1);

        public Builder reportVersion(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

