/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.artifact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.artifact.model.ArtifactResponse;
import software.amazon.awssdk.services.artifact.model.ReportSummary;
import software.amazon.awssdk.services.artifact.model.ReportsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReportsResponse
extends ArtifactResponse
implements ToCopyableBuilder<Builder, ListReportsResponse> {
    private static final SdkField<List<ReportSummary>> REPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("reports").getter(ListReportsResponse.getter(ListReportsResponse::reports)).setter(ListReportsResponse.setter(Builder::reports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReportSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListReportsResponse.getter(ListReportsResponse::nextToken)).setter(ListReportsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("reports", REPORTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ReportSummary> reports;
    private final String nextToken;

    private ListReportsResponse(BuilderImpl builder) {
        super(builder);
        this.reports = builder.reports;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasReports() {
        return this.reports != null && !(this.reports instanceof SdkAutoConstructList);
    }

    public final List<ReportSummary> reports() {
        return this.reports;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReports() ? this.reports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReportsResponse)) {
            return false;
        }
        ListReportsResponse other = (ListReportsResponse)((Object)obj);
        return this.hasReports() == other.hasReports() && Objects.equals(this.reports(), other.reports()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListReportsResponse").add("Reports", this.hasReports() ? this.reports() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reports": {
                return Optional.ofNullable(clazz.cast(this.reports()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListReportsResponse, T> g) {
        return obj -> g.apply((ListReportsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ArtifactResponse.BuilderImpl
    implements Builder {
        private List<ReportSummary> reports = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReportsResponse model) {
            super(model);
            this.reports(model.reports);
            this.nextToken(model.nextToken);
        }

        public final List<ReportSummary.Builder> getReports() {
            List<ReportSummary.Builder> result = ReportsListCopier.copyToBuilder(this.reports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReports(Collection<ReportSummary.BuilderImpl> reports) {
            this.reports = ReportsListCopier.copyFromBuilder(reports);
        }

        @Override
        public final Builder reports(Collection<ReportSummary> reports) {
            this.reports = ReportsListCopier.copy(reports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reports(ReportSummary ... reports) {
            this.reports(Arrays.asList(reports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reports(Consumer<ReportSummary.Builder> ... reports) {
            this.reports(Stream.of(reports).map(c -> (ReportSummary)((ReportSummary.Builder)ReportSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListReportsResponse build() {
            return new ListReportsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ArtifactResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReportsResponse> {
        public Builder reports(Collection<ReportSummary> var1);

        public Builder reports(ReportSummary ... var1);

        public Builder reports(Consumer<ReportSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

