/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apptest.model.M2ManagedActionProperties;
import software.amazon.awssdk.services.apptest.model.M2ManagedActionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class M2ManagedApplicationStepInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, M2ManagedApplicationStepInput> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(M2ManagedApplicationStepInput.getter(M2ManagedApplicationStepInput::applicationId)).setter(M2ManagedApplicationStepInput.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<String> RUNTIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runtime").getter(M2ManagedApplicationStepInput.getter(M2ManagedApplicationStepInput::runtime)).setter(M2ManagedApplicationStepInput.setter(Builder::runtime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtime").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vpcEndpointServiceName").getter(M2ManagedApplicationStepInput.getter(M2ManagedApplicationStepInput::vpcEndpointServiceName)).setter(M2ManagedApplicationStepInput.setter(Builder::vpcEndpointServiceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcEndpointServiceName").build()}).build();
    private static final SdkField<Integer> LISTENER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("listenerPort").getter(M2ManagedApplicationStepInput.getter(M2ManagedApplicationStepInput::listenerPort)).setter(M2ManagedApplicationStepInput.setter(Builder::listenerPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listenerPort").build()}).build();
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionType").getter(M2ManagedApplicationStepInput.getter(M2ManagedApplicationStepInput::actionTypeAsString)).setter(M2ManagedApplicationStepInput.setter(Builder::actionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionType").build()}).build();
    private static final SdkField<M2ManagedActionProperties> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("properties").getter(M2ManagedApplicationStepInput.getter(M2ManagedApplicationStepInput::properties)).setter(M2ManagedApplicationStepInput.setter(Builder::properties)).constructor(M2ManagedActionProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, RUNTIME_FIELD, VPC_ENDPOINT_SERVICE_NAME_FIELD, LISTENER_PORT_FIELD, ACTION_TYPE_FIELD, PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = M2ManagedApplicationStepInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String applicationId;
    private final String runtime;
    private final String vpcEndpointServiceName;
    private final Integer listenerPort;
    private final String actionType;
    private final M2ManagedActionProperties properties;

    private M2ManagedApplicationStepInput(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.runtime = builder.runtime;
        this.vpcEndpointServiceName = builder.vpcEndpointServiceName;
        this.listenerPort = builder.listenerPort;
        this.actionType = builder.actionType;
        this.properties = builder.properties;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String runtime() {
        return this.runtime;
    }

    public final String vpcEndpointServiceName() {
        return this.vpcEndpointServiceName;
    }

    public final Integer listenerPort() {
        return this.listenerPort;
    }

    public final M2ManagedActionType actionType() {
        return M2ManagedActionType.fromValue(this.actionType);
    }

    public final String actionTypeAsString() {
        return this.actionType;
    }

    public final M2ManagedActionProperties properties() {
        return this.properties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtime());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.listenerPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.properties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof M2ManagedApplicationStepInput)) {
            return false;
        }
        M2ManagedApplicationStepInput other = (M2ManagedApplicationStepInput)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.runtime(), other.runtime()) && Objects.equals(this.vpcEndpointServiceName(), other.vpcEndpointServiceName()) && Objects.equals(this.listenerPort(), other.listenerPort()) && Objects.equals(this.actionTypeAsString(), other.actionTypeAsString()) && Objects.equals(this.properties(), other.properties());
    }

    public final String toString() {
        return ToString.builder((String)"M2ManagedApplicationStepInput").add("ApplicationId", (Object)this.applicationId()).add("Runtime", (Object)this.runtime()).add("VpcEndpointServiceName", (Object)this.vpcEndpointServiceName()).add("ListenerPort", (Object)this.listenerPort()).add("ActionType", (Object)this.actionTypeAsString()).add("Properties", (Object)this.properties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "runtime": {
                return Optional.ofNullable(clazz.cast(this.runtime()));
            }
            case "vpcEndpointServiceName": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointServiceName()));
            }
            case "listenerPort": {
                return Optional.ofNullable(clazz.cast(this.listenerPort()));
            }
            case "actionType": {
                return Optional.ofNullable(clazz.cast(this.actionTypeAsString()));
            }
            case "properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("runtime", RUNTIME_FIELD);
        map.put("vpcEndpointServiceName", VPC_ENDPOINT_SERVICE_NAME_FIELD);
        map.put("listenerPort", LISTENER_PORT_FIELD);
        map.put("actionType", ACTION_TYPE_FIELD);
        map.put("properties", PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<M2ManagedApplicationStepInput, T> g) {
        return obj -> g.apply((M2ManagedApplicationStepInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String runtime;
        private String vpcEndpointServiceName;
        private Integer listenerPort;
        private String actionType;
        private M2ManagedActionProperties properties;

        private BuilderImpl() {
        }

        private BuilderImpl(M2ManagedApplicationStepInput model) {
            this.applicationId(model.applicationId);
            this.runtime(model.runtime);
            this.vpcEndpointServiceName(model.vpcEndpointServiceName);
            this.listenerPort(model.listenerPort);
            this.actionType(model.actionType);
            this.properties(model.properties);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getRuntime() {
            return this.runtime;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        public final String getVpcEndpointServiceName() {
            return this.vpcEndpointServiceName;
        }

        public final void setVpcEndpointServiceName(String vpcEndpointServiceName) {
            this.vpcEndpointServiceName = vpcEndpointServiceName;
        }

        @Override
        public final Builder vpcEndpointServiceName(String vpcEndpointServiceName) {
            this.vpcEndpointServiceName = vpcEndpointServiceName;
            return this;
        }

        public final Integer getListenerPort() {
            return this.listenerPort;
        }

        public final void setListenerPort(Integer listenerPort) {
            this.listenerPort = listenerPort;
        }

        @Override
        public final Builder listenerPort(Integer listenerPort) {
            this.listenerPort = listenerPort;
            return this;
        }

        public final String getActionType() {
            return this.actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(M2ManagedActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final M2ManagedActionProperties.Builder getProperties() {
            return this.properties != null ? this.properties.toBuilder() : null;
        }

        public final void setProperties(M2ManagedActionProperties.BuilderImpl properties) {
            this.properties = properties != null ? properties.build() : null;
        }

        @Override
        public final Builder properties(M2ManagedActionProperties properties) {
            this.properties = properties;
            return this;
        }

        public M2ManagedApplicationStepInput build() {
            return new M2ManagedApplicationStepInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, M2ManagedApplicationStepInput> {
        public Builder applicationId(String var1);

        public Builder runtime(String var1);

        public Builder vpcEndpointServiceName(String var1);

        public Builder listenerPort(Integer var1);

        public Builder actionType(String var1);

        public Builder actionType(M2ManagedActionType var1);

        public Builder properties(M2ManagedActionProperties var1);

        default public Builder properties(Consumer<M2ManagedActionProperties.Builder> properties) {
            return this.properties((M2ManagedActionProperties)((M2ManagedActionProperties.Builder)M2ManagedActionProperties.builder().applyMutation(properties)).build());
        }
    }
}

