/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apptest.model.TestCaseLifecycle;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestCaseSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TestCaseSummary> {
    private static final SdkField<String> TEST_CASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testCaseId").getter(TestCaseSummary.getter(TestCaseSummary::testCaseId)).setter(TestCaseSummary.setter(Builder::testCaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseId").build()}).build();
    private static final SdkField<String> TEST_CASE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testCaseArn").getter(TestCaseSummary.getter(TestCaseSummary::testCaseArn)).setter(TestCaseSummary.setter(Builder::testCaseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(TestCaseSummary.getter(TestCaseSummary::name)).setter(TestCaseSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(TestCaseSummary.getter(TestCaseSummary::statusReason)).setter(TestCaseSummary.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Integer> LATEST_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("latestVersion").getter(TestCaseSummary.getter(TestCaseSummary::latestVersion)).setter(TestCaseSummary.setter(Builder::latestVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestVersion").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(TestCaseSummary.getter(TestCaseSummary::statusAsString)).setter(TestCaseSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(TestCaseSummary.getter(TestCaseSummary::creationTime)).setter(TestCaseSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdateTime").getter(TestCaseSummary.getter(TestCaseSummary::lastUpdateTime)).setter(TestCaseSummary.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_CASE_ID_FIELD, TEST_CASE_ARN_FIELD, NAME_FIELD, STATUS_REASON_FIELD, LATEST_VERSION_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TestCaseSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String testCaseId;
    private final String testCaseArn;
    private final String name;
    private final String statusReason;
    private final Integer latestVersion;
    private final String status;
    private final Instant creationTime;
    private final Instant lastUpdateTime;

    private TestCaseSummary(BuilderImpl builder) {
        this.testCaseId = builder.testCaseId;
        this.testCaseArn = builder.testCaseArn;
        this.name = builder.name;
        this.statusReason = builder.statusReason;
        this.latestVersion = builder.latestVersion;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    public final String testCaseId() {
        return this.testCaseId;
    }

    public final String testCaseArn() {
        return this.testCaseArn;
    }

    public final String name() {
        return this.name;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final Integer latestVersion() {
        return this.latestVersion;
    }

    public final TestCaseLifecycle status() {
        return TestCaseLifecycle.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.testCaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.testCaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestCaseSummary)) {
            return false;
        }
        TestCaseSummary other = (TestCaseSummary)obj;
        return Objects.equals(this.testCaseId(), other.testCaseId()) && Objects.equals(this.testCaseArn(), other.testCaseArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.latestVersion(), other.latestVersion()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime());
    }

    public final String toString() {
        return ToString.builder((String)"TestCaseSummary").add("TestCaseId", (Object)this.testCaseId()).add("TestCaseArn", (Object)this.testCaseArn()).add("Name", (Object)this.name()).add("StatusReason", (Object)this.statusReason()).add("LatestVersion", (Object)this.latestVersion()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testCaseId": {
                return Optional.ofNullable(clazz.cast(this.testCaseId()));
            }
            case "testCaseArn": {
                return Optional.ofNullable(clazz.cast(this.testCaseArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "latestVersion": {
                return Optional.ofNullable(clazz.cast(this.latestVersion()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("testCaseId", TEST_CASE_ID_FIELD);
        map.put("testCaseArn", TEST_CASE_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("latestVersion", LATEST_VERSION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastUpdateTime", LAST_UPDATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestCaseSummary, T> g) {
        return obj -> g.apply((TestCaseSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String testCaseId;
        private String testCaseArn;
        private String name;
        private String statusReason;
        private Integer latestVersion;
        private String status;
        private Instant creationTime;
        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TestCaseSummary model) {
            this.testCaseId(model.testCaseId);
            this.testCaseArn(model.testCaseArn);
            this.name(model.name);
            this.statusReason(model.statusReason);
            this.latestVersion(model.latestVersion);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.lastUpdateTime(model.lastUpdateTime);
        }

        public final String getTestCaseId() {
            return this.testCaseId;
        }

        public final void setTestCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
        }

        @Override
        public final Builder testCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
            return this;
        }

        public final String getTestCaseArn() {
            return this.testCaseArn;
        }

        public final void setTestCaseArn(String testCaseArn) {
            this.testCaseArn = testCaseArn;
        }

        @Override
        public final Builder testCaseArn(String testCaseArn) {
            this.testCaseArn = testCaseArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Integer getLatestVersion() {
            return this.latestVersion;
        }

        public final void setLatestVersion(Integer latestVersion) {
            this.latestVersion = latestVersion;
        }

        @Override
        public final Builder latestVersion(Integer latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TestCaseLifecycle status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public TestCaseSummary build() {
            return new TestCaseSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TestCaseSummary> {
        public Builder testCaseId(String var1);

        public Builder testCaseArn(String var1);

        public Builder name(String var1);

        public Builder statusReason(String var1);

        public Builder latestVersion(Integer var1);

        public Builder status(String var1);

        public Builder status(TestCaseLifecycle var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);
    }
}

