/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apptest.model.DataSet;
import software.amazon.awssdk.services.apptest.model.DataSetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompareDataSetsStepInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CompareDataSetsStepInput> {
    private static final SdkField<String> SOURCE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceLocation").getter(CompareDataSetsStepInput.getter(CompareDataSetsStepInput::sourceLocation)).setter(CompareDataSetsStepInput.setter(Builder::sourceLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceLocation").build()}).build();
    private static final SdkField<String> TARGET_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetLocation").getter(CompareDataSetsStepInput.getter(CompareDataSetsStepInput::targetLocation)).setter(CompareDataSetsStepInput.setter(Builder::targetLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetLocation").build()}).build();
    private static final SdkField<List<DataSet>> SOURCE_DATA_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceDataSets").getter(CompareDataSetsStepInput.getter(CompareDataSetsStepInput::sourceDataSets)).setter(CompareDataSetsStepInput.setter(Builder::sourceDataSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceDataSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSet>> TARGET_DATA_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetDataSets").getter(CompareDataSetsStepInput.getter(CompareDataSetsStepInput::targetDataSets)).setter(CompareDataSetsStepInput.setter(Builder::targetDataSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetDataSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_LOCATION_FIELD, TARGET_LOCATION_FIELD, SOURCE_DATA_SETS_FIELD, TARGET_DATA_SETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CompareDataSetsStepInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sourceLocation;
    private final String targetLocation;
    private final List<DataSet> sourceDataSets;
    private final List<DataSet> targetDataSets;

    private CompareDataSetsStepInput(BuilderImpl builder) {
        this.sourceLocation = builder.sourceLocation;
        this.targetLocation = builder.targetLocation;
        this.sourceDataSets = builder.sourceDataSets;
        this.targetDataSets = builder.targetDataSets;
    }

    public final String sourceLocation() {
        return this.sourceLocation;
    }

    public final String targetLocation() {
        return this.targetLocation;
    }

    public final boolean hasSourceDataSets() {
        return this.sourceDataSets != null && !(this.sourceDataSets instanceof SdkAutoConstructList);
    }

    public final List<DataSet> sourceDataSets() {
        return this.sourceDataSets;
    }

    public final boolean hasTargetDataSets() {
        return this.targetDataSets != null && !(this.targetDataSets instanceof SdkAutoConstructList);
    }

    public final List<DataSet> targetDataSets() {
        return this.targetDataSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceDataSets() ? this.sourceDataSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetDataSets() ? this.targetDataSets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompareDataSetsStepInput)) {
            return false;
        }
        CompareDataSetsStepInput other = (CompareDataSetsStepInput)obj;
        return Objects.equals(this.sourceLocation(), other.sourceLocation()) && Objects.equals(this.targetLocation(), other.targetLocation()) && this.hasSourceDataSets() == other.hasSourceDataSets() && Objects.equals(this.sourceDataSets(), other.sourceDataSets()) && this.hasTargetDataSets() == other.hasTargetDataSets() && Objects.equals(this.targetDataSets(), other.targetDataSets());
    }

    public final String toString() {
        return ToString.builder((String)"CompareDataSetsStepInput").add("SourceLocation", (Object)this.sourceLocation()).add("TargetLocation", (Object)this.targetLocation()).add("SourceDataSets", this.hasSourceDataSets() ? this.sourceDataSets() : null).add("TargetDataSets", this.hasTargetDataSets() ? this.targetDataSets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceLocation": {
                return Optional.ofNullable(clazz.cast(this.sourceLocation()));
            }
            case "targetLocation": {
                return Optional.ofNullable(clazz.cast(this.targetLocation()));
            }
            case "sourceDataSets": {
                return Optional.ofNullable(clazz.cast(this.sourceDataSets()));
            }
            case "targetDataSets": {
                return Optional.ofNullable(clazz.cast(this.targetDataSets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceLocation", SOURCE_LOCATION_FIELD);
        map.put("targetLocation", TARGET_LOCATION_FIELD);
        map.put("sourceDataSets", SOURCE_DATA_SETS_FIELD);
        map.put("targetDataSets", TARGET_DATA_SETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompareDataSetsStepInput, T> g) {
        return obj -> g.apply((CompareDataSetsStepInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceLocation;
        private String targetLocation;
        private List<DataSet> sourceDataSets = DefaultSdkAutoConstructList.getInstance();
        private List<DataSet> targetDataSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CompareDataSetsStepInput model) {
            this.sourceLocation(model.sourceLocation);
            this.targetLocation(model.targetLocation);
            this.sourceDataSets(model.sourceDataSets);
            this.targetDataSets(model.targetDataSets);
        }

        public final String getSourceLocation() {
            return this.sourceLocation;
        }

        public final void setSourceLocation(String sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        public final Builder sourceLocation(String sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        public final String getTargetLocation() {
            return this.targetLocation;
        }

        public final void setTargetLocation(String targetLocation) {
            this.targetLocation = targetLocation;
        }

        @Override
        public final Builder targetLocation(String targetLocation) {
            this.targetLocation = targetLocation;
            return this;
        }

        public final List<DataSet.Builder> getSourceDataSets() {
            List<DataSet.Builder> result = DataSetListCopier.copyToBuilder(this.sourceDataSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceDataSets(Collection<DataSet.BuilderImpl> sourceDataSets) {
            this.sourceDataSets = DataSetListCopier.copyFromBuilder(sourceDataSets);
        }

        @Override
        public final Builder sourceDataSets(Collection<DataSet> sourceDataSets) {
            this.sourceDataSets = DataSetListCopier.copy(sourceDataSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceDataSets(DataSet ... sourceDataSets) {
            this.sourceDataSets(Arrays.asList(sourceDataSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceDataSets(Consumer<DataSet.Builder> ... sourceDataSets) {
            this.sourceDataSets(Stream.of(sourceDataSets).map(c -> (DataSet)((DataSet.Builder)DataSet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSet.Builder> getTargetDataSets() {
            List<DataSet.Builder> result = DataSetListCopier.copyToBuilder(this.targetDataSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetDataSets(Collection<DataSet.BuilderImpl> targetDataSets) {
            this.targetDataSets = DataSetListCopier.copyFromBuilder(targetDataSets);
        }

        @Override
        public final Builder targetDataSets(Collection<DataSet> targetDataSets) {
            this.targetDataSets = DataSetListCopier.copy(targetDataSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetDataSets(DataSet ... targetDataSets) {
            this.targetDataSets(Arrays.asList(targetDataSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetDataSets(Consumer<DataSet.Builder> ... targetDataSets) {
            this.targetDataSets(Stream.of(targetDataSets).map(c -> (DataSet)((DataSet.Builder)DataSet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CompareDataSetsStepInput build() {
            return new CompareDataSetsStepInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CompareDataSetsStepInput> {
        public Builder sourceLocation(String var1);

        public Builder targetLocation(String var1);

        public Builder sourceDataSets(Collection<DataSet> var1);

        public Builder sourceDataSets(DataSet ... var1);

        public Builder sourceDataSets(Consumer<DataSet.Builder> ... var1);

        public Builder targetDataSets(Collection<DataSet> var1);

        public Builder targetDataSets(DataSet ... var1);

        public Builder targetDataSets(Consumer<DataSet.Builder> ... var1);
    }
}

