/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apptest.model.M2ManagedActionProperties;
import software.amazon.awssdk.services.apptest.model.M2ManagedActionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class M2ManagedApplicationAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, M2ManagedApplicationAction> {
    private static final SdkField<String> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resource").getter(M2ManagedApplicationAction.getter(M2ManagedApplicationAction::resource)).setter(M2ManagedApplicationAction.setter(Builder::resource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionType").getter(M2ManagedApplicationAction.getter(M2ManagedApplicationAction::actionTypeAsString)).setter(M2ManagedApplicationAction.setter(Builder::actionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionType").build()}).build();
    private static final SdkField<M2ManagedActionProperties> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("properties").getter(M2ManagedApplicationAction.getter(M2ManagedApplicationAction::properties)).setter(M2ManagedApplicationAction.setter(Builder::properties)).constructor(M2ManagedActionProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD, ACTION_TYPE_FIELD, PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = M2ManagedApplicationAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resource;
    private final String actionType;
    private final M2ManagedActionProperties properties;

    private M2ManagedApplicationAction(BuilderImpl builder) {
        this.resource = builder.resource;
        this.actionType = builder.actionType;
        this.properties = builder.properties;
    }

    public final String resource() {
        return this.resource;
    }

    public final M2ManagedActionType actionType() {
        return M2ManagedActionType.fromValue(this.actionType);
    }

    public final String actionTypeAsString() {
        return this.actionType;
    }

    public final M2ManagedActionProperties properties() {
        return this.properties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.properties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof M2ManagedApplicationAction)) {
            return false;
        }
        M2ManagedApplicationAction other = (M2ManagedApplicationAction)obj;
        return Objects.equals(this.resource(), other.resource()) && Objects.equals(this.actionTypeAsString(), other.actionTypeAsString()) && Objects.equals(this.properties(), other.properties());
    }

    public final String toString() {
        return ToString.builder((String)"M2ManagedApplicationAction").add("Resource", (Object)this.resource()).add("ActionType", (Object)this.actionTypeAsString()).add("Properties", (Object)this.properties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "actionType": {
                return Optional.ofNullable(clazz.cast(this.actionTypeAsString()));
            }
            case "properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resource", RESOURCE_FIELD);
        map.put("actionType", ACTION_TYPE_FIELD);
        map.put("properties", PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<M2ManagedApplicationAction, T> g) {
        return obj -> g.apply((M2ManagedApplicationAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resource;
        private String actionType;
        private M2ManagedActionProperties properties;

        private BuilderImpl() {
        }

        private BuilderImpl(M2ManagedApplicationAction model) {
            this.resource(model.resource);
            this.actionType(model.actionType);
            this.properties(model.properties);
        }

        public final String getResource() {
            return this.resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final String getActionType() {
            return this.actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(M2ManagedActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final M2ManagedActionProperties.Builder getProperties() {
            return this.properties != null ? this.properties.toBuilder() : null;
        }

        public final void setProperties(M2ManagedActionProperties.BuilderImpl properties) {
            this.properties = properties != null ? properties.build() : null;
        }

        @Override
        public final Builder properties(M2ManagedActionProperties properties) {
            this.properties = properties;
            return this;
        }

        public M2ManagedApplicationAction build() {
            return new M2ManagedApplicationAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, M2ManagedApplicationAction> {
        public Builder resource(String var1);

        public Builder actionType(String var1);

        public Builder actionType(M2ManagedActionType var1);

        public Builder properties(M2ManagedActionProperties var1);

        default public Builder properties(Consumer<M2ManagedActionProperties.Builder> properties) {
            return this.properties((M2ManagedActionProperties)((M2ManagedActionProperties.Builder)M2ManagedActionProperties.builder().applyMutation(properties)).build());
        }
    }
}

