/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apptest.model.ExportDataSetNamesCopier;
import software.amazon.awssdk.services.apptest.model.MainframeActionProperties;
import software.amazon.awssdk.services.apptest.model.MainframeResourceSummary;
import software.amazon.awssdk.services.apptest.model.ScriptSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TN3270StepInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TN3270StepInput> {
    private static final SdkField<MainframeResourceSummary> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resource").getter(TN3270StepInput.getter(TN3270StepInput::resource)).setter(TN3270StepInput.setter(Builder::resource)).constructor(MainframeResourceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final SdkField<ScriptSummary> SCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("script").getter(TN3270StepInput.getter(TN3270StepInput::script)).setter(TN3270StepInput.setter(Builder::script)).constructor(ScriptSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("script").build()}).build();
    private static final SdkField<List<String>> EXPORT_DATA_SET_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("exportDataSetNames").getter(TN3270StepInput.getter(TN3270StepInput::exportDataSetNames)).setter(TN3270StepInput.setter(Builder::exportDataSetNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportDataSetNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MainframeActionProperties> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("properties").getter(TN3270StepInput.getter(TN3270StepInput::properties)).setter(TN3270StepInput.setter(Builder::properties)).constructor(MainframeActionProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD, SCRIPT_FIELD, EXPORT_DATA_SET_NAMES_FIELD, PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TN3270StepInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final MainframeResourceSummary resource;
    private final ScriptSummary script;
    private final List<String> exportDataSetNames;
    private final MainframeActionProperties properties;

    private TN3270StepInput(BuilderImpl builder) {
        this.resource = builder.resource;
        this.script = builder.script;
        this.exportDataSetNames = builder.exportDataSetNames;
        this.properties = builder.properties;
    }

    public final MainframeResourceSummary resource() {
        return this.resource;
    }

    public final ScriptSummary script() {
        return this.script;
    }

    public final boolean hasExportDataSetNames() {
        return this.exportDataSetNames != null && !(this.exportDataSetNames instanceof SdkAutoConstructList);
    }

    public final List<String> exportDataSetNames() {
        return this.exportDataSetNames;
    }

    public final MainframeActionProperties properties() {
        return this.properties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.script());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExportDataSetNames() ? this.exportDataSetNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.properties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TN3270StepInput)) {
            return false;
        }
        TN3270StepInput other = (TN3270StepInput)obj;
        return Objects.equals(this.resource(), other.resource()) && Objects.equals(this.script(), other.script()) && this.hasExportDataSetNames() == other.hasExportDataSetNames() && Objects.equals(this.exportDataSetNames(), other.exportDataSetNames()) && Objects.equals(this.properties(), other.properties());
    }

    public final String toString() {
        return ToString.builder((String)"TN3270StepInput").add("Resource", (Object)this.resource()).add("Script", (Object)this.script()).add("ExportDataSetNames", this.hasExportDataSetNames() ? this.exportDataSetNames() : null).add("Properties", (Object)this.properties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "script": {
                return Optional.ofNullable(clazz.cast(this.script()));
            }
            case "exportDataSetNames": {
                return Optional.ofNullable(clazz.cast(this.exportDataSetNames()));
            }
            case "properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resource", RESOURCE_FIELD);
        map.put("script", SCRIPT_FIELD);
        map.put("exportDataSetNames", EXPORT_DATA_SET_NAMES_FIELD);
        map.put("properties", PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TN3270StepInput, T> g) {
        return obj -> g.apply((TN3270StepInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private MainframeResourceSummary resource;
        private ScriptSummary script;
        private List<String> exportDataSetNames = DefaultSdkAutoConstructList.getInstance();
        private MainframeActionProperties properties;

        private BuilderImpl() {
        }

        private BuilderImpl(TN3270StepInput model) {
            this.resource(model.resource);
            this.script(model.script);
            this.exportDataSetNames(model.exportDataSetNames);
            this.properties(model.properties);
        }

        public final MainframeResourceSummary.Builder getResource() {
            return this.resource != null ? this.resource.toBuilder() : null;
        }

        public final void setResource(MainframeResourceSummary.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(MainframeResourceSummary resource) {
            this.resource = resource;
            return this;
        }

        public final ScriptSummary.Builder getScript() {
            return this.script != null ? this.script.toBuilder() : null;
        }

        public final void setScript(ScriptSummary.BuilderImpl script) {
            this.script = script != null ? script.build() : null;
        }

        @Override
        public final Builder script(ScriptSummary script) {
            this.script = script;
            return this;
        }

        public final Collection<String> getExportDataSetNames() {
            if (this.exportDataSetNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exportDataSetNames;
        }

        public final void setExportDataSetNames(Collection<String> exportDataSetNames) {
            this.exportDataSetNames = ExportDataSetNamesCopier.copy(exportDataSetNames);
        }

        @Override
        public final Builder exportDataSetNames(Collection<String> exportDataSetNames) {
            this.exportDataSetNames = ExportDataSetNamesCopier.copy(exportDataSetNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportDataSetNames(String ... exportDataSetNames) {
            this.exportDataSetNames(Arrays.asList(exportDataSetNames));
            return this;
        }

        public final MainframeActionProperties.Builder getProperties() {
            return this.properties != null ? this.properties.toBuilder() : null;
        }

        public final void setProperties(MainframeActionProperties.BuilderImpl properties) {
            this.properties = properties != null ? properties.build() : null;
        }

        @Override
        public final Builder properties(MainframeActionProperties properties) {
            this.properties = properties;
            return this;
        }

        public TN3270StepInput build() {
            return new TN3270StepInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TN3270StepInput> {
        public Builder resource(MainframeResourceSummary var1);

        default public Builder resource(Consumer<MainframeResourceSummary.Builder> resource) {
            return this.resource((MainframeResourceSummary)((MainframeResourceSummary.Builder)MainframeResourceSummary.builder().applyMutation(resource)).build());
        }

        public Builder script(ScriptSummary var1);

        default public Builder script(Consumer<ScriptSummary.Builder> script) {
            return this.script((ScriptSummary)((ScriptSummary.Builder)ScriptSummary.builder().applyMutation(script)).build());
        }

        public Builder exportDataSetNames(Collection<String> var1);

        public Builder exportDataSetNames(String ... var1);

        public Builder properties(MainframeActionProperties var1);

        default public Builder properties(Consumer<MainframeActionProperties.Builder> properties) {
            return this.properties((MainframeActionProperties)((MainframeActionProperties.Builder)MainframeActionProperties.builder().applyMutation(properties)).build());
        }
    }
}

