/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.DefaultAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserPoolConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserPoolConfig> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userPoolId").getter(UserPoolConfig.getter(UserPoolConfig::userPoolId)).setter(UserPoolConfig.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPoolId").build()}).build();
    private static final SdkField<String> AWS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsRegion").getter(UserPoolConfig.getter(UserPoolConfig::awsRegion)).setter(UserPoolConfig.setter(Builder::awsRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsRegion").build()}).build();
    private static final SdkField<String> DEFAULT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultAction").getter(UserPoolConfig.getter(UserPoolConfig::defaultActionAsString)).setter(UserPoolConfig.setter(Builder::defaultAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultAction").build()}).build();
    private static final SdkField<String> APP_ID_CLIENT_REGEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appIdClientRegex").getter(UserPoolConfig.getter(UserPoolConfig::appIdClientRegex)).setter(UserPoolConfig.setter(Builder::appIdClientRegex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appIdClientRegex").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD, AWS_REGION_FIELD, DEFAULT_ACTION_FIELD, APP_ID_CLIENT_REGEX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UserPoolConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String userPoolId;
    private final String awsRegion;
    private final String defaultAction;
    private final String appIdClientRegex;

    private UserPoolConfig(BuilderImpl builder) {
        this.userPoolId = builder.userPoolId;
        this.awsRegion = builder.awsRegion;
        this.defaultAction = builder.defaultAction;
        this.appIdClientRegex = builder.appIdClientRegex;
    }

    public final String userPoolId() {
        return this.userPoolId;
    }

    public final String awsRegion() {
        return this.awsRegion;
    }

    public final DefaultAction defaultAction() {
        return DefaultAction.fromValue(this.defaultAction);
    }

    public final String defaultActionAsString() {
        return this.defaultAction;
    }

    public final String appIdClientRegex() {
        return this.appIdClientRegex;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.appIdClientRegex());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserPoolConfig)) {
            return false;
        }
        UserPoolConfig other = (UserPoolConfig)obj;
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.awsRegion(), other.awsRegion()) && Objects.equals(this.defaultActionAsString(), other.defaultActionAsString()) && Objects.equals(this.appIdClientRegex(), other.appIdClientRegex());
    }

    public final String toString() {
        return ToString.builder((String)"UserPoolConfig").add("UserPoolId", (Object)this.userPoolId()).add("AwsRegion", (Object)this.awsRegion()).add("DefaultAction", (Object)this.defaultActionAsString()).add("AppIdClientRegex", (Object)this.appIdClientRegex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "awsRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegion()));
            }
            case "defaultAction": {
                return Optional.ofNullable(clazz.cast(this.defaultActionAsString()));
            }
            case "appIdClientRegex": {
                return Optional.ofNullable(clazz.cast(this.appIdClientRegex()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("userPoolId", USER_POOL_ID_FIELD);
        map.put("awsRegion", AWS_REGION_FIELD);
        map.put("defaultAction", DEFAULT_ACTION_FIELD);
        map.put("appIdClientRegex", APP_ID_CLIENT_REGEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserPoolConfig, T> g) {
        return obj -> g.apply((UserPoolConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userPoolId;
        private String awsRegion;
        private String defaultAction;
        private String appIdClientRegex;

        private BuilderImpl() {
        }

        private BuilderImpl(UserPoolConfig model) {
            this.userPoolId(model.userPoolId);
            this.awsRegion(model.awsRegion);
            this.defaultAction(model.defaultAction);
            this.appIdClientRegex(model.appIdClientRegex);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final String getDefaultAction() {
            return this.defaultAction;
        }

        public final void setDefaultAction(String defaultAction) {
            this.defaultAction = defaultAction;
        }

        @Override
        public final Builder defaultAction(String defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        @Override
        public final Builder defaultAction(DefaultAction defaultAction) {
            this.defaultAction(defaultAction == null ? null : defaultAction.toString());
            return this;
        }

        public final String getAppIdClientRegex() {
            return this.appIdClientRegex;
        }

        public final void setAppIdClientRegex(String appIdClientRegex) {
            this.appIdClientRegex = appIdClientRegex;
        }

        @Override
        public final Builder appIdClientRegex(String appIdClientRegex) {
            this.appIdClientRegex = appIdClientRegex;
            return this;
        }

        public UserPoolConfig build() {
            return new UserPoolConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserPoolConfig> {
        public Builder userPoolId(String var1);

        public Builder awsRegion(String var1);

        public Builder defaultAction(String var1);

        public Builder defaultAction(DefaultAction var1);

        public Builder appIdClientRegex(String var1);
    }
}

