/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ElasticsearchDataSourceConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ElasticsearchDataSourceConfig> {
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpoint").getter(ElasticsearchDataSourceConfig.getter(ElasticsearchDataSourceConfig::endpoint)).setter(ElasticsearchDataSourceConfig.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final SdkField<String> AWS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsRegion").getter(ElasticsearchDataSourceConfig.getter(ElasticsearchDataSourceConfig::awsRegion)).setter(ElasticsearchDataSourceConfig.setter(Builder::awsRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_FIELD, AWS_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ElasticsearchDataSourceConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String endpoint;
    private final String awsRegion;

    private ElasticsearchDataSourceConfig(BuilderImpl builder) {
        this.endpoint = builder.endpoint;
        this.awsRegion = builder.awsRegion;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final String awsRegion() {
        return this.awsRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchDataSourceConfig)) {
            return false;
        }
        ElasticsearchDataSourceConfig other = (ElasticsearchDataSourceConfig)obj;
        return Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.awsRegion(), other.awsRegion());
    }

    public final String toString() {
        return ToString.builder((String)"ElasticsearchDataSourceConfig").add("Endpoint", (Object)this.endpoint()).add("AwsRegion", (Object)this.awsRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "awsRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("endpoint", ENDPOINT_FIELD);
        map.put("awsRegion", AWS_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ElasticsearchDataSourceConfig, T> g) {
        return obj -> g.apply((ElasticsearchDataSourceConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpoint;
        private String awsRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchDataSourceConfig model) {
            this.endpoint(model.endpoint);
            this.awsRegion(model.awsRegion);
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public ElasticsearchDataSourceConfig build() {
            return new ElasticsearchDataSourceConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ElasticsearchDataSourceConfig> {
        public Builder endpoint(String var1);

        public Builder awsRegion(String var1);
    }
}

