/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appsync.AppSyncAsyncClient;
import software.amazon.awssdk.services.appsync.internal.UserAgentUtils;
import software.amazon.awssdk.services.appsync.model.FunctionConfiguration;
import software.amazon.awssdk.services.appsync.model.ListFunctionsRequest;
import software.amazon.awssdk.services.appsync.model.ListFunctionsResponse;

public class ListFunctionsPublisher
implements SdkPublisher<ListFunctionsResponse> {
    private final AppSyncAsyncClient client;
    private final ListFunctionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFunctionsPublisher(AppSyncAsyncClient client, ListFunctionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFunctionsPublisher(AppSyncAsyncClient client, ListFunctionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFunctionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFunctionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FunctionConfiguration> functions() {
        Function<ListFunctionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.functions() != null) {
                return response.functions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFunctionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFunctionsResponseFetcher
    implements AsyncPageFetcher<ListFunctionsResponse> {
        private ListFunctionsResponseFetcher() {
        }

        public boolean hasNextPage(ListFunctionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFunctionsResponse> nextPage(ListFunctionsResponse previousPage) {
            if (previousPage == null) {
                return ListFunctionsPublisher.this.client.listFunctions(ListFunctionsPublisher.this.firstRequest);
            }
            return ListFunctionsPublisher.this.client.listFunctions((ListFunctionsRequest)((Object)ListFunctionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

