/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConflictHandlerType {
    OPTIMISTIC_CONCURRENCY("OPTIMISTIC_CONCURRENCY"),
    LAMBDA("LAMBDA"),
    AUTOMERGE("AUTOMERGE"),
    NONE("NONE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConflictHandlerType> VALUE_MAP;
    private final String value;

    private ConflictHandlerType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConflictHandlerType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConflictHandlerType> knownValues() {
        EnumSet<ConflictHandlerType> knownValues = EnumSet.allOf(ConflictHandlerType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConflictHandlerType.class, ConflictHandlerType::toString);
    }
}

