/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appsync.model.AppSyncResponse;
import software.amazon.awssdk.services.appsync.model.Resolver;
import software.amazon.awssdk.services.appsync.model.ResolversCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResolversResponse
extends AppSyncResponse
implements ToCopyableBuilder<Builder, ListResolversResponse> {
    private static final SdkField<List<Resolver>> RESOLVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resolvers").getter(ListResolversResponse.getter(ListResolversResponse::resolvers)).setter(ListResolversResponse.setter(Builder::resolvers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolvers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Resolver::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListResolversResponse.getter(ListResolversResponse::nextToken)).setter(ListResolversResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOLVERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Resolver> resolvers;
    private final String nextToken;

    private ListResolversResponse(BuilderImpl builder) {
        super(builder);
        this.resolvers = builder.resolvers;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasResolvers() {
        return this.resolvers != null && !(this.resolvers instanceof SdkAutoConstructList);
    }

    public final List<Resolver> resolvers() {
        return this.resolvers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResolvers() ? this.resolvers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResolversResponse)) {
            return false;
        }
        ListResolversResponse other = (ListResolversResponse)((Object)obj);
        return this.hasResolvers() == other.hasResolvers() && Objects.equals(this.resolvers(), other.resolvers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListResolversResponse").add("Resolvers", this.hasResolvers() ? this.resolvers() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resolvers": {
                return Optional.ofNullable(clazz.cast(this.resolvers()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResolversResponse, T> g) {
        return obj -> g.apply((ListResolversResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppSyncResponse.BuilderImpl
    implements Builder {
        private List<Resolver> resolvers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResolversResponse model) {
            super(model);
            this.resolvers(model.resolvers);
            this.nextToken(model.nextToken);
        }

        public final Collection<Resolver.Builder> getResolvers() {
            if (this.resolvers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resolvers != null ? (Collection)this.resolvers.stream().map(Resolver::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resolvers(Collection<Resolver> resolvers) {
            this.resolvers = ResolversCopier.copy(resolvers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolvers(Resolver ... resolvers) {
            this.resolvers(Arrays.asList(resolvers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolvers(Consumer<Resolver.Builder> ... resolvers) {
            this.resolvers(Stream.of(resolvers).map(c -> (Resolver)((Resolver.Builder)Resolver.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResolvers(Collection<Resolver.BuilderImpl> resolvers) {
            this.resolvers = ResolversCopier.copyFromBuilder(resolvers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListResolversResponse build() {
            return new ListResolversResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResolversResponse> {
        public Builder resolvers(Collection<Resolver> var1);

        public Builder resolvers(Resolver ... var1);

        public Builder resolvers(Consumer<Resolver.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

