/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The pipeline configuration for a resolver of kind <code>PIPELINE</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineConfig implements SdkPojo, Serializable, ToCopyableBuilder<PipelineConfig.Builder, PipelineConfig> {
    private static final SdkField<List<String>> FUNCTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("functions")
            .getter(getter(PipelineConfig::functions))
            .setter(setter(Builder::functions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> functions;

    private PipelineConfig(BuilderImpl builder) {
        this.functions = builder.functions;
    }

    /**
     * Returns true if the Functions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFunctions() {
        return functions != null && !(functions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>Function</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFunctions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>Function</code> objects.
     */
    public final List<String> functions() {
        return functions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFunctions() ? functions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineConfig)) {
            return false;
        }
        PipelineConfig other = (PipelineConfig) obj;
        return hasFunctions() == other.hasFunctions() && Objects.equals(functions(), other.functions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipelineConfig").add("Functions", hasFunctions() ? functions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "functions":
            return Optional.ofNullable(clazz.cast(functions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineConfig, T> g) {
        return obj -> g.apply((PipelineConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineConfig> {
        /**
         * <p>
         * A list of <code>Function</code> objects.
         * </p>
         * 
         * @param functions
         *        A list of <code>Function</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functions(Collection<String> functions);

        /**
         * <p>
         * A list of <code>Function</code> objects.
         * </p>
         * 
         * @param functions
         *        A list of <code>Function</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functions(String... functions);
    }

    static final class BuilderImpl implements Builder {
        private List<String> functions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineConfig model) {
            functions(model.functions);
        }

        public final Collection<String> getFunctions() {
            if (functions instanceof SdkAutoConstructList) {
                return null;
            }
            return functions;
        }

        @Override
        public final Builder functions(Collection<String> functions) {
            this.functions = FunctionsIdsCopier.copy(functions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functions(String... functions) {
            functions(Arrays.asList(functions));
            return this;
        }

        public final void setFunctions(Collection<String> functions) {
            this.functions = FunctionsIdsCopier.copy(functions);
        }

        @Override
        public PipelineConfig build() {
            return new PipelineConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
