/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.ConflictDetectionType;
import software.amazon.awssdk.services.appsync.model.ConflictHandlerType;
import software.amazon.awssdk.services.appsync.model.LambdaConflictHandlerConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SyncConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SyncConfig> {
    private static final SdkField<String> CONFLICT_HANDLER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("conflictHandler").getter(SyncConfig.getter(SyncConfig::conflictHandlerAsString)).setter(SyncConfig.setter(Builder::conflictHandler)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictHandler").build()}).build();
    private static final SdkField<String> CONFLICT_DETECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("conflictDetection").getter(SyncConfig.getter(SyncConfig::conflictDetectionAsString)).setter(SyncConfig.setter(Builder::conflictDetection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictDetection").build()}).build();
    private static final SdkField<LambdaConflictHandlerConfig> LAMBDA_CONFLICT_HANDLER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lambdaConflictHandlerConfig").getter(SyncConfig.getter(SyncConfig::lambdaConflictHandlerConfig)).setter(SyncConfig.setter(Builder::lambdaConflictHandlerConfig)).constructor(LambdaConflictHandlerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaConflictHandlerConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFLICT_HANDLER_FIELD, CONFLICT_DETECTION_FIELD, LAMBDA_CONFLICT_HANDLER_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String conflictHandler;
    private final String conflictDetection;
    private final LambdaConflictHandlerConfig lambdaConflictHandlerConfig;

    private SyncConfig(BuilderImpl builder) {
        this.conflictHandler = builder.conflictHandler;
        this.conflictDetection = builder.conflictDetection;
        this.lambdaConflictHandlerConfig = builder.lambdaConflictHandlerConfig;
    }

    public ConflictHandlerType conflictHandler() {
        return ConflictHandlerType.fromValue(this.conflictHandler);
    }

    public String conflictHandlerAsString() {
        return this.conflictHandler;
    }

    public ConflictDetectionType conflictDetection() {
        return ConflictDetectionType.fromValue(this.conflictDetection);
    }

    public String conflictDetectionAsString() {
        return this.conflictDetection;
    }

    public LambdaConflictHandlerConfig lambdaConflictHandlerConfig() {
        return this.lambdaConflictHandlerConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.conflictHandlerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.conflictDetectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaConflictHandlerConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SyncConfig)) {
            return false;
        }
        SyncConfig other = (SyncConfig)obj;
        return Objects.equals(this.conflictHandlerAsString(), other.conflictHandlerAsString()) && Objects.equals(this.conflictDetectionAsString(), other.conflictDetectionAsString()) && Objects.equals(this.lambdaConflictHandlerConfig(), other.lambdaConflictHandlerConfig());
    }

    public String toString() {
        return ToString.builder((String)"SyncConfig").add("ConflictHandler", (Object)this.conflictHandlerAsString()).add("ConflictDetection", (Object)this.conflictDetectionAsString()).add("LambdaConflictHandlerConfig", (Object)this.lambdaConflictHandlerConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "conflictHandler": {
                return Optional.ofNullable(clazz.cast(this.conflictHandlerAsString()));
            }
            case "conflictDetection": {
                return Optional.ofNullable(clazz.cast(this.conflictDetectionAsString()));
            }
            case "lambdaConflictHandlerConfig": {
                return Optional.ofNullable(clazz.cast(this.lambdaConflictHandlerConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SyncConfig, T> g) {
        return obj -> g.apply((SyncConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String conflictHandler;
        private String conflictDetection;
        private LambdaConflictHandlerConfig lambdaConflictHandlerConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(SyncConfig model) {
            this.conflictHandler(model.conflictHandler);
            this.conflictDetection(model.conflictDetection);
            this.lambdaConflictHandlerConfig(model.lambdaConflictHandlerConfig);
        }

        public final String getConflictHandler() {
            return this.conflictHandler;
        }

        @Override
        public final Builder conflictHandler(String conflictHandler) {
            this.conflictHandler = conflictHandler;
            return this;
        }

        @Override
        public final Builder conflictHandler(ConflictHandlerType conflictHandler) {
            this.conflictHandler(conflictHandler == null ? null : conflictHandler.toString());
            return this;
        }

        public final void setConflictHandler(String conflictHandler) {
            this.conflictHandler = conflictHandler;
        }

        public final String getConflictDetection() {
            return this.conflictDetection;
        }

        @Override
        public final Builder conflictDetection(String conflictDetection) {
            this.conflictDetection = conflictDetection;
            return this;
        }

        @Override
        public final Builder conflictDetection(ConflictDetectionType conflictDetection) {
            this.conflictDetection(conflictDetection == null ? null : conflictDetection.toString());
            return this;
        }

        public final void setConflictDetection(String conflictDetection) {
            this.conflictDetection = conflictDetection;
        }

        public final LambdaConflictHandlerConfig.Builder getLambdaConflictHandlerConfig() {
            return this.lambdaConflictHandlerConfig != null ? this.lambdaConflictHandlerConfig.toBuilder() : null;
        }

        @Override
        public final Builder lambdaConflictHandlerConfig(LambdaConflictHandlerConfig lambdaConflictHandlerConfig) {
            this.lambdaConflictHandlerConfig = lambdaConflictHandlerConfig;
            return this;
        }

        public final void setLambdaConflictHandlerConfig(LambdaConflictHandlerConfig.BuilderImpl lambdaConflictHandlerConfig) {
            this.lambdaConflictHandlerConfig = lambdaConflictHandlerConfig != null ? lambdaConflictHandlerConfig.build() : null;
        }

        public SyncConfig build() {
            return new SyncConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SyncConfig> {
        public Builder conflictHandler(String var1);

        public Builder conflictHandler(ConflictHandlerType var1);

        public Builder conflictDetection(String var1);

        public Builder conflictDetection(ConflictDetectionType var1);

        public Builder lambdaConflictHandlerConfig(LambdaConflictHandlerConfig var1);

        default public Builder lambdaConflictHandlerConfig(Consumer<LambdaConflictHandlerConfig.Builder> lambdaConflictHandlerConfig) {
            return this.lambdaConflictHandlerConfig((LambdaConflictHandlerConfig)((LambdaConflictHandlerConfig.Builder)LambdaConflictHandlerConfig.builder().applyMutation(lambdaConflictHandlerConfig)).build());
        }
    }
}

