/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Amazon DynamoDB data source configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DynamodbDataSourceConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DynamodbDataSourceConfig.Builder, DynamodbDataSourceConfig> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DynamodbDataSourceConfig::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()).build();

    private static final SdkField<String> AWS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DynamodbDataSourceConfig::awsRegion)).setter(setter(Builder::awsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsRegion").build()).build();

    private static final SdkField<Boolean> USE_CALLER_CREDENTIALS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DynamodbDataSourceConfig::useCallerCredentials)).setter(setter(Builder::useCallerCredentials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useCallerCredentials").build())
            .build();

    private static final SdkField<DeltaSyncConfig> DELTA_SYNC_CONFIG_FIELD = SdkField
            .<DeltaSyncConfig> builder(MarshallingType.SDK_POJO).getter(getter(DynamodbDataSourceConfig::deltaSyncConfig))
            .setter(setter(Builder::deltaSyncConfig)).constructor(DeltaSyncConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deltaSyncConfig").build()).build();

    private static final SdkField<Boolean> VERSIONED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DynamodbDataSourceConfig::versioned)).setter(setter(Builder::versioned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versioned").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD,
            AWS_REGION_FIELD, USE_CALLER_CREDENTIALS_FIELD, DELTA_SYNC_CONFIG_FIELD, VERSIONED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tableName;

    private final String awsRegion;

    private final Boolean useCallerCredentials;

    private final DeltaSyncConfig deltaSyncConfig;

    private final Boolean versioned;

    private DynamodbDataSourceConfig(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.awsRegion = builder.awsRegion;
        this.useCallerCredentials = builder.useCallerCredentials;
        this.deltaSyncConfig = builder.deltaSyncConfig;
        this.versioned = builder.versioned;
    }

    /**
     * <p>
     * The table name.
     * </p>
     * 
     * @return The table name.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The AWS Region.
     * </p>
     * 
     * @return The AWS Region.
     */
    public String awsRegion() {
        return awsRegion;
    }

    /**
     * <p>
     * Set to TRUE to use Amazon Cognito credentials with this data source.
     * </p>
     * 
     * @return Set to TRUE to use Amazon Cognito credentials with this data source.
     */
    public Boolean useCallerCredentials() {
        return useCallerCredentials;
    }

    /**
     * <p>
     * The <code>DeltaSyncConfig</code> for a versioned datasource.
     * </p>
     * 
     * @return The <code>DeltaSyncConfig</code> for a versioned datasource.
     */
    public DeltaSyncConfig deltaSyncConfig() {
        return deltaSyncConfig;
    }

    /**
     * <p>
     * Set to TRUE to use Conflict Detection and Resolution with this data source.
     * </p>
     * 
     * @return Set to TRUE to use Conflict Detection and Resolution with this data source.
     */
    public Boolean versioned() {
        return versioned;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(useCallerCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(deltaSyncConfig());
        hashCode = 31 * hashCode + Objects.hashCode(versioned());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamodbDataSourceConfig)) {
            return false;
        }
        DynamodbDataSourceConfig other = (DynamodbDataSourceConfig) obj;
        return Objects.equals(tableName(), other.tableName()) && Objects.equals(awsRegion(), other.awsRegion())
                && Objects.equals(useCallerCredentials(), other.useCallerCredentials())
                && Objects.equals(deltaSyncConfig(), other.deltaSyncConfig()) && Objects.equals(versioned(), other.versioned());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DynamodbDataSourceConfig").add("TableName", tableName()).add("AwsRegion", awsRegion())
                .add("UseCallerCredentials", useCallerCredentials()).add("DeltaSyncConfig", deltaSyncConfig())
                .add("Versioned", versioned()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "awsRegion":
            return Optional.ofNullable(clazz.cast(awsRegion()));
        case "useCallerCredentials":
            return Optional.ofNullable(clazz.cast(useCallerCredentials()));
        case "deltaSyncConfig":
            return Optional.ofNullable(clazz.cast(deltaSyncConfig()));
        case "versioned":
            return Optional.ofNullable(clazz.cast(versioned()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DynamodbDataSourceConfig, T> g) {
        return obj -> g.apply((DynamodbDataSourceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DynamodbDataSourceConfig> {
        /**
         * <p>
         * The table name.
         * </p>
         * 
         * @param tableName
         *        The table name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The AWS Region.
         * </p>
         * 
         * @param awsRegion
         *        The AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegion(String awsRegion);

        /**
         * <p>
         * Set to TRUE to use Amazon Cognito credentials with this data source.
         * </p>
         * 
         * @param useCallerCredentials
         *        Set to TRUE to use Amazon Cognito credentials with this data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useCallerCredentials(Boolean useCallerCredentials);

        /**
         * <p>
         * The <code>DeltaSyncConfig</code> for a versioned datasource.
         * </p>
         * 
         * @param deltaSyncConfig
         *        The <code>DeltaSyncConfig</code> for a versioned datasource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deltaSyncConfig(DeltaSyncConfig deltaSyncConfig);

        /**
         * <p>
         * The <code>DeltaSyncConfig</code> for a versioned datasource.
         * </p>
         * This is a convenience that creates an instance of the {@link DeltaSyncConfig.Builder} avoiding the need to
         * create one manually via {@link DeltaSyncConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeltaSyncConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #deltaSyncConfig(DeltaSyncConfig)}.
         * 
         * @param deltaSyncConfig
         *        a consumer that will call methods on {@link DeltaSyncConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deltaSyncConfig(DeltaSyncConfig)
         */
        default Builder deltaSyncConfig(Consumer<DeltaSyncConfig.Builder> deltaSyncConfig) {
            return deltaSyncConfig(DeltaSyncConfig.builder().applyMutation(deltaSyncConfig).build());
        }

        /**
         * <p>
         * Set to TRUE to use Conflict Detection and Resolution with this data source.
         * </p>
         * 
         * @param versioned
         *        Set to TRUE to use Conflict Detection and Resolution with this data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versioned(Boolean versioned);
    }

    static final class BuilderImpl implements Builder {
        private String tableName;

        private String awsRegion;

        private Boolean useCallerCredentials;

        private DeltaSyncConfig deltaSyncConfig;

        private Boolean versioned;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamodbDataSourceConfig model) {
            tableName(model.tableName);
            awsRegion(model.awsRegion);
            useCallerCredentials(model.useCallerCredentials);
            deltaSyncConfig(model.deltaSyncConfig);
            versioned(model.versioned);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getAwsRegion() {
            return awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        public final Boolean getUseCallerCredentials() {
            return useCallerCredentials;
        }

        @Override
        public final Builder useCallerCredentials(Boolean useCallerCredentials) {
            this.useCallerCredentials = useCallerCredentials;
            return this;
        }

        public final void setUseCallerCredentials(Boolean useCallerCredentials) {
            this.useCallerCredentials = useCallerCredentials;
        }

        public final DeltaSyncConfig.Builder getDeltaSyncConfig() {
            return deltaSyncConfig != null ? deltaSyncConfig.toBuilder() : null;
        }

        @Override
        public final Builder deltaSyncConfig(DeltaSyncConfig deltaSyncConfig) {
            this.deltaSyncConfig = deltaSyncConfig;
            return this;
        }

        public final void setDeltaSyncConfig(DeltaSyncConfig.BuilderImpl deltaSyncConfig) {
            this.deltaSyncConfig = deltaSyncConfig != null ? deltaSyncConfig.build() : null;
        }

        public final Boolean getVersioned() {
            return versioned;
        }

        @Override
        public final Builder versioned(Boolean versioned) {
            this.versioned = versioned;
            return this;
        }

        public final void setVersioned(Boolean versioned) {
            this.versioned = versioned;
        }

        @Override
        public DynamodbDataSourceConfig build() {
            return new DynamodbDataSourceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
